/*
 * Decompiled with CFR 0.152.
 */
package austeretony.enchcontrol.common.command;

public enum EnumCommandArg {
    HELP("help", new int[0]),
    LIST_ALL("list-all", 1),
    FILE_ALL("file-all", new int[0]),
    LIST_UNKNOWN("list-unknown", 1),
    FILE_UNKNOWN("file-unknown", new int[0]),
    CLEAR("clear", new int[0]),
    RELOAD("reload", new int[0]),
    BACKUP("backup", new int[0]),
    UPDATE("update", new int[0]),
    INFO("info", 1),
    EVAL("eval", 1);

    private final String arg;
    private final int argsAmount;

    private EnumCommandArg(String arg, int ... argsAmount) {
        this.argsAmount = argsAmount.length > 0 ? argsAmount[0] : 0;
        this.arg = arg;
    }

    public int getArgsAmount() {
        return this.argsAmount + 1;
    }

    public String getProcessingArgument(String ... commandArgs) {
        return commandArgs[this.getArgsAmount() - 1];
    }

    public static EnumCommandArg get(String ... commandArgs) {
        if (commandArgs.length == 0) {
            return null;
        }
        for (EnumCommandArg arg : EnumCommandArg.values()) {
            if (!arg.arg.equals(commandArgs[0]) || commandArgs.length != arg.getArgsAmount()) continue;
            return arg;
        }
        return null;
    }

    public String toString() {
        return this.arg;
    }
}

