/*
 * Decompiled with CFR 0.152.
 */
package com.mic.betterslimes.handlers;

import com.mic.betterslimes.BetterSlimes;
import com.mic.betterslimes.entity.EntityBetterSlime;
import com.mic.betterslimes.entity.ISpecialSlime;
import com.mic.betterslimes.entity.ModEntities;
import com.mic.betterslimes.entity.slimes.IceSlime;
import com.mic.betterslimes.entity.slimes.JungleSlime;
import com.mic.betterslimes.entity.slimes.Quazar;
import com.mic.betterslimes.entity.slimes.SandSlime;
import com.mic.betterslimes.items.ModItems;
import com.mic.betterslimes.sounds.ModSounds;
import com.mic.betterslimes.util.ModConfig;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        System.out.println("Registering items");
        for (Item item : ModItems.MOD_ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        System.out.println("Registering sounds");
        for (SoundEvent s : ModSounds.MOD_SOUNDS) {
            event.getRegistry().register((IForgeRegistryEntry)s);
        }
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        System.out.println("Registering entities");
        for (EntityEntry e : ModEntities.MOD_ENTITIES) {
            event.getRegistry().register((IForgeRegistryEntry)e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.MOD_ITEMS) {
            BetterSlimes.proxy.registerItemRenderer(item, 0, "inventory");
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof Quazar) {
            Quazar k = (Quazar)event.getEntity();
            k.func_70799_a(9, true);
            k.setAttackModifier(1.0);
            k.setHealthModifier(40.0);
        } else if (event.getEntity() instanceof EntityBetterSlime && !(event.getEntity() instanceof ISpecialSlime) && ModConfig.convertSlimes) {
            EntityBetterSlime s = (EntityBetterSlime)event.getEntity();
            if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY).contains(event.getWorld().func_180494_b(event.getEntity().func_180425_c())) && (ModConfig.convertIgnoreChance || ModConfig.iceSlime > 0)) {
                s = new IceSlime(event.getWorld());
            }
            if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE).contains(event.getWorld().func_180494_b(event.getEntity().func_180425_c())) && (ModConfig.convertIgnoreChance || ModConfig.jungleSlime > 0)) {
                s = new JungleSlime(event.getWorld());
            }
            if (BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DRY).contains(event.getWorld().func_180494_b(event.getEntity().func_180425_c())) && (ModConfig.convertIgnoreChance || ModConfig.sandSlime > 0)) {
                s = new SandSlime(event.getWorld());
            }
            if (!s.equals(event.getEntity())) {
                s.func_70012_b(event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, event.getEntity().field_70177_z, event.getEntity().field_70125_A);
                s.func_180482_a(event.getWorld().func_175649_E(event.getEntity().func_180425_c()), null);
                if (!event.getWorld().field_72995_K) {
                    event.getWorld().func_72838_d((Entity)s);
                }
                event.getEntity().func_184174_b(false);
                event.getEntity().func_70106_y();
            }
        }
    }
}

