/*
 * Decompiled with CFR 0.152.
 */
package com.mic.betterslimes.entity.slimes;

import com.mic.betterslimes.entity.EntityBetterSlime;
import com.mic.betterslimes.entity.ISpecialSlime;
import com.mic.betterslimes.entity.slimes.BlueSlime;
import com.mic.betterslimes.entity.slimes.KnightSlime;
import com.mic.betterslimes.util.LootTables;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Quazar
extends EntityBetterSlime
implements ISpecialSlime {
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private static final DataParameter<Integer> SPAWN_TIME = EntityDataManager.func_187226_a(Quazar.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final String NAME = "Quazar";
    public static final int MAX = Short.MAX_VALUE;
    protected boolean explode = false;
    public static float explodeDamage = 18.0f;
    public static int explodeRange = 32;
    Integer targetLastPosX = null;
    Integer targetLastPosZ = null;
    public static int leapCooldown;
    public static int leapWarning;
    public static float leapVelocityMultiplierY;
    public static float leapVelocityMultiplierXZ;
    public static float movementSpeedMultiplier;
    public static int size;
    private int timeSinceIgnited = 0;
    private int fuseTime = 30;
    private int combatTimer = 2;
    public int bossTimer = 160;
    private double movementSpeedAttribute;
    public static boolean configLoaded;
    public static boolean spawnMinions;
    public static String splitSlimeString;
    protected Class<? extends Entity> SplitSlime;
    private boolean wasOnGround = false;
    private static final DataParameter<Integer> STATE;

    public static void initConfig(Configuration config) {
        config.addCustomCategoryComment(NAME, "Configuration options for the Quazar boss");
        leapCooldown = config.getInt(NAME, "leapCooldown", 160, 0, Short.MAX_VALUE, "Cooldown between leap attacks in ticks");
        leapWarning = config.getInt(NAME, "leapWarning", 40, 0, Short.MAX_VALUE, "Length of the animation the boss does before leap attacks in ticks. \nMust be longer than leapCooldown");
        leapVelocityMultiplierY = config.getFloat(NAME, "leapVelocityMultiplierY", 1.0f, 0.0f, 32767.0f, "Vertical speed all entities affected by the leap attack get");
        leapVelocityMultiplierXZ = config.getFloat(NAME, "leapVelocityMultiplierXZ", 1.0f, 0.0f, 32767.0f, "Horizontal speed all entities affected by the leap attack get");
        explodeDamage = config.getFloat(NAME, "explodeDamage", 18.0f, 0.0f, 32767.0f, "Damage the leap attack deals");
        explodeRange = config.getInt(NAME, "explodeRange", 10, 0, Short.MAX_VALUE, "Range of the leap attack");
        movementSpeedMultiplier = config.getFloat(NAME, "movementSpeedMultiplier", 1.0f, 0.0f, 32767.0f, "Amount by which the movement speed of Quazar is multiplied");
        size = config.getInt(NAME, "movementSpeedMultiplier", 7, 0, Short.MAX_VALUE, "Amount by which the movement speed of Quazaris multiplied");
        spawnMinions = config.getBoolean(NAME, "spawnMinions", false, "Ability of the boss to summon little slaves to aid him in battle");
        if (!spawnMinions) {
            splitChance = 0;
        }
        splitSlimeString = config.getString(NAME, "slimeChildren", "betterslimes:blue_slime", "The type of slime the boss will split into on death\n Must be a BetterSlimes slime");
        damageMultiplier = config.getFloat(NAME, "damageMultiplier", 1.0f, 0.0f, 32767.0f, "Attack damage multiplier of Quazar");
        configLoaded = true;
    }

    public Quazar(World worldIn) {
        super(worldIn);
        this.setAttackModifier(1.0);
        this.setHealthModifier(26.0);
        this.func_70799_a(size, true);
        this.field_70178_ae = true;
        this.timeSinceIgnited = 0;
        this.fuseTime = 30;
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.setCreeperState(-1);
        this.movementSpeedAttribute = 0.1 * (double)movementSpeedMultiplier;
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.movementSpeedAttribute);
        this.SplitSlime = EntityList.getClass((ResourceLocation)new ResourceLocation(splitSlimeString));
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SPAWN_TIME, (Object)0);
        super.func_70088_a();
    }

    public int getSpawnTime() {
        return (Integer)this.field_70180_af.func_187225_a(SPAWN_TIME);
    }

    public void setSpawnTime(int time) {
        this.field_70180_af.func_187227_b(SPAWN_TIME, (Object)time);
    }

    @Override
    protected void func_70619_bc() {
        if (this.getSpawnTime() > 0) {
            int j1 = this.getSpawnTime() - 1;
            if (spawnMinions && j1 <= 0) {
                this.func_184185_a(this.func_184709_cY(), (float)((double)this.func_70599_aP() * 1.2), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
                for (int x = 0; x < 10; ++x) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SLIME, this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70163_u, 0.0, 0.0, 0.0, new int[0]);
                }
                for (int x = 0; x < 4; ++x) {
                    KnightSlime b = new KnightSlime(this.field_70170_p);
                    b.func_70799_a(2, true);
                    b.func_70012_b(this.field_70165_t + (double)this.field_70146_Z.nextInt(10) - 5.0, this.field_70163_u + (double)this.field_70146_Z.nextInt(1) + 1.0, this.field_70161_v + (double)this.field_70146_Z.nextInt(10) - 5.0, this.field_70177_z, this.field_70125_A);
                    this.field_70170_p.func_72838_d((Entity)b);
                }
            }
            this.setSpawnTime(j1);
        } else {
            this.setSpawnTime(240);
        }
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (configLoaded) {
            compound.func_74768_a("Spawn", this.getSpawnTime());
            compound.func_74768_a("leapCooldown", leapCooldown);
            compound.func_74768_a("leapWarning", leapWarning);
            compound.func_74776_a("leapVelocityMultiplierY", leapVelocityMultiplierY);
            compound.func_74776_a("leapVelocityMultiplierXZ", leapVelocityMultiplierXZ);
            compound.func_74776_a("explodeDamage", explodeDamage);
            compound.func_74768_a("explodeRange", explodeRange);
            compound.func_74757_a("spawnMinions", spawnMinions);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        if (compound.func_74764_b("Spawn")) {
            this.setSpawnTime(compound.func_74762_e("Spawn"));
        }
        if (configLoaded) {
            if (compound.func_74764_b("leapCooldown")) {
                leapCooldown = compound.func_74762_e("leapCooldown");
            }
            if (compound.func_74764_b("leapWarning")) {
                leapWarning = compound.func_74762_e("leapWarning");
            }
            if (compound.func_74764_b("leapVelocityMultiplierY")) {
                leapVelocityMultiplierY = compound.func_74760_g("leapVelocityMultiplierY");
            }
            if (compound.func_74764_b("leapVelocityMultiplierXZ")) {
                leapVelocityMultiplierXZ = compound.func_74760_g("leapVelocityMultiplierXZ");
            }
            if (compound.func_74764_b("explodeDamage")) {
                explodeDamage = compound.func_74760_g("explodeDamage");
            }
            if (compound.func_74764_b("explodeRange")) {
                explodeRange = compound.func_74762_e("explodeRange");
            }
            if (compound.func_74764_b("spawnMinions")) {
                spawnMinions = compound.func_74767_n("spawnMinions");
            }
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Override
    protected EntityBetterSlime createInstance() {
        if (EntityBetterSlime.class.isAssignableFrom(this.SplitSlime)) {
            return (EntityBetterSlime)((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(splitSlimeString))).newInstance(this.field_70170_p);
        }
        return new BlueSlime(this.field_70170_p);
    }

    public void func_70106_y() {
        if (!spawnMinions) {
            this.field_70128_L = true;
        } else {
            super.func_70106_y();
        }
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.func_72912_H().func_76067_t().handleSlimeSpawnReduction(this.field_70146_Z, this.field_70170_p)) {
            return false;
        }
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    protected int func_70805_n() {
        return (int)((double)super.func_70805_n() * this.attackMod);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.quazarLT;
    }

    protected void leap(EntityLivingBase leapTarget) {
        double d1;
        double d0;
        if (this.targetLastPosX != null && this.targetLastPosZ != null) {
            d0 = (double)this.targetLastPosX.intValue() - this.field_70165_t;
            d1 = (double)this.targetLastPosZ.intValue() - this.field_70161_v;
        } else {
            d0 = 0.0;
            d1 = 0.0;
        }
        this.func_184185_a(SoundEvents.field_187552_ah, 2.0f, 0.3f);
        this.func_184185_a(SoundEvents.field_187749_eC, 2.0f, 0.8f);
        this.func_70634_a(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v);
        if (!this.field_70170_p.field_72995_K) {
            this.field_70159_w = d0 / 7.0;
            this.field_70181_x = 2.0;
            this.field_70179_y = d1 / 7.0;
        }
    }

    private void explode() {
        if (!this.explode) {
            return;
        }
        this.explode = false;
        this.targetLastPosX = null;
        this.targetLastPosZ = null;
        List e = this.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b((double)explodeRange, 32.0, (double)explodeRange), entity -> true);
        for (EntityLivingBase entity2 : e) {
            double dist = this.func_70068_e((Entity)entity2) + 1.0;
            if (entity2 == this || !(this.func_70032_d((Entity)entity2) < (float)explodeRange)) continue;
            entity2.func_70634_a(entity2.field_70165_t, entity2.field_70163_u + 1.5, entity2.field_70161_v);
            entity2.func_70024_g(0.8 / (entity2.field_70165_t - this.field_70165_t) * (double)leapVelocityMultiplierXZ, MathHelper.func_151237_a((double)(32.0 / dist * (double)leapVelocityMultiplierY), (double)1.0, (double)16.0), 0.8 / (entity2.field_70161_v - this.field_70161_v) * (double)leapVelocityMultiplierXZ);
            entity2.field_70133_I = true;
            entity2.func_70097_a(DamageSource.field_76377_j, (float)((double)explodeDamage / (dist + 1.0)));
            entity2.func_130011_c((Entity)this);
            if (entity2.func_184191_r((Entity)this)) continue;
            entity2.func_70604_c((EntityLivingBase)this);
        }
    }

    protected void bossAbility(EntityLivingBase leapTarget) {
        double dist = this.func_70068_e((Entity)leapTarget);
        if (dist < 40.0) {
            this.func_70661_as().func_75499_g();
        }
        if (this.bossTimer > 0) {
            --this.bossTimer;
        }
        if (this.bossTimer == leapWarning) {
            if (dist < 516.0) {
                this.targetLastPosX = (int)leapTarget.field_70165_t;
                this.targetLastPosZ = (int)leapTarget.field_70161_v;
                this.func_184185_a(SoundEvents.field_187572_ar, 2.0f, 0.8f);
                this.setCreeperState(1);
            } else if (this.bossTimer < leapCooldown) {
                ++this.bossTimer;
            }
        }
        if (this.bossTimer <= leapWarning && this.bossTimer > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.movementSpeedAttribute);
        }
        if (this.bossTimer < 1) {
            this.leap(leapTarget);
            this.bossTimer = leapCooldown;
            this.combatTimer = 2;
            this.timeSinceIgnited = 0;
            this.fuseTime = 30;
            this.setCreeperState(-1);
            this.explode = true;
        }
    }

    protected boolean spawnCustomParticles() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        int i;
        if (this.field_70122_E && !this.wasOnGround) {
            i = this.func_70809_q();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.field_70170_p;
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                world.func_175688_a(EnumParticleTypes.ITEM_CRACK, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[]{Item.func_150891_b((Item)Item.func_111206_d((String)"betterslimes:red_slime"))});
                if (j % 2 != 0) continue;
                world.func_175688_a(EnumParticleTypes.LAVA, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        this.wasOnGround = this.field_70122_E;
        if (this.func_70089_S()) {
            if (this.bossTimer <= leapWarning) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.7f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70122_E) {
            if (this.combatTimer < 1) {
                if (this.explode) {
                    this.explode();
                }
                this.combatTimer = 2;
            } else {
                --this.combatTimer;
            }
        }
        if (this.func_70638_az() != null) {
            this.bossAbility(this.func_70638_az());
        } else {
            this.bossTimer = leapCooldown;
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.movementSpeedAttribute);
        }
    }

    public void func_70110_aj() {
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70090_H() {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source == DamageSource.field_76379_h) {
            return true;
        }
        return super.func_180431_b(source);
    }

    static {
        size = 7;
        configLoaded = false;
        STATE = EntityDataManager.func_187226_a(Quazar.class, (DataSerializer)DataSerializers.field_187192_b);
    }
}

