/*
 * Decompiled with CFR 0.152.
 */
package com.mic.betterslimes.entity;

import com.mic.betterslimes.entity.slimes.BlackSlime;
import com.mic.betterslimes.entity.slimes.BlueSlime;
import com.mic.betterslimes.entity.slimes.GoldSlime;
import com.mic.betterslimes.entity.slimes.HauntedSlime;
import com.mic.betterslimes.entity.slimes.IceSlime;
import com.mic.betterslimes.entity.slimes.IronSlime;
import com.mic.betterslimes.entity.slimes.JungleSlime;
import com.mic.betterslimes.entity.slimes.KnightSlime;
import com.mic.betterslimes.entity.slimes.PurpleSlime;
import com.mic.betterslimes.entity.slimes.Quazar;
import com.mic.betterslimes.entity.slimes.RedSlime;
import com.mic.betterslimes.entity.slimes.SandSlime;
import com.mic.betterslimes.entity.slimes.SpectralSlime;
import com.mic.betterslimes.entity.slimes.YellowSlime;
import com.mic.betterslimes.util.ModConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ModEntities {
    public static final List<EntityEntry> MOD_ENTITIES = new ArrayList<EntityEntry>();
    private static int idCounter = 111;

    private static void registerEntity(String name, Class<? extends Entity> entity, int range, int colorOne, int colorTwo) {
        ModEntities.registerEntity(name, entity, range, colorOne, colorTwo, 0, 0, 0, null, (Iterable<Biome>)null);
    }

    private static void registerEntity(String name, Class<? extends Entity> entity, int range, int colorOne, int colorTwo, int spawnChance, int groupMin, int groupMax, EnumCreatureType type, Biome ... biomes) {
        ModEntities.registerEntity(name, entity, range, colorOne, colorTwo, spawnChance, groupMin, groupMax, type, Arrays.asList(biomes));
    }

    private static void registerEntity(String name, Class<? extends Entity> entity, int range, int colorOne, int colorTwo, int spawnChance, int groupMin, int groupMax, EnumCreatureType type, Iterable<Biome> biomes) {
        EntityEntryBuilder builder = EntityEntryBuilder.create().name(name).entity(entity).id(new ResourceLocation("betterslimes:" + name), idCounter).tracker(range, 1, true).egg(colorOne, colorTwo);
        if (spawnChance > 0) {
            builder = builder.spawn(type, spawnChance, groupMin, groupMax, biomes);
        }
        MOD_ENTITIES.add(builder.build());
        ++idCounter;
    }

    public static void registerEntities() {
        int view = 60;
        Set<Biome> genericBiomes = ModEntities.excludeHellAndSky(ForgeRegistries.BIOMES.getValuesCollection());
        ModEntities.registerEntity("blue_slime", BlueSlime.class, view, 1186255, 255, ModConfig.blueSlime, 0, 6, EnumCreatureType.MONSTER, genericBiomes);
        ModEntities.registerEntity("red_slime", RedSlime.class, view, 12072506, 0xFF0000, ModConfig.redSlime, 0, 5, EnumCreatureType.MONSTER, genericBiomes);
        ModEntities.registerEntity("yellow_slime", YellowSlime.class, view, 13417984, 0xFFFF00, ModConfig.yellowSlime, 0, 4, EnumCreatureType.MONSTER, genericBiomes);
        ModEntities.registerEntity("black_slime", BlackSlime.class, view, 0x363535, 0, ModConfig.blackSlime, 0, 6, EnumCreatureType.MONSTER, genericBiomes);
        ModEntities.registerEntity("purple_slime", PurpleSlime.class, view, 10106269, 9765015, ModConfig.purpleSlime, 0, 4, EnumCreatureType.MONSTER, genericBiomes);
        ModEntities.registerEntity("ice_slime", IceSlime.class, view, 4293887, 4306175, ModConfig.iceSlime, 0, 6, EnumCreatureType.MONSTER, ModEntities.excludeHellAndSky(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)));
        ModEntities.registerEntity("jungle_slime", JungleSlime.class, view, 30464, 55808, ModConfig.jungleSlime, 0, 6, EnumCreatureType.MONSTER, ModEntities.excludeHellAndSky(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)));
        ModEntities.registerEntity("sand_slime", SandSlime.class, view, 13024949, 14802613, ModConfig.sandSlime, 0, 6, EnumCreatureType.MONSTER, ModEntities.excludeHellAndSky(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.DRY)));
        ModEntities.registerEntity("spectral_slime", SpectralSlime.class, view, 10106269, 0, ModConfig.spectralSlime, 0, 1, EnumCreatureType.MONSTER, Biomes.field_76779_k);
        ModEntities.registerEntity("quazar", Quazar.class, view, 1186255, 0xFFFF00, ModConfig.kingChance, 0, 1, EnumCreatureType.MONSTER, ModEntities.excludeHellAndSky(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)));
        ModEntities.registerEntity("iron_slime", IronSlime.class, view, 7172208, 11382677, ModConfig.ironSlime, 0, 2, EnumCreatureType.MONSTER, genericBiomes);
        ModEntities.registerEntity("gold_slime", GoldSlime.class, view, 14404608, 0xFFFF00, ModConfig.goldSlime, 0, 3, EnumCreatureType.MONSTER, genericBiomes);
        ModEntities.registerEntity("knight_slime", KnightSlime.class, view, 7172208, 255, ModConfig.knightSlime, 0, 7, EnumCreatureType.MONSTER, genericBiomes);
        ModEntities.registerEntity("haunted_slime", HauntedSlime.class, view, 12072506, 0, ModConfig.hauntedSlime, 0, 1, EnumCreatureType.MONSTER, Biomes.field_76778_j);
    }

    private static Set<Biome> excludeHellAndSky(Collection<Biome> c) {
        HashSet<Biome> s = new HashSet<Biome>(c);
        s.remove(Biomes.field_76778_j);
        s.remove(Biomes.field_76779_k);
        return s;
    }
}

