/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.render.sprite.SpritesheetFactory;
import pl.asie.charset.lib.wires.IWireRenderContainer;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireRenderHandler;
import pl.asie.charset.lib.wires.WireRenderHandlerDefault;
import pl.asie.simplelogic.wires.logic.PartWireBundled;

public class WireRenderHandlerOverlay
extends WireRenderHandler
implements IWireRenderContainer {
    private static final float EPSILON = 9.765625E-4f;
    private final WireRenderHandler defaultHandler;
    private final WireRenderHandler colorHandler;
    private TextureAtlasSprite top;

    public WireRenderHandlerOverlay(WireProvider provider, boolean isColored) {
        super(provider);
        this.defaultHandler = new WireRenderHandlerDefault(provider);
        this.colorHandler = isColored ? new Color(provider) : null;
    }

    public boolean isTranslucent() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float getWidth() {
        return this.provider.getWidth() + 9.765625E-4f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeight() {
        return this.provider.getHeight() + 9.765625E-4f;
    }

    @SideOnly(value=Side.CLIENT)
    public void refresh(TextureMap map) {
        this.top = map.func_174942_a(new ResourceLocation(this.provider.getTexturePrefix().toString() + "_overlay"));
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(WireRenderHandler.TextureType type, Wire wire, EnumFacing facing, int connMask) {
        return type == WireRenderHandler.TextureType.TOP && this.getColor(type, wire, facing) != 0 ? this.top : null;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor(WireRenderHandler.TextureType type, Wire wire, @Nullable EnumFacing direction) {
        if (direction == null || !(wire instanceof PartWireBundled) || wire.getLocation() == WireFace.CENTER) {
            return 0;
        }
        int[] cache = ((PartWireBundled)wire).getInsulatedColorCache();
        if (cache == null) {
            return 0;
        }
        int v = cache[direction.ordinal()];
        if (v < 0) {
            return 0;
        }
        int c = 0xFF000000 | EnumDyeColor.func_176764_b((int)v).func_193350_e();
        return c & 0xFF00FF00 | c >> 16 & 0xFF | c << 16 & 0xFF0000;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isTopSimple() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLayerCount() {
        return this.colorHandler != null ? 3 : 2;
    }

    @SideOnly(value=Side.CLIENT)
    public WireRenderHandler get(int layer) {
        if (this.colorHandler != null && layer == 1) {
            return this.colorHandler;
        }
        return layer > 0 ? this : this.defaultHandler;
    }

    public static class Color
    extends WireRenderHandler {
        @Nonnull
        private TextureAtlasSprite[] top;

        public Color(WireProvider provider) {
            super(provider);
        }

        public boolean isTranslucent() {
            return false;
        }

        public void refresh(TextureMap map) {
            this.top = SpritesheetFactory.register((TextureMap)map, (ResourceLocation)new ResourceLocation("simplelogic", "blocks/wire/wire_bundled_colored_top"), (int)4, (int)4);
        }

        public TextureAtlasSprite getTexture(WireRenderHandler.TextureType type, Wire wire, EnumFacing facing, int connMask) {
            if (type != WireRenderHandler.TextureType.TOP) {
                return null;
            }
            return this.top[connMask & 0xF];
        }

        public int getColor(WireRenderHandler.TextureType type, Wire wire, @Nullable EnumFacing direction) {
            return wire instanceof PartWireBundled ? ((PartWireBundled)wire).getBundledRenderColor() : -1;
        }
    }
}

