/*
 * Decompiled with CFR 0.152.
 */
package crafttweakerutils.world;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import crafttweakerutils.world.IExplosion;
import crafttweakerutils.world.IGameRules;
import crafttweakerutils.world.MCExplosion;
import crafttweakerutils.world.MCGameRules;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ctutils.world.World")
@ZenExpansion(value="crafttweaker.world.IWorld")
public class World {
    @ZenMethod
    public static boolean canSeeSky(IWorld world, IBlockPos pos) {
        BlockPos p = (BlockPos)pos.getInternal();
        net.minecraft.world.World w = (net.minecraft.world.World)world.getInternal();
        return w.func_175678_i(p);
    }

    @ZenMethod
    public static boolean canSnowAt(IWorld world, IBlockPos pos, boolean lightCheck) {
        BlockPos p = (BlockPos)pos.getInternal();
        net.minecraft.world.World w = (net.minecraft.world.World)world.getInternal();
        return w.func_175708_f(p, lightCheck);
    }

    @ZenMethod
    public static boolean canBlockFreeze(IWorld world, IBlockPos pos, boolean noWaterAdj) {
        BlockPos p = (BlockPos)pos.getInternal();
        net.minecraft.world.World w = (net.minecraft.world.World)world.getInternal();
        return w.func_175670_e(p, noWaterAdj);
    }

    @ZenMethod
    public static IGameRules getGameRules(IWorld world) {
        net.minecraft.world.World w = (net.minecraft.world.World)world.getInternal();
        return new MCGameRules(w.func_82736_K());
    }

    @ZenMethod
    public static IExplosion newExplosion(IWorld world, IEntity entity, double x, double y, double z, float strength, boolean isFlaming, boolean isSmoking) {
        net.minecraft.world.World w = (net.minecraft.world.World)world.getInternal();
        return new MCExplosion(w.func_72885_a((Entity)entity.getInternal(), x, y, z, strength, isFlaming, isSmoking));
    }

    @ZenMethod
    public static int getSkyLight(IWorld world, IBlockPos pos) {
        net.minecraft.world.World w = (net.minecraft.world.World)world.getInternal();
        BlockPos p = (BlockPos)pos.getInternal();
        return w.func_175642_b(EnumSkyBlock.SKY, p);
    }

    @ZenMethod
    public static int getBlockLight(IWorld world, IBlockPos pos) {
        net.minecraft.world.World w = (net.minecraft.world.World)world.getInternal();
        BlockPos p = (BlockPos)pos.getInternal();
        return w.func_175642_b(EnumSkyBlock.BLOCK, p);
    }
}

