/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.syncer;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.malisis.core.MalisisCommand;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.DirectMessage;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.DoubleKeyMap;
import net.malisis.core.util.Silenced;
import net.malisis.core.util.syncer.ISyncHandler;
import net.malisis.core.util.syncer.ISyncableData;
import net.malisis.core.util.syncer.ObjectData;
import net.malisis.core.util.syncer.Sync;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.core.util.syncer.handlers.TileEntitySyncHandler;
import net.malisis.core.util.syncer.message.SyncerMessage;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

@AutoLoad
public class Syncer {
    private DoubleKeyMap<Class<?>, ISyncHandler<?, ? extends ISyncableData>> handlers = new DoubleKeyMap();
    private Map<String, Supplier<ISyncHandler<?, ? extends ISyncableData>>> factories = new HashMap();
    private Map<Object, HashMap<String, Object>> syncCache = new HashMap<Object, HashMap<String, Object>>();
    private int debugMessage = DirectMessage.registerMessage(this::debugOutput);
    public static final Syncer instance = new Syncer();

    private Syncer() {
        this.registerFactory("TileEntity", TileEntitySyncHandler::new);
        MalisisCommand.registerDebug("syncer", Syncer::debug);
        this.discover(MalisisCore.asmDataTable);
    }

    private void registerFactory(String name, Supplier<ISyncHandler<?, ? extends ISyncableData>> supplier) {
        this.factories.put(name, supplier);
    }

    public int getHandlerId(Class<?> clazz) {
        return this.handlers.getIndex(clazz);
    }

    public ISyncHandler<?, ? extends ISyncableData> getHandlerFromId(int id) {
        return this.handlers.get((Class<?>)id);
    }

    public <T> ISyncHandler<? super T, ? extends ISyncableData> getHandler(T caller) {
        ISyncHandler<?, ? extends ISyncableData> handler = this.handlers.get(caller.getClass());
        if (handler == null) {
            MalisisCore.log.error("No ISyncHandler registered for type '{}'", caller.getClass());
            return null;
        }
        return handler;
    }

    private void discover(ASMDataTable asmDataTable) {
        List classes = Ordering.natural().onResultOf(ASMDataTable.ASMData::getClassName).sortedCopy((Iterable)asmDataTable.getAll(Syncable.class.getName()));
        block2: for (ASMDataTable.ASMData data : classes) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                Syncable anno = clazz.getAnnotation(Syncable.class);
                ISyncHandler handler = (ISyncHandler)this.factories.get(anno.value()).get();
                this.handlers.put(clazz, handler);
                Field[] fields = clazz.getFields();
                Arrays.sort(fields, (a, b) -> a.getName().compareTo(b.getName()));
                for (Field f : fields) {
                    Sync syncAnno = f.getAnnotation(Sync.class);
                    if (syncAnno == null) continue;
                    handler.addObjectData(this.getObjectData(syncAnno.value(), f));
                }
                HashMap gets = Maps.newHashMap();
                HashMap sets = Maps.newHashMap();
                Method[] methods = clazz.getMethods();
                Arrays.sort(methods, (a, b) -> a.getName().compareTo(b.getName()));
                for (Method m : methods) {
                    ObjectData od;
                    Sync syncAnno = m.getAnnotation(Sync.class);
                    if (syncAnno == null) continue;
                    Sync.Type type = this.getMethodType(syncAnno, m);
                    if (type == null) {
                        MalisisCore.log.error("Could not determine the type of the method {} (GETTER or SETTER).", (Object)m.getName());
                        continue block2;
                    }
                    if (type == Sync.Type.GETTER) {
                        gets.put(syncAnno.value(), m);
                    } else if (type == Sync.Type.SETTER) {
                        sets.put(syncAnno.value(), m);
                    }
                    Method setter = (Method)sets.get(syncAnno.value());
                    Method getter = (Method)gets.get(syncAnno.value());
                    if (getter == null || setter == null || (od = this.getObjectData(syncAnno.value(), getter, setter)) == null) continue;
                    handler.addObjectData(od);
                }
            }
            catch (Exception e) {
                MalisisCore.log.error("Could not process {} syncable.", (Object)data.getClassName(), (Object)e);
            }
        }
    }

    private Sync.Type getMethodType(Sync syncAnno, Method m) {
        if (syncAnno.type() != Sync.Type.AUTO) {
            return syncAnno.type();
        }
        int c = m.getParameterCount();
        return c == 1 ? Sync.Type.SETTER : (c == 0 ? Sync.Type.GETTER : null);
    }

    private ObjectData getObjectData(String name, Field field) {
        Function<Object, Object> getter = holder -> Silenced.apply(field::get, holder);
        BiConsumer<Object, Object> setter = (holder, value) -> Silenced.accept(field::set, holder, value);
        return new ObjectData(name, field.getType(), getter, setter);
    }

    private ObjectData getObjectData(String name, Method get, Method set) {
        Function<Object, Object> getter = holder -> Silenced.apply(x$0 -> get.invoke(x$0, new Object[0]), holder);
        BiConsumer<Object, Object> setter = (holder, value) -> Silenced.accept((x$0, xva$1) -> set.invoke(x$0, xva$1), holder, value);
        if (set.getParameterTypes()[0] != get.getReturnType()) {
            return null;
        }
        return new ObjectData(name, get.getReturnType(), getter, setter);
    }

    private int getFieldIndexes(ISyncHandler<?, ? extends ISyncableData> handler, String ... syncNames) {
        int indexes = 0;
        for (String str : syncNames) {
            ObjectData od = handler.getObjectData(str);
            if (od == null) continue;
            indexes |= 1 << od.getIndex();
        }
        return indexes;
    }

    private Map<String, Object> getFieldValues(Object caller, ISyncHandler<?, ? extends ISyncableData> handler, String ... syncNames) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (String str : syncNames) {
            ObjectData od = handler.getObjectData(str);
            if (od == null) continue;
            values.put(str, od.get(caller));
        }
        return values;
    }

    private <T, S extends ISyncableData> void doSync(T caller, String ... syncNames) {
        ISyncHandler<T, ISyncableData> handler = this.getHandler(caller);
        if (handler == null) {
            return;
        }
        ISyncableData data = handler.getSyncData(caller);
        int indexes = this.getFieldIndexes(handler, syncNames);
        Map<String, Object> values = this.getFieldValues(caller, handler, syncNames);
        SyncerMessage.Packet packet = new SyncerMessage.Packet(this.getHandlerId(caller.getClass()), data, indexes, values);
        handler.send(caller, packet);
    }

    private void registerAutoSync(Object caller) {
        if (this.syncCache.get(caller) != null) {
            return;
        }
    }

    public <T> void updateValues(T receiver, ISyncHandler<T, ? extends ISyncableData> handler, Map<String, Object> values) {
        if (receiver == null || handler == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            ObjectData od = handler.getObjectData(entry.getKey());
            if (od == null) continue;
            od.set(receiver, entry.getValue());
        }
    }

    private void debugOutput() {
        for (DoubleKeyMap.DoubleKeyEntry<Class<?>, ISyncHandler<?, ISyncableData>> doubleKeyEntry : this.handlers) {
            System.out.println(doubleKeyEntry.getIndex() + ":" + doubleKeyEntry.getKey().getSimpleName() + " (" + doubleKeyEntry.getValue() + ")");
        }
    }

    public static void debug() {
        instance.debugOutput();
        DirectMessage.send(Syncer.instance.debugMessage);
    }

    public static void registerHandlerFactory(String name, Supplier<ISyncHandler<?, ? extends ISyncableData>> supplier) {
        instance.registerFactory(name, supplier);
    }

    public static void sync(Object caller, String ... syncNames) {
        instance.doSync(caller, syncNames);
    }

    public static void autoSync(Object caller) {
        instance.registerAutoSync(caller);
    }
}

