/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.core.util.MBlockState;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class AABBUtils {
    private static int[] cos = new int[]{1, 0, -1, 0};
    private static int[] sin = new int[]{0, 1, 0, -1};

    public static AxisAlignedBB empty() {
        return AABBUtils.empty(BlockPos.field_177992_a);
    }

    public static AxisAlignedBB empty(BlockPos pos) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static AxisAlignedBB identity() {
        return Block.field_185505_j;
    }

    public static AxisAlignedBB identity(BlockPos pos) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
    }

    public static AxisAlignedBB[] identities() {
        return AABBUtils.identities(BlockPos.field_177992_a);
    }

    public static AxisAlignedBB[] identities(BlockPos pos) {
        return new AxisAlignedBB[]{AABBUtils.identity(pos)};
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, EnumFacing dir) {
        if (dir == EnumFacing.SOUTH) {
            return aabb;
        }
        int angle = dir.func_176740_k() == EnumFacing.Axis.Y ? dir.func_176743_c().func_179524_a() : EnumFacingUtils.getRotationCount(dir);
        EnumFacing.Axis axis = dir.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.Axis.X : EnumFacing.Axis.Y;
        return AABBUtils.rotate(aabb, angle, axis);
    }

    public static AxisAlignedBB[] rotate(AxisAlignedBB[] aabbs, EnumFacing dir) {
        if (ArrayUtils.isEmpty((Object[])aabbs) || dir == EnumFacing.SOUTH) {
            return aabbs;
        }
        int angle = dir.func_176740_k() == EnumFacing.Axis.Y ? dir.func_176743_c().func_179524_a() : EnumFacingUtils.getRotationCount(dir);
        EnumFacing.Axis axis = dir.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.Axis.X : EnumFacing.Axis.Y;
        for (int i = 0; i < aabbs.length; ++i) {
            aabbs[i] = AABBUtils.rotate(aabbs[i], angle, axis);
        }
        return aabbs;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, int angle) {
        return AABBUtils.rotate(aabb, angle, EnumFacing.Axis.Y);
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, int angle, EnumFacing.Axis axis) {
        if (aabb == null || angle == 0 || axis == null) {
            return aabb;
        }
        int a = -angle & 3;
        int s = sin[a];
        int c = cos[a];
        aabb = aabb.func_72317_d(-0.5, -0.5, -0.5);
        double minX = aabb.field_72340_a;
        double minY = aabb.field_72338_b;
        double minZ = aabb.field_72339_c;
        double maxX = aabb.field_72336_d;
        double maxY = aabb.field_72337_e;
        double maxZ = aabb.field_72334_f;
        if (axis == EnumFacing.Axis.X) {
            minY = aabb.field_72338_b * (double)c - aabb.field_72339_c * (double)s;
            maxY = aabb.field_72337_e * (double)c - aabb.field_72334_f * (double)s;
            minZ = aabb.field_72338_b * (double)s + aabb.field_72339_c * (double)c;
            maxZ = aabb.field_72337_e * (double)s + aabb.field_72334_f * (double)c;
        }
        if (axis == EnumFacing.Axis.Y) {
            minX = aabb.field_72340_a * (double)c - aabb.field_72339_c * (double)s;
            maxX = aabb.field_72336_d * (double)c - aabb.field_72334_f * (double)s;
            minZ = aabb.field_72340_a * (double)s + aabb.field_72339_c * (double)c;
            maxZ = aabb.field_72336_d * (double)s + aabb.field_72334_f * (double)c;
        }
        if (axis == EnumFacing.Axis.Z) {
            minX = aabb.field_72340_a * (double)c - aabb.field_72338_b * (double)s;
            maxX = aabb.field_72336_d * (double)c - aabb.field_72337_e * (double)s;
            minY = aabb.field_72340_a * (double)s + aabb.field_72338_b * (double)c;
            maxY = aabb.field_72336_d * (double)s + aabb.field_72337_e * (double)c;
        }
        aabb = new AxisAlignedBB(minX + 0.5, minY + 0.5, minZ + 0.5, maxX + 0.5, maxY + 0.5, maxZ + 0.5);
        return aabb;
    }

    public static AxisAlignedBB readFromNBT(NBTTagCompound tag) {
        return AABBUtils.readFromNBT(tag, null);
    }

    public static AxisAlignedBB readFromNBT(NBTTagCompound tag, String prefix) {
        prefix = prefix == null ? "" : prefix + ".";
        return tag != null ? new AxisAlignedBB(tag.func_74769_h(prefix + "minX"), tag.func_74769_h(prefix + "minY"), tag.func_74769_h(prefix + "minZ"), tag.func_74769_h(prefix + "maxX"), tag.func_74769_h(prefix + "maxY"), tag.func_74769_h(prefix + "maxZ")) : null;
    }

    public static void writeToNBT(NBTTagCompound tag, AxisAlignedBB aabb) {
        AABBUtils.writeToNBT(tag, aabb, null);
    }

    public static void writeToNBT(NBTTagCompound tag, AxisAlignedBB aabb, String prefix) {
        if (tag == null || aabb == null) {
            return;
        }
        prefix = prefix == null ? "" : prefix + ".";
        tag.func_74780_a(prefix + "minX", aabb.field_72340_a);
        tag.func_74780_a(prefix + "minY", aabb.field_72338_b);
        tag.func_74780_a(prefix + "minZ", aabb.field_72339_c);
        tag.func_74780_a(prefix + "maxX", aabb.field_72336_d);
        tag.func_74780_a(prefix + "maxY", aabb.field_72337_e);
        tag.func_74780_a(prefix + "maxZ", aabb.field_72334_f);
    }

    public static AxisAlignedBB combine(AxisAlignedBB[] aabbs) {
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return null;
        }
        AxisAlignedBB ret = null;
        for (AxisAlignedBB aabb : aabbs) {
            if (ret == null) {
                ret = aabb;
                continue;
            }
            if (aabb == null) continue;
            ret = ret.func_111270_a(aabb);
        }
        return ret;
    }

    public static AxisAlignedBB[] offset(double x, double y, double z, AxisAlignedBB ... aabbs) {
        return AABBUtils.offset(new BlockPos(x, y, z), aabbs);
    }

    public static AxisAlignedBB offset(BlockPos pos, AxisAlignedBB aabb) {
        if (aabb == null || pos == null) {
            return aabb;
        }
        return aabb.func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static AxisAlignedBB[] offset(BlockPos pos, AxisAlignedBB ... aabbs) {
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return aabbs;
        }
        for (int i = 0; i < aabbs.length; ++i) {
            if (aabbs[i] == null) continue;
            aabbs[i] = aabbs[i].func_72317_d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        return aabbs;
    }

    public static boolean isColliding(AxisAlignedBB aabb, AxisAlignedBB[] aabbs) {
        return AABBUtils.isColliding(new AxisAlignedBB[]{aabb}, aabbs);
    }

    public static boolean isColliding(AxisAlignedBB[] aabbs, AxisAlignedBB aabb) {
        return AABBUtils.isColliding(aabbs, new AxisAlignedBB[]{aabb});
    }

    public static boolean isColliding(AxisAlignedBB[] aabbs1, AxisAlignedBB[] aabbs2) {
        if (ArrayUtils.isEmpty((Object[])aabbs1) || ArrayUtils.isEmpty((Object[])aabbs2)) {
            return false;
        }
        for (AxisAlignedBB aabb1 : aabbs1) {
            if (aabb1 == null) continue;
            for (AxisAlignedBB aabb2 : aabbs2) {
                if (aabb2 == null || !aabb1.func_72326_a(aabb2)) continue;
                return true;
            }
        }
        return false;
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, Block block, BlockPos pos) {
        return AABBUtils.getCollisionBoundingBoxes(world, new MBlockState(pos, block), false);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, Block block, BlockPos pos, boolean offset) {
        return AABBUtils.getCollisionBoundingBoxes(world, new MBlockState(pos, block), offset);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, MBlockState state) {
        return AABBUtils.getCollisionBoundingBoxes(world, state, false);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, MBlockState state, boolean offset) {
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{};
        if (world == null || state == null) {
            return aabbs;
        }
        if (state.getBlock() instanceof IBoundingBox) {
            aabbs = ((IBoundingBox)state.getBlock()).getCollisionBoundingBoxes(world, state.getPos(), state.getBlockState());
        } else {
            AxisAlignedBB aabb = state.getBlockState().func_185890_d((IBlockAccess)world, state.getPos());
            if (aabb != null) {
                aabbs = new AxisAlignedBB[]{aabb};
            }
        }
        if (offset) {
            AABBUtils.offset(state.getX(), state.getY(), state.getZ(), aabbs);
        }
        return aabbs;
    }

    public static AxisAlignedBB[] slice(int slices, float[][] fx, float[][] fy, float[][] fz, boolean vertical) {
        float delta = 1.0f / (float)slices;
        boolean START = false;
        boolean MIN = false;
        boolean END = true;
        boolean MAX = true;
        AxisAlignedBB[] aabb = new AxisAlignedBB[slices];
        for (int i = 0; i < slices; ++i) {
            float bx = fx[0][0] + (fx[1][0] - fx[0][0]) * (float)i * delta;
            float bX = fx[0][1] + (fx[1][1] - fx[0][1]) * (float)i * delta;
            float by = fy[0][0] + (fy[1][0] - fy[0][0]) * (float)i * delta;
            float bY = fy[0][1] + (fy[1][1] - fy[0][1]) * (float)i * delta;
            float bz = fz[0][0] + (fz[1][0] - fz[0][0]) * (float)i * delta;
            float bZ = fz[0][1] + (fz[1][1] - fz[0][1]) * (float)i * delta;
            if (vertical) {
                by = (float)i * delta;
                bY = by + delta;
            } else {
                bx = (float)i * delta;
                bX = bx + delta;
            }
            aabb[i] = new AxisAlignedBB((double)bx, (double)by, (double)bz, (double)bX, (double)bY, (double)bZ);
        }
        return aabb;
    }
}

