/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.BottomFace;
import net.malisis.core.renderer.element.face.NorthFace;
import net.malisis.core.renderer.element.face.SouthFace;
import net.malisis.core.renderer.element.face.TopFace;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.block.CustomDoor;
import net.malisis.doors.item.CustomDoorItem;
import net.malisis.doors.renderer.DoorRenderer;
import net.malisis.doors.tileentity.CustomDoorTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Triple;

public class CustomDoorRenderer
extends DoorRenderer {
    public static CustomDoorRenderer instance = new CustomDoorRenderer();
    private IBlockState frame;
    private IBlockState top;
    private IBlockState bottom;
    private float width;

    public CustomDoorRenderer() {
        super(false);
        this.registerFor(CustomDoorTileEntity.class);
    }

    @Override
    protected void initialize() {
        this.width = 0.125f;
        Shape frameR = new Cube().setSize(this.width, 1.0f, 0.1875f);
        Shape frameL = new Shape(frameR);
        frameL.translate(1.0f - this.width, 0.0f, 0.0f);
        Shape frameH = new Shape(new Face[]{new NorthFace(), new SouthFace(), new TopFace(), new BottomFace()});
        frameH.setSize(1.0f - 2.0f * this.width, this.width, 0.1875f);
        frameH.translate(this.width, 0.0f, 0.0f);
        Shape frame = Shape.fromShapes((Shape[])new Shape[]{frameR, frameL, frameH});
        frame.scale(1.0f, 1.0f, 0.995f);
        frame.applyMatrix();
        Shape mat = new Shape(new Face[]{new SouthFace(), new NorthFace(), new TopFace()});
        mat.setSize(1.0f - 2.0f * this.width, 1.0f - this.width, 0.112500004f).translate(this.width, this.width, 0.0375f);
        mat.applyMatrix();
        Shape bottom = new Shape();
        bottom.addFaces(frame.getFaces(), "frame");
        bottom.addFaces(mat.getFaces(), "material");
        bottom.interpolateUV();
        bottom.storeState();
        frameR = new Shape(frameR);
        frameL = new Shape(frameL);
        frameH = new Shape(frameH);
        frameH.translate(0.0f, 1.0f - this.width, 0.0f);
        frame = Shape.fromShapes((Shape[])new Shape[]{frameR, frameL, frameH});
        frame.scale(1.0f, 1.0f, 0.995f);
        frame.applyMatrix();
        mat = new Shape(mat);
        mat.translate(0.0f, -this.width, 0.0f);
        mat.applyMatrix();
        Shape top = new Shape();
        top.addFaces(frame.getFaces(), "frame");
        top.addFaces(mat.getFaces(), "material");
        top.translate(0.0f, 1.0f, 0.0f);
        top.interpolateUV();
        top.storeState();
        this.model = new MalisisModel();
        this.model.addShape("bottom", bottom);
        this.model.addShape("top", top);
        this.model.storeState();
        this.initParams();
        this.ensureBlock(new Class[]{CustomDoor.class});
    }

    @Override
    public boolean isGui3d() {
        return true;
    }

    @Override
    protected void setItem() {
        Triple<IBlockState, IBlockState, IBlockState> triple = CustomDoorItem.readNBT(this.itemStack.func_77978_p());
        this.frame = (IBlockState)triple.getLeft();
        this.top = (IBlockState)triple.getMiddle();
        this.bottom = (IBlockState)triple.getRight();
        this.direction = EnumFacing.SOUTH;
        this.setupParams();
    }

    @Override
    protected void setTileEntity() {
        super.setTileEntity();
        CustomDoorTileEntity tileEntity = (CustomDoorTileEntity)this.tileEntity;
        this.frame = tileEntity.getFrame();
        this.top = tileEntity.getTop();
        this.bottom = tileEntity.getBottom();
        this.setupParams();
    }

    private void setupParams() {
        this.rp.alpha.reset();
        this.rp.icon.set((Object)Icon.from((IBlockState)this.frame));
        this.rp.colorMultiplier.set((Object)this.getColor(this.frame));
        this.model.getShape("top").setParameters("frame", this.rp, true);
        this.model.getShape("bottom").setParameters("frame", this.rp, true);
        this.rp.icon.set((Object)Icon.from((IBlockState)this.top));
        this.rp.colorMultiplier.set((Object)this.getColor(this.top));
        this.model.getShape("top").setParameters("material", this.rp, true);
        this.rp.icon.set((Object)Icon.from((IBlockState)this.bottom));
        this.rp.colorMultiplier.set((Object)this.getColor(this.bottom));
        this.model.getShape("bottom").setParameters("material", this.rp, true);
        this.rp.icon.reset();
        this.rp.colorMultiplier.reset();
    }

    private int getColor(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150349_c) {
            return 0xFFFFFF;
        }
        return CustomDoorRenderer.colorMultiplier((IBlockAccess)this.world, (BlockPos)this.pos, (IBlockState)state);
    }
}

