/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.multiblock.AABBMultiBlock;
import net.malisis.core.util.multiblock.MultiBlock;
import net.malisis.core.util.multiblock.MultiBlockComponent;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.item.ForcefieldItem;
import net.malisis.doors.tileentity.ForcefieldTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisRendered(value=DefaultRenderer.Null.class)
public class Forcefield
extends MalisisBlock {
    public Forcefield() {
        super(Material.field_151574_g);
        this.func_149752_b(6.0E7f);
        this.func_149722_s();
        this.func_149672_a(SoundType.field_185858_k);
        this.setName("forcefieldDoor");
        this.setTexture("malisisdoors:blocks/forcefield");
        this.addComponent((IComponent)new MultiBlockComponent(this::getMultiBlock));
    }

    public Item getItem(Block block) {
        return null;
    }

    public AABBMultiBlock getMultiBlock(IBlockAccess world, BlockPos pos, IBlockState state, ItemStack itemStack) {
        ForcefieldTileEntity te = Forcefield.getForcefield(world, pos);
        return te != null ? te.getMultiBlock() : null;
    }

    public EnumFacing getPlacingDirection(EnumFacing side, EntityLivingBase placer) {
        return EnumFacing.SOUTH;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ForcefieldItem item = MalisisDoors.Items.forcefieldItem;
        if (!EntityUtils.isEquipped((EntityPlayer)player, (Item)item, (EnumHand)hand)) {
            return false;
        }
        ForcefieldTileEntity te = Forcefield.getForcefield((IBlockAccess)world, pos);
        if (te == null) {
            return true;
        }
        AABBMultiBlock mb = te.getMultiBlock();
        ItemStack itemStack = player.func_184586_b(hand);
        AxisAlignedBB aabb = mb.getRelativeBoundingBox(pos, te.func_174877_v());
        if (player.func_70093_af()) {
            if (item.destroyForcefield(itemStack, aabb)) {
                mb.breakBlocks(world, pos, this.func_176223_P());
            }
        } else if (item.toggleForcefield(itemStack, aabb)) {
            te.switchForcefield();
        }
        return true;
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        ForcefieldTileEntity te = Forcefield.getForcefield(world, pos);
        if (te == null || te.getMultiBlock() == null || type == BoundingBoxType.RAYTRACE) {
            return AABBUtils.identity();
        }
        if (te.isOpened() && type == BoundingBoxType.COLLISION) {
            return null;
        }
        AxisAlignedBB aabb = te.getMultiBlock().getRelativeBoundingBox(pos, te.func_174877_v());
        aabb = aabb.field_72337_e - aabb.field_72338_b == 1.0 ? new AxisAlignedBB(aabb.field_72340_a, 0.5, aabb.field_72339_c, aabb.field_72336_d, 0.5, aabb.field_72334_f) : (aabb.field_72336_d - aabb.field_72340_a == 1.0 ? new AxisAlignedBB(0.5, aabb.field_72338_b, aabb.field_72339_c, 0.5, aabb.field_72337_e, aabb.field_72334_f) : new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, 0.5, aabb.field_72336_d, aabb.field_72337_e, 0.5));
        return aabb;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        MultiBlock multiBlock = MultiBlockComponent.getMultiBlock((IBlockAccess)world, (BlockPos)pos, (IBlockState)world.func_180495_p(pos), null);
        if (multiBlock != null) {
            multiBlock.breakBlocks(world, pos, this.func_176223_P());
        }
        world.func_175698_g(pos);
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return MultiBlockComponent.isOrigin((IBlockState)state);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return MultiBlockComponent.isOrigin((IBlockState)state) ? new ForcefieldTileEntity() : null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)MalisisDoors.Items.forcefieldItem);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static ForcefieldTileEntity getForcefield(IBlockAccess world, BlockPos pos) {
        BlockPos origin = MultiBlock.getOrigin((IBlockAccess)world, (BlockPos)pos);
        return (ForcefieldTileEntity)((Object)TileEntityUtils.getTileEntity(ForcefieldTileEntity.class, (IBlockAccess)world, (BlockPos)(origin != null ? origin : pos)));
    }
}

