/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.world.feature.TFGenHollowTree;

public class TFGenTreeOfTime
extends TFGenHollowTree {
    public TFGenTreeOfTime(boolean notify) {
        super(notify);
        this.treeState = TFBlocks.magic_log.func_176223_P();
        this.branchState = this.treeState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leafState = TFBlocks.magic_leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int height = 8;
        int diameter = 1;
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + height + diameter > 256) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (!state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, this.source)) {
            return false;
        }
        this.buildTrunk(world, random, pos, diameter, height);
        this.buildTinyCrown(world, random, pos, diameter, height);
        this.buildBranchRing(world, random, pos, diameter, 1, 0, 12, 0, 0.75, 0.0, 3, 5, 3, false);
        this.buildBranchRing(world, random, pos, diameter, 1, 2, 18, 0, 0.9, 0.0, 3, 5, 3, false);
        EnumFacing facing = EnumFacing.field_176754_o[random.nextInt(4)];
        int xOff = facing.func_82601_c();
        int zOff = facing.func_82599_e();
        this.func_175903_a(world, pos.func_177982_a(xOff, 2, zOff), TFBlocks.magic_log_core.func_176223_P());
        return true;
    }

    protected void buildTinyCrown(World world, Random random, BlockPos pos, int diameter, int height) {
        int crownRadius = 4;
        int bvar = 1;
        this.buildBranchRing(world, random, pos, diameter, height - crownRadius, 0, crownRadius, 0, 0.35, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, pos, diameter, height - crownRadius / 2, 0, crownRadius, 0, 0.28, 0.0, bvar, bvar + 2, 1, true);
        this.buildBranchRing(world, random, pos, diameter, height, 0, crownRadius, 0, 0.15, 0.0, 2, 4, 0, true);
        this.buildBranchRing(world, random, pos, diameter, height, 0, crownRadius / 2, 0, 0.05, 0.0, bvar, bvar + 2, 0, true);
    }
}

