/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import twilightforest.util.ReloadableSet;

public abstract class ItemStackSet
extends ObjectOpenCustomHashSet<ItemStack>
implements ReloadableSet<ItemStack> {
    private static final Hash.Strategy<ItemStack> ITEMSTACK_STRATEGY = new Hash.Strategy<ItemStack>(){

        public int hashCode(ItemStack o) {
            if (o == null || o.func_190926_b()) {
                return 0;
            }
            int i = Item.func_150891_b((Item)o.func_77973_b()) << 17;
            if (o.func_77942_o()) {
                i |= Objects.hashCode(o.func_77978_p()) << 13;
            }
            return i;
        }

        public boolean equals(ItemStack a, ItemStack b) {
            if (a == null || b == null || a.func_190926_b() || b.func_190926_b()) {
                return false;
            }
            boolean metadata = a.func_77960_j() == b.func_77960_j() || a.func_77960_j() == Short.MAX_VALUE || b.func_77960_j() == Short.MAX_VALUE;
            boolean nbt = !a.func_77942_o() || Objects.requireNonNull(a.func_77978_p()).equals((Object)Objects.requireNonNull(b.func_77978_p()));
            return a.func_77973_b() == b.func_77973_b() && metadata && nbt;
        }
    };
    private boolean shouldReload = false;

    public ItemStackSet() {
        super(ITEMSTACK_STRATEGY);
    }

    @Override
    public void setReload() {
        this.shouldReload = true;
    }

    @Override
    public abstract void reload();

    @Override
    public boolean contains(Object k) {
        if (this.shouldReload) {
            this.clear();
            this.reload();
            this.shouldReload = false;
        }
        return super.contains(k);
    }

    public static class Ore
    extends ItemStackSet {
        private final String ore;

        public Ore(String ore) {
            this.ore = ore;
            this.setReload();
        }

        @Override
        public void reload() {
            this.addAll((Collection)OreDictionary.getOres((String)this.ore));
        }
    }
}

