/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity.spawner;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import twilightforest.entity.boss.EntityTFKnightPhantom;
import twilightforest.enums.BossVariant;
import twilightforest.item.TFItems;
import twilightforest.tileentity.spawner.TileEntityTFBossSpawner;

public class TileEntityTFKnightPhantomsSpawner
extends TileEntityTFBossSpawner {
    private static final int COUNT = 6;

    public TileEntityTFKnightPhantomsSpawner() {
        super(EntityList.func_191306_a(EntityTFKnightPhantom.class), BossVariant.KNIGHT_PHANTOM);
    }

    @Override
    public boolean anyPlayerInRange() {
        EntityPlayer closestPlayer = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.getRange(), false);
        return closestPlayer != null && closestPlayer.field_70163_u > (double)(this.field_174879_c.func_177956_o() - 2);
    }

    @Override
    protected boolean spawnMyBoss(EntityLivingBase living) {
        int spawned;
        for (int i = spawned = 0; i < 6; ++i) {
            EntityLivingBase myCreature = this.makeMyCreature();
            if (myCreature == null) continue;
            float angle = 60.0f * (float)i;
            float distance = 4.0f;
            double rx = (double)this.field_174879_c.func_177958_n() + 0.5 + Math.cos((double)angle * Math.PI / 180.0) * 4.0;
            double ry = this.field_174879_c.func_177956_o();
            double rz = (double)this.field_174879_c.func_177952_p() + 0.5 + Math.sin((double)angle * Math.PI / 180.0) * 4.0;
            myCreature.func_70012_b(rx, ry, rz, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (myCreature instanceof EntityLiving) {
                ((EntityLiving)myCreature).func_180482_a(this.field_145850_b.func_175649_E(new BlockPos((Entity)myCreature)), null);
            }
            if (i == 5 && this.field_145850_b.func_175659_aa() == EnumDifficulty.HARD) {
                myCreature.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(TFItems.knightmetal_shield));
            }
            this.initializeCreature(myCreature);
            if (myCreature instanceof EntityTFKnightPhantom) {
                ((EntityTFKnightPhantom)myCreature).setNumber(i);
            }
            if (!this.field_145850_b.func_72838_d((Entity)myCreature)) continue;
            ++spawned;
        }
        return spawned == 6;
    }

    @Override
    protected void initializeCreature(EntityLivingBase myCreature) {
        if (myCreature instanceof EntityTFKnightPhantom) {
            ((EntityTFKnightPhantom)myCreature).setHomePosAndDistance(this.field_174879_c, 46);
        }
    }
}

