/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import twilightforest.TwilightForestMod;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;
import twilightforest.util.TFEntityNames;
import twilightforest.util.VanillaEntityNames;

public class ItemTFTransformPowder
extends ItemTF {
    private static final Predicate<IBlockState> ALL = state -> true;
    private static final Map<ResourceLocation, ResourceLocation> transformMap = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<Block, Pair<Predicate<IBlockState>, IBlockState>> transformBlockMap = new Object2ObjectOpenHashMap();

    protected ItemTFTransformPowder() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.field_77777_bU = 64;
        this.func_77637_a(TFItems.creativeTab);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.MINOTAUR, VanillaEntityNames.ZOMBIE_PIGMAN);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.DEER, VanillaEntityNames.COW);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.BIGHORN_SHEEP, VanillaEntityNames.SHEEP);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.WILD_BOAR, VanillaEntityNames.PIG);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.BUNNY, VanillaEntityNames.RABBIT);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.TINY_BIRD, VanillaEntityNames.PARROT);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.RAVEN, VanillaEntityNames.BAT);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.HOSTILE_WOLF, VanillaEntityNames.WOLF);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.PENGUIN, VanillaEntityNames.CHICKEN);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.HEDGE_SPIDER, VanillaEntityNames.SPIDER);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.SWARM_SPIDER, VanillaEntityNames.CAVE_SPIDER);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.WRAITH, VanillaEntityNames.BLAZE);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.REDCAP, VanillaEntityNames.VILLAGER);
        ItemTFTransformPowder.addTwoWayTransformation(TFEntityNames.SKELETON_DRUID, VanillaEntityNames.WITCH);
    }

    public static void addTwoWayTransformation(ResourceLocation from, ResourceLocation to) {
        transformMap.put(from, to);
        transformMap.put(to, from);
    }

    public static void addOneWayTransformation(ResourceLocation from, ResourceLocation to) {
        transformMap.put(from, to);
    }

    public static void addBlockTransformation(Block from, Predicate<IBlockState> predicate, IBlockState to) {
        transformBlockMap.put(from, (Pair<Predicate<IBlockState>, IBlockState>)Pair.of(predicate, (Object)to));
    }

    public static boolean removeEntityTransformation(ResourceLocation from) {
        return transformMap.remove(from) != null;
    }

    public static Map<ResourceLocation, ResourceLocation> getTransformMap() {
        return transformMap;
    }

    public static Map<Block, Pair<Predicate<IBlockState>, IBlockState>> getTransformBlockMap() {
        return transformBlockMap;
    }

    public static void removeAll() {
        transformMap.clear();
    }

    public static void addBlockTransformation(Block from, int meta, IBlockState to) {
        ItemTFTransformPowder.addBlockTransformation(from, state -> from.func_176201_c(state) == meta, to);
    }

    public static void addBlockTransformation(IBlockState from, IBlockState to) {
        ItemTFTransformPowder.addBlockTransformation(from.func_177230_c(), state -> state == from, to);
    }

    public static void addBlockTransformation(Block from, IBlockState to) {
        ItemTFTransformPowder.addBlockTransformation(from, ALL, to);
    }

    public static ResourceLocation getTransformationEntity(ResourceLocation from) {
        return transformMap.get(from);
    }

    @Nullable
    public static IBlockState getTransformationBlock(IBlockState from) {
        Pair<Predicate<IBlockState>, IBlockState> pair = transformBlockMap.get(from.func_177230_c());
        if (pair == null) {
            return null;
        }
        return ((Predicate)pair.getKey()).test(from) ? (IBlockState)pair.getValue() : null;
    }

    @SubscribeEvent
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        World world = event.getWorld();
        Entity entity = event.getTarget();
        ItemStack heldItem = event.getItemStack();
        if (entity.field_70128_L || heldItem.func_77973_b() != this) {
            return;
        }
        ResourceLocation location = transformMap.get(EntityList.func_191301_a((Entity)entity));
        if (location == null) {
            return;
        }
        Entity newEntity = EntityList.func_188429_b((ResourceLocation)location, (World)world);
        if (newEntity == null) {
            return;
        }
        event.getEntityPlayer().func_184609_a(event.getHand());
        if (world.field_72995_K) {
            AxisAlignedBB fanBox = this.getEffectAABB(event.getEntityPlayer());
            for (int i = 0; i < 30; ++i) {
                world.func_175688_a(EnumParticleTypes.CRIT_MAGIC, fanBox.field_72340_a + (double)world.field_73012_v.nextFloat() * (fanBox.field_72336_d - fanBox.field_72340_a), fanBox.field_72338_b + (double)world.field_73012_v.nextFloat() * (fanBox.field_72337_e - fanBox.field_72338_b), fanBox.field_72339_c + (double)world.field_73012_v.nextFloat() * (fanBox.field_72334_f - fanBox.field_72339_c), 0.0, 0.0, 0.0, new int[0]);
            }
            event.setResult(Event.Result.ALLOW);
            return;
        }
        newEntity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        if (newEntity instanceof EntityLiving) {
            ((EntityLiving)newEntity).func_180482_a(world.func_175649_E(new BlockPos(entity)), null);
        }
        try {
            UUID uuid = newEntity.func_110124_au();
            newEntity.func_70020_e(entity.func_189511_e(newEntity.func_189511_e(new NBTTagCompound())));
            newEntity.func_184221_a(uuid);
        }
        catch (Exception e) {
            TwilightForestMod.LOGGER.warn("Couldn't transform entity NBT data: {}", (Throwable)e);
        }
        world.func_72838_d(newEntity);
        entity.func_70106_y();
        if (!event.getEntityPlayer().func_184812_l_()) {
            heldItem.func_190918_g(1);
        }
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70656_aK();
            ((EntityLiving)entity).func_70656_aK();
        } else {
            this.spawnExplosionParticles(world, entity);
            this.spawnExplosionParticles(world, entity);
        }
        entity.func_184185_a(SoundEvents.field_187942_hp, 1.0f + field_77697_d.nextFloat(), field_77697_d.nextFloat() * 0.7f + 0.3f);
        event.setResult(Event.Result.ALLOW);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack heldItem = player.func_184586_b(hand);
        IBlockState stateOut = ItemTFTransformPowder.getTransformationBlock(state);
        if (stateOut == null) {
            return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        if (world.field_72995_K) {
            AxisAlignedBB fanBox = this.getEffectAABB(player);
            for (int i = 0; i < 30; ++i) {
                world.func_175688_a(EnumParticleTypes.CRIT_MAGIC, fanBox.field_72340_a + (double)world.field_73012_v.nextFloat() * (fanBox.field_72336_d - fanBox.field_72340_a), fanBox.field_72338_b + (double)world.field_73012_v.nextFloat() * (fanBox.field_72337_e - fanBox.field_72338_b), fanBox.field_72339_c + (double)world.field_73012_v.nextFloat() * (fanBox.field_72334_f - fanBox.field_72339_c), 0.0, 0.0, 0.0, new int[0]);
            }
            return EnumActionResult.SUCCESS;
        }
        world.func_175656_a(pos, ItemTFTransformPowder.handleStateProperties(state, stateOut));
        if (!player.func_184812_l_()) {
            heldItem.func_190918_g(1);
        }
        this.spawnExplosionParticles(world, pos);
        this.spawnExplosionParticles(world, pos);
        world.func_184133_a(null, pos, SoundEvents.field_187942_hp, SoundCategory.BLOCKS, 1.0f + field_77697_d.nextFloat(), field_77697_d.nextFloat() * 0.7f + 0.3f);
        return EnumActionResult.SUCCESS;
    }

    private static IBlockState handleStateProperties(IBlockState from, IBlockState to) {
        BlockStateContainer containerFrom = from.func_177230_c().func_176194_O();
        BlockStateContainer containerTo = to.func_177230_c().func_176194_O();
        IProperty axisFrom = containerFrom.func_185920_a("axis");
        IProperty axisTo = containerTo.func_185920_a("axis");
        IProperty facingFrom = containerFrom.func_185920_a("facing");
        IProperty facingTo = containerTo.func_185920_a("facing");
        if (axisFrom != null && axisTo != null) {
            to = to.func_177226_a(axisTo, (Comparable)axisTo.func_185929_b(((IStringSerializable)from.func_177229_b(axisFrom)).func_176610_l()));
        }
        if (facingFrom != null && facingTo != null) {
            to = to.func_177226_a(facingTo, (Comparable)facingTo.func_185929_b(((IStringSerializable)from.func_177229_b(facingFrom)).func_176610_l()));
        }
        return to;
    }

    private AxisAlignedBB getEffectAABB(EntityPlayer player) {
        double range = 2.0;
        double radius = 1.0;
        Vec3d srcVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d lookVec = player.func_70040_Z();
        Vec3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        return new AxisAlignedBB(destVec.field_72450_a - radius, destVec.field_72448_b - radius, destVec.field_72449_c - radius, destVec.field_72450_a + radius, destVec.field_72448_b + radius, destVec.field_72449_c + radius);
    }

    private void spawnExplosionParticles(World world, Entity entity) {
        for (int i = 0; i < 20; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, entity.field_70165_t + (double)(world.field_73012_v.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N - d0 * 10.0, entity.field_70163_u + (double)(world.field_73012_v.nextFloat() * entity.field_70131_O) - d1 * 10.0, entity.field_70161_v + (double)(world.field_73012_v.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N - d2 * 10.0, d0, d1, d2, new int[0]);
        }
    }

    private void spawnExplosionParticles(World world, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)pos.func_177958_n() + 0.5 + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0 - d0 * 10.0, (double)pos.func_177956_o() + 0.5 + (double)world.field_73012_v.nextFloat() - d1 * 10.0, (double)pos.func_177952_p() + 0.5 + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0 - d2 * 10.0, d0, d1, d2, new int[0]);
        }
    }
}

