/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import twilightforest.enums.BossVariant;
import twilightforest.tileentity.spawner.TileEntityTFBossSpawner;

public abstract class BossEvent
extends Event {
    private final World world;
    private final BlockPos pos;
    private final BossVariant variant;
    private final EntityLivingBase boss;

    public BossEvent(World world, BlockPos pos, BossVariant variant, EntityLivingBase boss) {
        this.world = world;
        this.pos = pos;
        this.variant = variant;
        this.boss = boss;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BossVariant getVariant() {
        return this.variant;
    }

    public EntityLivingBase getBoss() {
        return this.boss;
    }

    @Cancelable
    public static class Death
    extends BossEvent {
        private final DamageSource source;

        public Death(World world, BlockPos pos, BossVariant variant, EntityLivingBase boss, DamageSource source) {
            super(world, pos, variant, boss);
            this.source = source;
        }

        public DamageSource getSource() {
            return this.source;
        }
    }

    @Event.HasResult
    public static class Spawning
    extends BossEvent {
        private final IBlockState state;
        private final TileEntityTFBossSpawner spawner;

        public Spawning(World world, BlockPos pos, IBlockState state, TileEntityTFBossSpawner spawner, EntityLivingBase boss) {
            super(world, pos, spawner.getVariant(), boss);
            this.state = state;
            this.spawner = spawner;
        }

        public IBlockState getState() {
            return this.state;
        }

        public TileEntityTFBossSpawner getSpawner() {
            return this.spawner;
        }
    }

    public static class Construction
    extends BossEvent {
        private EntityLivingBase boss;
        private final IBlockState state;
        private final TileEntityTFBossSpawner spawner;

        public Construction(World world, BlockPos pos, IBlockState state, TileEntityTFBossSpawner spawner, EntityLivingBase defaultBoss) {
            super(world, pos, spawner.getVariant(), defaultBoss);
            this.state = state;
            this.spawner = spawner;
            this.boss = defaultBoss;
        }

        public IBlockState getState() {
            return this.state;
        }

        public TileEntityTFBossSpawner getSpawner() {
            return this.spawner;
        }

        public EntityLivingBase getModifiedBoss() {
            return this.boss;
        }

        public void setBoss(EntityLivingBase boss) {
            this.boss = boss;
        }

        public void setBoss(Entity boss) {
            if (boss instanceof EntityLivingBase) {
                this.boss = (EntityLivingBase)boss;
            }
        }
    }
}

