/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.groovyscript;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.api.documentation.annotations.RegistryDescription;
import com.cleanroommc.groovyscript.helper.SimpleObjectStream;
import com.cleanroommc.groovyscript.helper.ingredient.IngredientHelper;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import twilightforest.inventory.ContainerTFUncrafting;
import twilightforest.item.ItemTFOreMagnet;
import twilightforest.item.recipe.UncraftingRecipe;
import twilightforest.item.recipe.UncraftingShapedRecipe;
import twilightforest.item.recipe.UncraftingShapelessRecipe;

@RegistryDescription(linkGenerator="twilightforest")
public class UncraftingTable
extends VirtualizedRegistry<IRecipe> {
    private List<ResourceLocation> recipeList = new ArrayList<ResourceLocation>();

    public ShapedRecipe shapedBuilder() {
        return new ShapedRecipe();
    }

    public ShapelessRecipe shapelessBuilder() {
        return new ShapelessRecipe();
    }

    public void onReload() {
        this.removeScripted().forEach(recipe -> ContainerTFUncrafting.removeRecipe(recipe.func_77571_b()));
        this.restoreFromBackup().forEach(ContainerTFUncrafting::addRecipe);
        this.recipeList.forEach(ContainerTFUncrafting::removeRecipeFromList);
        this.recipeList = new ArrayList<ResourceLocation>();
        ContainerTFUncrafting.reloadStackSet();
        ItemTFOreMagnet.reloadOres();
    }

    public UncraftingTable() {
        super((Collection)Lists.newArrayList((Object[])new String[]{"uncrafting", "Uncrafting", "uncraftingtable", "uncrafting_table", "UncraftingTable"}));
    }

    @Deprecated
    public void addItemToList(IIngredient ingredient) {
        for (ItemStack stack : ingredient.getMatchingStacks()) {
            OreDictionary.registerOre((String)"uncraftingList", (ItemStack)stack);
        }
    }

    public void addRecipeToList(ResourceLocation location) {
        ContainerTFUncrafting.addRecipeToList(location);
        this.recipeList.add(location);
    }

    public void addRecipeToList(String location) {
        this.addRecipeToList(new ResourceLocation(location));
    }

    public void add(IRecipe recipe) {
        if (recipe != null) {
            this.addScripted(recipe);
            ContainerTFUncrafting.addRecipe(recipe);
        }
    }

    public boolean remove(IRecipe recipe) {
        IRecipe rec;
        if (recipe != null && (rec = ContainerTFUncrafting.removeRecipe(recipe)) != null) {
            return this.addBackup(rec);
        }
        return false;
    }

    public void addShaped(ItemStack input, int recipeCost, List<List<IIngredient>> outputs) {
        NonNullList list = NonNullList.func_191196_a();
        int i = 0;
        for (List<IIngredient> l : outputs) {
            l.forEach(ing -> list.add((Object)(ing == null ? Ingredient.field_193370_a : ing.toMcIngredient())));
            ++i;
        }
        UncraftingShapedRecipe recipe = new UncraftingShapedRecipe(outputs.get(0).size(), i, (NonNullList<Ingredient>)list, input, recipeCost);
        this.add(recipe);
    }

    public void addShapeless(ItemStack input, int recipeCost, List<IIngredient> outputs) {
        NonNullList list = NonNullList.func_191197_a((int)outputs.size(), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < outputs.size(); ++i) {
            list.set(i, (Object)outputs.get(i).toMcIngredient());
        }
        UncraftingShapelessRecipe recipe = new UncraftingShapelessRecipe(input, (NonNullList<Ingredient>)list, recipeCost);
        this.add(recipe);
    }

    public void removeByInput(ItemStack input) {
        ContainerTFUncrafting.removeRecipe(input).forEach(arg_0 -> ((UncraftingTable)this).addBackup(arg_0));
    }

    public void removeAll() {
        ContainerTFUncrafting.removeAll().forEach(arg_0 -> ((UncraftingTable)this).addBackup(arg_0));
    }

    public SimpleObjectStream<IRecipe> streamRecipes() {
        return new SimpleObjectStream(ContainerTFUncrafting.getAll()).setRemover(this::remove);
    }

    protected static NonNullList<Ingredient> toIngredientList(List<IIngredient> list) {
        NonNullList l = NonNullList.func_191197_a((int)list.size(), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < list.size(); ++i) {
            l.set(i, (Object)list.get(i).toMcIngredient());
        }
        return l;
    }

    public abstract class UncraftingBuilder {
        protected ItemStack input;
        protected int cost;
        protected NonNullList<Ingredient> outputs;

        public UncraftingBuilder input(ItemStack input) {
            this.input = input;
            return this;
        }

        public UncraftingBuilder cost(int cost) {
            this.cost = cost;
            return this;
        }

        @Nullable
        public UncraftingRecipe register() {
            GroovyLog.Msg msg = GroovyLog.msg((String)"Error adding Twilight Forest Uncrafting recipe", (Object[])new Object[0]);
            if (msg.add(IngredientHelper.isEmpty((ItemStack)this.input), () -> "Input must not be empty").add(this.outputs == null || this.outputs.isEmpty(), () -> "outputs must not be empty").add(this.outputs != null && this.outputs.size() > 9, () -> "maximum inputs are 9 but found " + this.outputs.size()).error().postIfNotEmpty()) {
                return null;
            }
            UncraftingRecipe recipe = this.create();
            UncraftingTable.this.add(recipe);
            return recipe;
        }

        protected abstract UncraftingRecipe create();
    }

    public class ShapelessRecipe
    extends UncraftingBuilder {
        public ShapelessRecipe outputs(List<IIngredient> outputs) {
            NonNullList outs = NonNullList.func_191197_a((int)outputs.size(), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < outputs.size(); ++i) {
                outs.set(i, (Object)outputs.get(i).toMcIngredient());
            }
            this.outputs = outs;
            return this;
        }

        @Override
        protected UncraftingRecipe create() {
            return new UncraftingShapelessRecipe(this.input, (NonNullList<Ingredient>)this.outputs, this.cost);
        }
    }

    public class ShapedRecipe
    extends UncraftingBuilder {
        private int width;
        private int height;

        public UncraftingBuilder recipe(List<List<IIngredient>> outputs) {
            NonNullList outs = NonNullList.func_191196_a();
            for (List<IIngredient> l : outputs) {
                l.forEach(ing -> outs.add((Object)(ing == null ? Ingredient.field_193370_a : ing.toMcIngredient())));
            }
            this.outputs = outs;
            this.width = outputs.get(0).size();
            this.height = outputs.size();
            return this;
        }

        public UncraftingBuilder outputs(List<List<IIngredient>> outputs) {
            return this.recipe(outputs);
        }

        @Override
        protected UncraftingRecipe create() {
            return new UncraftingShapedRecipe(this.width, this.height, (NonNullList<Ingredient>)this.outputs, this.input, this.cost);
        }
    }
}

