/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.client.TFClientEvents;
import twilightforest.client.model.armor.ModelTFPhantomArmor;
import twilightforest.client.model.entity.ModelTFHydraHead;
import twilightforest.client.model.entity.ModelTFKnightPhantom2;
import twilightforest.client.model.entity.ModelTFLich;
import twilightforest.client.model.entity.ModelTFMinoshroom;
import twilightforest.client.model.entity.ModelTFNaga;
import twilightforest.client.model.entity.ModelTFQuestRam;
import twilightforest.client.model.entity.ModelTFSnowQueen;
import twilightforest.client.model.entity.ModelTFTowerBoss;
import twilightforest.client.model.item.BuiltInItemModel;
import twilightforest.enums.BossVariant;
import twilightforest.tileentity.TileEntityTFTrophy;

public class TileEntityTFTrophyRenderer
extends TileEntitySpecialRenderer<TileEntityTFTrophy> {
    private final ModelTFHydraHead hydraHeadModel = new ModelTFHydraHead();
    private static final ResourceLocation textureLocHydra = TwilightForestMod.getModelTexture("hydra4.png");
    private final ModelTFNaga nagaHeadModel = new ModelTFNaga();
    private static final ResourceLocation textureLocNaga = TwilightForestMod.getModelTexture("nagahead.png");
    private final ModelTFLich lichModel = new ModelTFLich();
    private static final ResourceLocation textureLocLich = TwilightForestMod.getModelTexture("twilightlich64.png");
    private final ModelTFTowerBoss urGhastModel = new ModelTFTowerBoss();
    private static final ResourceLocation textureLocUrGhast = TwilightForestMod.getModelTexture("towerboss.png");
    private final ModelTFSnowQueen snowQueenModel = new ModelTFSnowQueen();
    private static final ResourceLocation textureLocSnowQueen = TwilightForestMod.getModelTexture("snowqueen.png");
    private final ModelTFMinoshroom minoshroomModel = new ModelTFMinoshroom();
    private static final ResourceLocation textureLocMinoshroom = TwilightForestMod.getModelTexture("minoshroomtaur.png");
    private final ModelTFKnightPhantom2 knightPhantomModel = new ModelTFKnightPhantom2();
    private static final ResourceLocation textureLocKnightPhantom = TwilightForestMod.getModelTexture("phantomskeleton.png");
    private final ModelTFPhantomArmor knightPhantomArmorModel = new ModelTFPhantomArmor(EntityEquipmentSlot.HEAD, 0.5f);
    private static final ResourceLocation textureLocKnightPhantomArmor = new ResourceLocation("twilightforest:textures/armor/phantom_1.png");
    private final ModelTFQuestRam questRamModel = new ModelTFQuestRam();
    private static final ResourceLocation textureLocQuestRam = TwilightForestMod.getModelTexture("questram.png");
    private static final ResourceLocation textureLocQuestRamLines = TwilightForestMod.getModelTexture("questram_lines.png");
    private final ModelResourceLocation itemModelLocation;
    private ItemStack stack = ItemStack.field_190927_a;
    private ItemCameraTransforms.TransformType transform = ItemCameraTransforms.TransformType.NONE;

    public TileEntityTFTrophyRenderer() {
        this.itemModelLocation = null;
    }

    public TileEntityTFTrophyRenderer(ModelResourceLocation itemModelLocation) {
        this.itemModelLocation = itemModelLocation;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)this.itemModelLocation, (Object)new BakedModel());
    }

    public void render(@Nullable TileEntityTFTrophy trophy, double x, double y, double z, float partialTime, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        if (trophy == null) {
            if (this.transform == ItemCameraTransforms.TransformType.GUI) {
                String modelName = BossVariant.getVariant(this.stack.func_77960_j()).getTrophyType().getModelName();
                ModelResourceLocation trophyModelLocation = new ModelResourceLocation("twilightforest:" + modelName, "inventory");
                IBakedModel trophyModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(trophyModelLocation);
                GlStateManager.func_179140_f();
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)-1.5f);
                Minecraft.func_71410_x().func_175599_af().func_180454_a(this.stack, ForgeHooksClient.handleCameraTransforms((IBakedModel)trophyModel, (ItemCameraTransforms.TransformType)this.transform, (boolean)false));
                GlStateManager.func_179145_e();
                GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)1.5f);
                GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else if (this.transform == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || this.transform == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.40625f, (float)1.171875f, (float)0.0f);
            } else if (this.transform == ItemCameraTransforms.TransformType.GROUND) {
                GlStateManager.func_179109_b((float)0.25f, (float)0.3f, (float)0.25f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            } else if (this.transform == ItemCameraTransforms.TransformType.HEAD) {
                if (BossVariant.getVariant(this.stack.func_77960_j()) == BossVariant.QUEST_RAM) {
                    GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)3.0f);
                    GlStateManager.func_179109_b((float)-0.33f, (float)-0.13f, (float)-0.33f);
                } else {
                    GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                    GlStateManager.func_179109_b((float)-0.25f, (float)0.0f, (float)-0.25f);
                }
            }
        }
        float rotation = trophy != null ? (float)(trophy.func_145906_b() * 360) / 16.0f : 0.0f;
        boolean onGround = true;
        if (trophy != null && trophy.func_145832_p() != 1) {
            switch (trophy.func_145832_p() & 7) {
                case 2: {
                    onGround = false;
                    break;
                }
                case 3: {
                    onGround = false;
                    rotation = 180.0f;
                    break;
                }
                case 4: {
                    onGround = false;
                    rotation = 270.0f;
                    break;
                }
                default: {
                    onGround = false;
                    rotation = 90.0f;
                    break;
                }
            }
        } else if (trophy == null && this.transform == ItemCameraTransforms.TransformType.GUI) {
            rotation = TFConfig.rotateTrophyHeadsGui ? TFClientEvents.rotationTicker : 135.0f;
        }
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        switch (BossVariant.getVariant(trophy != null ? trophy.func_145904_a() : this.stack.func_77960_j())) {
            case HYDRA: {
                if (trophy == null) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)(this.transform == ItemCameraTransforms.TransformType.HEAD ? -0.125f : 0.0f));
                }
                this.renderHydraHead(trophy, rotation, onGround && trophy != null, partialTime);
                break;
            }
            case NAGA: {
                this.renderNagaHead(rotation, onGround);
                break;
            }
            case LICH: {
                this.renderLichHead(rotation, onGround);
                break;
            }
            case UR_GHAST: {
                if (trophy == null) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
                }
                this.renderUrGhastHead(trophy, rotation, onGround, partialTime);
                break;
            }
            case SNOW_QUEEN: {
                this.renderSnowQueenHead(rotation, onGround);
                break;
            }
            case MINOSHROOM: {
                this.renderMinoshroomHead(rotation, onGround);
                break;
            }
            case KNIGHT_PHANTOM: {
                this.renderKnightPhantomHead(rotation, onGround);
                break;
            }
            case QUEST_RAM: {
                this.renderQuestRamHead(rotation, onGround);
                break;
            }
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private void renderHydraHead(@Nullable TileEntityTFTrophy trophy, float rotation, boolean onGround, float partialTicks) {
        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
        this.func_147499_a(textureLocHydra);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.0f : -0.0f), (float)1.5f);
        if (onGround) {
            this.hydraHeadModel.openMouthForTrophy(0.0f);
        } else if (trophy != null) {
            float ageInTicks = trophy.ticksExisted;
            if (trophy.shouldAnimate()) {
                ageInTicks += partialTicks;
            }
            this.hydraHeadModel.openMouthForTrophy(MathHelper.func_76126_a((float)ageInTicks) / 4.0f + 0.25f);
        }
        this.hydraHeadModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, rotation, 0.0f, 0.0625f);
    }

    private void renderNagaHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.125f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
        this.func_147499_a(textureLocNaga);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.0f : -0.0f), (float)(onGround ? 0.0f : 1.0f));
        this.nagaHeadModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, rotation, 0.0f, 0.0625f);
    }

    private void renderLichHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(textureLocLich);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.75f : 1.5f), (float)(onGround ? 0.0f : 0.24f));
        this.lichModel.field_78116_c.func_78785_a(0.0625f);
        this.lichModel.field_178720_f.func_78785_a(0.0625f);
    }

    private void renderUrGhastHead(@Nullable TileEntityTFTrophy trophy, float rotation, boolean onGround, float partialTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.func_147499_a(textureLocUrGhast);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        float ageInTicks = 0.0f;
        if (trophy != null) {
            ageInTicks = trophy.ticksExisted;
            if (trophy.shouldAnimate()) {
                ageInTicks += partialTime;
            }
        }
        this.urGhastModel.func_78088_a(null, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f, 0.0625f);
    }

    private void renderSnowQueenHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(textureLocSnowQueen);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.5f : 1.25f), (float)(onGround ? 0.0f : 0.24f));
        this.snowQueenModel.field_78116_c.func_78785_a(0.0625f);
        this.snowQueenModel.field_178720_f.func_78785_a(0.0625f);
    }

    private void renderMinoshroomHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(textureLocMinoshroom);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.875f : 1.625f), (float)(onGround ? 0.5625f : 0.8125f));
        this.minoshroomModel.field_78116_c.func_78785_a(0.0625f);
    }

    private void renderKnightPhantomHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.5f : 1.25f), (float)(onGround ? 0.0f : 0.25f));
        GlStateManager.func_179152_a((float)0.9375f, (float)0.9375f, (float)0.9375f);
        this.func_147499_a(textureLocKnightPhantomArmor);
        this.knightPhantomArmorModel.field_78116_c.func_78785_a(0.0625f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        this.func_147499_a(textureLocKnightPhantom);
        this.knightPhantomModel.field_78116_c.func_78785_a(0.0625f);
    }

    private void renderQuestRamHead(float rotation, boolean onGround) {
        if (this.transform == ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179152_a((float)0.55f, (float)0.55f, (float)0.55f);
        } else if (this.stack.func_190926_b()) {
            GlStateManager.func_179152_a((float)0.65f, (float)0.65f, (float)0.65f);
        } else {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        if (this.transform == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || this.transform == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
        }
        this.func_147499_a(textureLocQuestRam);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.3f : 1.03f), (float)(onGround ? 0.765625f : 1.085f));
        this.questRamModel.head.func_78785_a(0.0625f);
        GlStateManager.func_179140_f();
        this.func_147499_a(textureLocQuestRamLines);
        float var4 = 1.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179152_a((float)1.025f, (float)1.025f, (float)1.025f);
        int var5 = 61680;
        int var6 = var5 % 65536;
        int var7 = var5 / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var6 / 1.0f), (float)((float)var7 / 1.0f));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)var4);
        this.questRamModel.head.func_78785_a(0.0625f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
    }

    private class BakedModel
    extends BuiltInItemModel {
        BakedModel() {
            super("minecraft:blocks/soul_sand");
        }

        @Override
        protected void setItemStack(ItemStack stack) {
            TileEntityTFTrophyRenderer.this.stack = stack;
        }

        @Override
        protected void setTransform(ItemCameraTransforms.TransformType transform) {
            TileEntityTFTrophyRenderer.this.transform = transform;
        }
    }

    public static class DummyTile
    extends TileEntityTFTrophy {
    }
}

