/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities.shield;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.network.PacketUpdateShield;
import twilightforest.network.TFPacketHandler;

public class ShieldCapabilityHandler
implements IShieldCapability {
    private int temporaryShields;
    private int permanentShields;
    private EntityLivingBase host;
    private int timer;

    @Override
    public void setEntity(EntityLivingBase entity) {
        this.host = entity;
    }

    @Override
    public void update() {
        if (!(this.host.field_70170_p.field_72995_K || this.shieldsLeft() <= 0 || this.timer-- > 0 || this.host instanceof EntityPlayer && ((EntityPlayer)this.host).func_184812_l_())) {
            this.breakShield();
        }
    }

    @Override
    public int shieldsLeft() {
        return this.temporaryShields + this.permanentShields;
    }

    @Override
    public int temporaryShieldsLeft() {
        return this.temporaryShields;
    }

    @Override
    public int permanentShieldsLeft() {
        return this.permanentShields;
    }

    @Override
    public void breakShield() {
        if (this.temporaryShields > 0) {
            --this.temporaryShields;
            this.resetTimer();
        } else if (this.permanentShields > 0) {
            --this.permanentShields;
        }
        this.host.field_70170_p.func_184133_a(null, this.host.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, ((this.host.func_70681_au().nextFloat() - this.host.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        this.sendUpdatePacket();
    }

    @Override
    public void replenishShields() {
        this.setShields(5, true);
        this.host.field_70170_p.func_184133_a(null, this.host.func_180425_c(), SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, (this.host.func_70681_au().nextFloat() - this.host.func_70681_au().nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public void setShields(int amount, boolean temp) {
        if (temp) {
            this.temporaryShields = Math.max(amount, 0);
            this.resetTimer();
        } else {
            this.permanentShields = Math.max(amount, 0);
        }
        this.sendUpdatePacket();
    }

    @Override
    public void addShields(int amount, boolean temp) {
        if (temp) {
            if (this.temporaryShields <= 0) {
                this.resetTimer();
            }
            this.temporaryShields = Math.max(this.temporaryShields + amount, 0);
        } else {
            this.permanentShields = Math.max(this.permanentShields + amount, 0);
        }
        this.sendUpdatePacket();
    }

    void initShields(int temporary, int permanent) {
        this.temporaryShields = Math.max(temporary, 0);
        this.permanentShields = Math.max(permanent, 0);
        this.resetTimer();
    }

    private void resetTimer() {
        this.timer = 240;
    }

    private void sendUpdatePacket() {
        if (!this.host.field_70170_p.field_72995_K) {
            PacketUpdateShield message = new PacketUpdateShield((Entity)this.host, (IShieldCapability)this);
            TFPacketHandler.CHANNEL.sendToAllTracking((IMessage)message, (Entity)this.host);
            if (this.host instanceof EntityPlayerMP) {
                TFPacketHandler.CHANNEL.sendTo((IMessage)message, (EntityPlayerMP)this.host);
            }
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("tempshields", this.temporaryShieldsLeft());
        tag.func_74768_a("permshields", this.permanentShieldsLeft());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.initShields(tag.func_74762_e("tempshields"), tag.func_74762_e("permshields"));
    }
}

