/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twilightforest.IMCHandler;
import twilightforest.TwilightForestMod;
import twilightforest.world.WorldProviderTwilightForest;
import twilightforest.world.feature.TFGenCaveStalactite;

@Config(modid="twilightforest")
@Mod.EventBusSubscriber(modid="twilightforest")
public class TFConfig {
    @Config.Ignore
    private static final String config = "twilightforest.config.";
    @Config.LangKey(value="twilightforest.config.dimension")
    @Config.Comment(value={"Settings that are not reversible without consequences."})
    public static Dimension dimension = new Dimension();
    @Config.RequiresMcRestart
    @Config.LangKey(value="twilightforest.config.compat")
    @Config.Comment(value={"Should TF Compatibility load? Turn off if TF's Compatibility is causing crashes or if not desired."})
    public static boolean doCompat = true;
    @Config.LangKey(value="twilightforest.config.performance")
    @Config.Comment(value={"Lets you sacrifice various things to improve world performance."})
    public static Performance performance = new Performance();
    @Config.LangKey(value="twilightforest.config.silent_cicadas")
    @Config.Comment(value={"Make cicadas silent for those having sound library problems, or otherwise finding them annoying."})
    public static boolean silentCicadas = false;
    @Config.LangKey(value="twilightforest.config.first_person_effects")
    @Config.Comment(value={"Controls whether various effects from the mod are rendered while in first-person view. Turn this off if you find them distracting."})
    public static boolean firstPersonEffects = true;
    @Config.LangKey(value="twilightforest.config.origin_dimension")
    @Config.Comment(value={"The dimension you can always travel to the Twilight Forest from, as well as the dimension you will return to. Defaults to the overworld."})
    public static int originDimension = 0;
    @Config.LangKey(value="twilightforest.config.portals_in_other_dimensions")
    @Config.Comment(value={"Allow portals to the Twilight Forest to be made outside of the 'origin' dimension. May be considered an exploit."})
    public static boolean allowPortalsInOtherDimensions = false;
    @Config.LangKey(value="twilightforest.config.admin_portals")
    @Config.Comment(value={"Allow portals only for admins (Operators). This severely reduces the range in which the mod usually scans for valid portal conditions, and it scans near ops only."})
    public static boolean adminOnlyPortals = false;
    @Config.LangKey(value="twilightforest.config.portals")
    @Config.Comment(value={"Disable Twilight Forest portal creation entirely. Provided for server operators looking to restrict action to the dimension."})
    public static boolean disablePortalCreation = false;
    @Config.LangKey(value="twilightforest.config.portal_creator")
    @Config.Comment(value={"Registry String IDs of items used to create the Twilight Forest Portal. (domain:regname:meta) meta is optional."})
    public static String[] portalCreationItems = new String[]{"minecraft:diamond"};
    @Config.LangKey(value="twilightforest.config.check_portal_destination")
    @Config.Comment(value={"Determines if new portals should be pre-checked for safety. If enabled, portals will fail to form rather than redirect to a safe alternate destination.\nNote that enabling this also reduces the rate at which portal formation checks are performed."})
    public static boolean checkPortalDestination = false;
    @Config.LangKey(value="twilightforest.config.portal_lighting")
    @Config.Comment(value={"Set this true if you want the lightning that zaps the portal to not set things on fire. For those who don't like fun."})
    public static boolean portalLightning = false;
    @Config.LangKey(value="twilightforest.config.portal_return")
    @Config.Comment(value={"If false, the return portal will require the activation item."})
    public static boolean shouldReturnPortalBeUsable = true;
    @Config.LangKey(value="twilightforest.config.progression_default")
    @Config.Comment(value={"Sets the default value of the game rule controlling enforced progression."})
    public static boolean progressionRuleDefault = true;
    @Config.RequiresMcRestart
    @Config.LangKey(value="twilightforest.config.uncrafting")
    @Config.Comment(value={"Disable the uncrafting function of the uncrafting table. Provided as an option when interaction with other mods produces exploitable recipes."})
    public static boolean disableUncrafting = false;
    @Config.RequiresMcRestart
    @Config.LangKey(value="twilightforest.config.uncrafting.whitelist")
    @Config.Comment(value={"Turn uncrafting recipe list to whitelist. They're blacklist by default."})
    public static boolean whitelistUncrafting = false;
    @Config.RequiresMcRestart
    @Config.LangKey(value="twilightforest.config.uncrafting.list")
    @Config.Comment(value={"Uncrafting list for blacklisting or whitelisting recipes."})
    public static String[] uncraftingList = new String[0];
    @Config.LangKey(value="twilightforest.config.antibuilder_blacklist")
    @Config.Comment(value={"Anti-Builder blacklist. (domain:block:meta) meta is optional."})
    public static String[] antibuilderBlacklist = new String[]{"minecraft:bedrock", "tombmanygraves:grave_block"};
    @Config.LangKey(value="twilightforest.config.animate_trophyitem")
    @Config.Comment(value={"Rotate trophy heads on item model. Has no performance impact at all. For those who don't like fun."})
    public static boolean rotateTrophyHeadsGui = true;
    @Config.LangKey(value="twilightforest.config.shield_parry")
    @Config.Comment(value={"We recommend downloading the Shield Parry mod for parrying, but these controls remain for without."})
    public static ShieldInteractions shieldInteractions = new ShieldInteractions();
    @Config.LangKey(value="twilightforest.config.loading_screen")
    @Config.Comment(value={"Client only: Controls for the Loading screen"})
    public static final LoadingScreen loadingScreen = new LoadingScreen();
    @Config.Ignore
    private static ImmutableSet<IBlockState> disallowBreakingBlockList;
    @Config.Ignore
    public static Ingredient portalIngredient;

    public static Set<ResourceLocation> initializeUncraftingList() {
        HashSet<ResourceLocation> RECIPE_LIST = new HashSet<ResourceLocation>();
        for (String str : uncraftingList) {
            RECIPE_LIST.add(new ResourceLocation(str));
        }
        return RECIPE_LIST;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("twilightforest")) {
            TwilightForestMod.checkOriginDimension();
            ConfigManager.sync((String)"twilightforest", (Config.Type)Config.Type.INSTANCE);
            if (!event.isWorldRunning()) {
                WorldProviderTwilightForest.syncFromConfig();
            }
            TFConfig.build();
        }
    }

    public static void build() {
        TFConfig.loadAntiBuilderBlacklist();
        TFConfig.buildPortalIngredient();
        loadingScreen.loadLoadingScreenIcons();
    }

    private static void loadAntiBuilderBlacklist() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(IMCHandler.getBlacklistedBlocks());
        for (String s : antibuilderBlacklist) {
            TFConfig.parseBlockState(s).ifPresent(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        }
        disallowBreakingBlockList = builder.build();
    }

    public static ImmutableSet<IBlockState> getDisallowedBlocks() {
        return disallowBreakingBlockList;
    }

    private static void buildPortalIngredient() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String s : portalCreationItems) {
            TFConfig.parseItemStack(s, Short.MAX_VALUE).ifPresent(stacks::add);
        }
        if (stacks.isEmpty()) {
            stacks.add(new ItemStack(Items.field_151045_i));
        }
        portalIngredient = Ingredient.func_193369_a((ItemStack[])stacks.toArray(new ItemStack[0]));
    }

    private static Optional<ItemStack> parseItemStack(String string, int defaultMeta) {
        String[] split = string.split(":");
        if (split.length < 2) {
            return Optional.empty();
        }
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
        if (item == null || item == Items.field_190931_a) {
            return Optional.empty();
        }
        int meta = defaultMeta;
        if (split.length > 2) {
            try {
                meta = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        if (meta < 0 || meta > Short.MAX_VALUE) {
            return Optional.empty();
        }
        return Optional.of(new ItemStack(item, 1, meta));
    }

    private static Optional<IBlockState> parseBlockState(String string) {
        int meta;
        String[] split = string.split(":");
        if (split.length < 2) {
            return Optional.empty();
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
        if (block == Blocks.field_150350_a) {
            return Optional.empty();
        }
        if (split.length == 2) {
            return Optional.of(block.func_176223_P());
        }
        try {
            meta = Integer.parseInt(split[2]);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
        if (meta < 0 || meta > 15) {
            return Optional.empty();
        }
        return Optional.of(block.func_176203_a(meta));
    }

    public static class LoadingScreen {
        @Config.LangKey(value="twilightforest.config.loading_icon_enable")
        @Config.Comment(value={"Wobble the Loading icon. Has no performance impact at all. For those who don't like fun."})
        public boolean enable = true;
        @Config.LangKey(value="twilightforest.config.loading_screen_swap_frequency")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"How many ticks between each loading screen change. Set to 0 to not cycle at all."})
        public int cycleLoadingScreenFrequency = 0;
        @Config.LangKey(value="twilightforest.config.loading_icon_wobble_bounce_frequency")
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Frequency of wobble and bounce."})
        public float frequency = 5.0f;
        @Config.LangKey(value="twilightforest.config.loading_icon_scale")
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Scale of whole bouncy loading icon."})
        public float scale = 3.0f;
        @Config.LangKey(value="twilightforest.config.loading_icon_bounciness")
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"How much the loading icon bounces."})
        public float scaleDeviation = 5.25f;
        @Config.LangKey(value="twilightforest.config.loading_icon_tilting")
        @Config.RangeDouble(min=0.0, max=360.0)
        @Config.Comment(value={"How far the loading icon wobbles."})
        public float tiltRange = 11.25f;
        @Config.LangKey(value="twilightforest.config.loading_icon_tilt_pushback")
        @Config.RangeDouble(min=0.0, max=360.0)
        @Config.Comment(value={"Pushback value to re-center the wobble of loading icon."})
        public float tiltConstant = 22.5f;
        @Config.LangKey(value="twilightforest.config.loading_icon_stacks")
        @Config.Comment(value={"List of items to be used for the wobbling Loading Icon. (domain:item:meta) meta is optional."})
        public String[] loadingIconStacks = new String[]{"twilightforest:experiment_115", "twilightforest:magic_map", "twilightforest:charm_of_life_2", "twilightforest:charm_of_keeping_3", "twilightforest:phantom_helmet", "twilightforest:lamp_of_cinders", "twilightforest:carminite", "twilightforest:block_and_chain", "twilightforest:yeti_helmet", "twilightforest:hydra_chop", "twilightforest:magic_beans", "twilightforest:ironwood_raw", "twilightforest:naga_scale", "twilightforest:experiment_115:2", "twilightforest:miniature_structure", "twilightforest:miniature_structure:6", "twilightforest:knightmetal_block", "twilightforest:tower_device:10", "twilightforest:twilight_sapling:5", "twilightforest:twilight_sapling:6", "twilightforest:twilight_sapling:7", "twilightforest:twilight_sapling:8", "twilightforest:twilight_sapling:9", "twilightforest:borer_essence"};
        @Config.Ignore
        private ImmutableList<ItemStack> loadingScreenIcons;

        public ImmutableList<ItemStack> getLoadingScreenIcons() {
            return this.loadingScreenIcons;
        }

        void loadLoadingScreenIcons() {
            ImmutableList.Builder iconList = ImmutableList.builder();
            iconList.addAll(IMCHandler.getLoadingIconStacks());
            for (String s : this.loadingIconStacks) {
                TFConfig.parseItemStack(s, 0).ifPresent(arg_0 -> ((ImmutableList.Builder)iconList).add(arg_0));
            }
            this.loadingScreenIcons = iconList.build();
        }
    }

    public static class ShieldInteractions {
        @Config.LangKey(value="twilightforest.config.parry_non_twilight")
        @Config.Comment(value={"Set to true to parry non-Twilight projectiles."})
        public boolean parryNonTwilightAttacks = false;
        @Config.LangKey(value="twilightforest.config.parry_window_arrow")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"The amount of ticks after raising a shield that makes it OK to parry an arrow."})
        public int shieldParryTicksArrow = 40;
        @Config.LangKey(value="twilightforest.config.parry_window_fireball")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"The amount of ticks after raising a shield that makes it OK to parry a fireball."})
        public int shieldParryTicksFireball = 40;
        @Config.LangKey(value="twilightforest.config.parry_window_throwable")
        @Config.RangeInt(min=0)
        @Config.Comment(value={"The amount of ticks after raising a shield that makes it OK to parry a thrown item."})
        public int shieldParryTicksThrowable = 40;
        @Config.LangKey(value="twilightforest.config.parry_window_beam")
        @Config.RangeInt(min=0)
        public int shieldParryTicksBeam = 10;
    }

    public static class Performance {
        @Config.LangKey(value="twilightforest.config.canopy_coverage")
        @Config.RangeDouble(min=0.0)
        @Config.Comment(value={"Amount of canopy coverage. Lower numbers improve chunk generation speed at the cost of a thinner forest."})
        public float canopyCoverage = 1.7f;
        @Config.LangKey(value="twilightforest.config.twilight_oaks")
        @Config.RangeInt(min=1)
        @Config.Comment(value={"Chance that a chunk in the Twilight Forest will contain a twilight oak tree. Higher numbers reduce the number of trees, increasing performance."})
        public int twilightOakChance = 48;
        @Config.LangKey(value="twilightforest.config.leaves_light_opacity")
        @Config.RangeInt(min=0, max=255)
        @Config.Comment(value={"This controls the opacity of leaves, changing the amount of light blocked. Can be used to decrease complexity in some lighting checks."})
        public int leavesLightOpacity = 1;
        @Config.LangKey(value="twilightforest.config.glacier_packed_ice")
        @Config.Comment(value={"Setting this true will make Twilight Glaciers generate with Packed Ice instead of regular translucent Ice, decreasing amount of light checking calculations."})
        public boolean glacierPackedIce = false;
        @Config.LangKey(value="twilightforest.config.enable_skylight")
        @Config.Comment(value={"If the dimension has per-block skylight values. Disabling this will significantly improve world generation performance, at the cost of flat lighting everywhere.\nWARNING: Once chunks are loaded without skylight, that data is lost and cannot easily be regenerated. Be careful!"})
        @Config.RequiresWorldRestart
        public boolean enableSkylight = true;
        @Config.Ignore
        public boolean shadersSupported = true;
    }

    public static class Dimension {
        @Config.LangKey(value="twilightforest.config.dimension_id")
        @Config.RequiresMcRestart
        @Config.Comment(value={"What ID number to assign to the Twilight Forest dimension. Change if you are having conflicts with another mod."})
        public int dimensionID = 7;
        @Config.LangKey(value="twilightforest.config.dimension_seed")
        @Config.RequiresWorldRestart
        @Config.Comment(value={"If set, this will override the normal world seed when generating parts of the Twilight Forest Dimension."})
        public String twilightForestSeed = "";
        @Config.LangKey(value="twilightforest.config.spawn_in_tf")
        @Config.Comment(value={"If true, players spawning for the first time will spawn in the Twilight Forest."})
        public boolean newPlayersSpawnInTF = false;
        @Config.LangKey(value="twilightforest.config.skylight_forest")
        @Config.RequiresWorldRestart
        @Config.Comment(value={"If true, Twilight Forest will generate as a void except for Major Structures"})
        public boolean skylightForest = false;
        @Config.LangKey(value="twilightforest.config.skylight_oaks")
        @Config.RequiresWorldRestart
        @Config.Comment(value={"If true, giant Twilight Oaks will also spawn in void worlds"})
        public boolean skylightOaks = true;
        @Config.LangKey(value="twilightforest.config.world_gen_weights")
        @Config.Comment(value={"Weights for various small features"})
        @Config.RequiresMcRestart
        public WorldGenWeights worldGenWeights = new WorldGenWeights();
        @Config.LangKey(value="twilightforest.config.hollow_hill_stalactites")
        @Config.Comment(value={"Defines custom stalactites generated in hollow hills.\nFormat is \"modid:block<:meta> size maxLength minHeight weight\", where the properties are:\nSize - the maximum length of the stalactite relative to the space between hill floor and ceiling,\nMax length - maximum length of a stalactite in blocks,\nMin height - minimum space between the hill floor and the stalactite to let it generate,\nWeight - how often it generates.\n\nFor example: \"minecraft:iron_ore 0.7 8 1 24\" would add a stalactite equal to the default iron ore stalactite."})
        @Config.RequiresMcRestart
        public HollowHillStalactites hollowHillStalactites = new HollowHillStalactites();

        public static class HollowHillStalactites {
            @Config.LangKey(value="twilightforest.config.large_hill")
            @Config.RequiresMcRestart
            @Config.Comment(value={"Blocks generating as stalactites in large hills only"})
            public String[] largeHill = new String[0];
            @Config.LangKey(value="twilightforest.config.medium_hill")
            @Config.RequiresMcRestart
            @Config.Comment(value={"Blocks generating as stalactites in medium and large hills"})
            public String[] mediumHill = new String[0];
            @Config.LangKey(value="twilightforest.config.small_hill")
            @Config.RequiresMcRestart
            @Config.Comment(value={"Blocks generating as stalactites in all hills"})
            public String[] smallHill = new String[0];
            @Config.LangKey(value="twilightforest.config.stalactite_config_only")
            @Config.RequiresMcRestart
            @Config.Comment(value={"If true, default stalactites and stalactites defined by other mods will not be used."})
            public boolean useConfigOnly = false;

            public void load() {
                this.registerHill(this.smallHill, 1);
                this.registerHill(this.mediumHill, 2);
                this.registerHill(this.largeHill, 3);
            }

            private void registerHill(String[] definitions, int tier) {
                for (String definition : definitions) {
                    if (this.parseStalactite(definition, tier)) continue;
                    TwilightForestMod.LOGGER.warn("Invalid hollow hill stalactite definition: {}", (Object)definition);
                }
            }

            private boolean parseStalactite(String definition, int tier) {
                String[] split = definition.split(" ");
                if (split.length != 5) {
                    return false;
                }
                Optional state = TFConfig.parseBlockState(split[0]);
                if (!state.isPresent()) {
                    return false;
                }
                try {
                    TFGenCaveStalactite.addStalactite(tier, (IBlockState)state.get(), Float.parseFloat(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]));
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }
        }

        public static class WorldGenWeights {
            @Config.LangKey(value="twilightforest.config.stone_circle_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int stoneCircleWeight = 10;
            @Config.LangKey(value="twilightforest.config.well_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int wellWeight = 10;
            @Config.LangKey(value="twilightforest.config.stalagmite_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int stalagmiteWeight = 12;
            @Config.LangKey(value="twilightforest.config.foundation_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int foundationWeight = 10;
            @Config.LangKey(value="twilightforest.config.monolith_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int monolithWeight = 10;
            @Config.LangKey(value="twilightforest.config.grove_ruins_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int groveRuinsWeight = 5;
            @Config.LangKey(value="twilightforest.config.hollow_stump_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int hollowStumpWeight = 12;
            @Config.LangKey(value="twilightforest.config.fallen_hollow_log_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int fallenHollowLogWeight = 10;
            @Config.LangKey(value="twilightforest.config.fallen_small_log_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int fallenSmallLogWeight = 10;
            @Config.LangKey(value="twilightforest.config.druid_hut_weight")
            @Config.RequiresMcRestart
            @Config.RangeInt(min=0)
            public int druidHutWeight = 10;
        }
    }
}

