/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.util.math;

import com.fuzs.aquaacrobatics.util.math.CubeCoordinateIterator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;

public class AxisAlignedBBSpliterator
extends Spliterators.AbstractSpliterator<AxisAlignedBB> {
    @Nullable
    private final Entity entity;
    private final AxisAlignedBB aabb;
    private final CubeCoordinateIterator cubeCoordinateIterator;
    private final World reader;
    private boolean isEntityPresent;
    private final BiPredicate<IBlockState, BlockPos> statePositionPredicate;

    public AxisAlignedBBSpliterator(World reader, @Nullable Entity entity, AxisAlignedBB aabb) {
        this(reader, entity, aabb, (state, pos) -> true);
    }

    public AxisAlignedBBSpliterator(World reader, @Nullable Entity entity, AxisAlignedBB aabb, BiPredicate<IBlockState, BlockPos> statePositionPredicate) {
        super(Long.MAX_VALUE, 1280);
        this.reader = reader;
        this.isEntityPresent = entity != null;
        this.entity = entity;
        this.aabb = aabb;
        this.statePositionPredicate = statePositionPredicate;
        int startX = MathHelper.func_76128_c((double)(aabb.field_72340_a - 1.0E-7)) - 1;
        int endX = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0E-7)) + 1;
        int startY = MathHelper.func_76128_c((double)(aabb.field_72338_b - 1.0E-7)) - 1;
        int heightY = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0E-7)) + 1;
        int startZ = MathHelper.func_76128_c((double)(aabb.field_72339_c - 1.0E-7)) - 1;
        int endZ = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0E-7)) + 1;
        this.cubeCoordinateIterator = new CubeCoordinateIterator(startX, startY, startZ, endX, heightY, endZ);
    }

    @Override
    public boolean tryAdvance(Consumer<? super AxisAlignedBB> consumer) {
        return this.isEntityPresent && this.isEntityOutsideOfBorder(consumer) || this.isAABBColliding(consumer);
    }

    private boolean isAABBColliding(Consumer<? super AxisAlignedBB> consumer) {
        BlockPos.PooledMutableBlockPos mutablePos = BlockPos.PooledMutableBlockPos.func_185346_s();
        while (this.cubeCoordinateIterator.hasNext()) {
            IBlockState blockstate;
            int x = this.cubeCoordinateIterator.getX();
            int y = this.cubeCoordinateIterator.getY();
            int z = this.cubeCoordinateIterator.getZ();
            int boundariesTouched = this.cubeCoordinateIterator.numBoundariesTouched();
            if (boundariesTouched == 3) continue;
            mutablePos.func_181079_c(x, y, z);
            if (!this.reader.func_175667_e((BlockPos)mutablePos) || !this.statePositionPredicate.test(blockstate = this.reader.func_180495_p((BlockPos)mutablePos), (BlockPos)mutablePos) || boundariesTouched == 2 && blockstate.func_177230_c() != Blocks.field_180384_M) continue;
            AxisAlignedBB collisionBoundingBox = blockstate.func_185890_d((IBlockAccess)this.reader, (BlockPos)mutablePos);
            if (collisionBoundingBox == Block.field_185505_j && blockstate.func_185917_h()) {
                AxisAlignedBB aabbOffset = collisionBoundingBox.func_72317_d((double)x, (double)y, (double)z);
                if (!this.aabb.func_72326_a(aabbOffset) || this.entity != null && !this.entity.func_174813_aQ().func_72326_a(aabbOffset)) continue;
                consumer.accept((AxisAlignedBB)collisionBoundingBox);
                mutablePos.func_185344_t();
                return true;
            }
            ArrayList collidingBoxes = Lists.newArrayList();
            this.getCollisionBoxList(collidingBoxes, blockstate, mutablePos);
            if (collidingBoxes.isEmpty()) continue;
            consumer.accept((AxisAlignedBB)collisionBoundingBox);
            mutablePos.func_185344_t();
            return true;
        }
        mutablePos.func_185344_t();
        return false;
    }

    private void getCollisionBoxList(List<AxisAlignedBB> collidingBoxes, IBlockState blockstate, BlockPos.PooledMutableBlockPos mutablePos) {
        blockstate.func_185908_a(this.reader, (BlockPos)mutablePos, this.aabb, collidingBoxes, this.entity, false);
        if (this.entity != null) {
            ArrayList entityCollidingBoxes = Lists.newArrayList();
            blockstate.func_185908_a(this.reader, (BlockPos)mutablePos, this.entity.func_174813_aQ(), (List)entityCollidingBoxes, this.entity, false);
            collidingBoxes.retainAll(entityCollidingBoxes);
        }
    }

    private boolean isEntityOutsideOfBorder(Consumer<? super AxisAlignedBB> consumer) {
        Objects.requireNonNull(this.entity);
        this.isEntityPresent = false;
        WorldBorder worldborder = this.reader.func_175723_af();
        AxisAlignedBB axisalignedbb = this.entity.func_174813_aQ();
        if (!AxisAlignedBBSpliterator.isBoundingBoxWithinBorder(worldborder, axisalignedbb)) {
            AxisAlignedBB borderShape = new AxisAlignedBB(worldborder.func_177726_b(), Double.NEGATIVE_INFINITY, worldborder.func_177736_c(), worldborder.func_177728_d(), Double.POSITIVE_INFINITY, worldborder.func_177733_e());
            consumer.accept((AxisAlignedBB)borderShape);
            return true;
        }
        return false;
    }

    public static boolean isBoundingBoxWithinBorder(WorldBorder worldBorder, AxisAlignedBB entityBoundingBox) {
        double minX = MathHelper.func_76128_c((double)worldBorder.func_177726_b());
        double minZ = MathHelper.func_76128_c((double)worldBorder.func_177736_c());
        double maxX = MathHelper.func_76143_f((double)worldBorder.func_177728_d());
        double maxZ = MathHelper.func_76143_f((double)worldBorder.func_177733_e());
        return entityBoundingBox.field_72340_a > minX && entityBoundingBox.field_72340_a < maxX && entityBoundingBox.field_72339_c > minZ && entityBoundingBox.field_72339_c < maxZ && entityBoundingBox.field_72336_d > minX && entityBoundingBox.field_72336_d < maxX && entityBoundingBox.field_72334_f > minZ && entityBoundingBox.field_72334_f < maxZ;
    }
}

