/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.proxy;

import com.fuzs.aquaacrobatics.AquaAcrobatics;
import com.fuzs.aquaacrobatics.biome.BiomeWaterFogColors;
import com.fuzs.aquaacrobatics.block.BlockBubbleColumn;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.core.AquaAcrobaticsCore;
import com.fuzs.aquaacrobatics.handler.CommonHandler;
import com.fuzs.aquaacrobatics.integration.IntegrationManager;
import com.fuzs.aquaacrobatics.integration.hats.HatsIntegration;
import com.fuzs.aquaacrobatics.integration.witchery.WitcheryResurrectedIntegration;
import com.fuzs.aquaacrobatics.network.NetworkHandler;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonProxy {
    @GameRegistry.ObjectHolder(value="aquaacrobatics:bubble_column")
    public static BlockBubbleColumn BUBBLE_COLUMN;

    private boolean needNetworking() {
        return ConfigHandler.MovementConfig.enableToggleCrawling;
    }

    public void onPreInit(FMLPreInitializationEvent event) {
        IntegrationManager.loadCompat();
        if (this.needNetworking()) {
            NetworkHandler.registerMessages("aquaacrobatics");
        }
        MinecraftForge.EVENT_BUS.register((Object)new CommonHandler());
    }

    public void onInit() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        if (ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            event.getRegistry().register((IForgeRegistryEntry)new BlockBubbleColumn());
        }
    }

    public void onPostInit() {
        if (IntegrationManager.isHatsEnabled()) {
            HatsIntegration.register();
        }
        if (IntegrationManager.isWitcheryResurrectedEnabled()) {
            WitcheryResurrectedIntegration.register();
        }
        if (!AquaAcrobaticsCore.isModCompatLoaded) {
            AquaAcrobatics.LOGGER.error("Please consider installing MixinBooter to ensure compatibility with more mods");
        }
        BiomeWaterFogColors.recomputeColors();
    }
}

