/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.config;

import com.fuzs.aquaacrobatics.biome.BiomeWaterFogColors;
import com.fuzs.aquaacrobatics.client.handler.FogHandler;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="aquaacrobatics")
@Mod.EventBusSubscriber
public class ConfigHandler {
    @Config.Name(value="Push Player Out Of Blocks")
    @Config.Comment(value={"STANDARD - The player will occasionally be pushed out of certain spaces. Collisions are evaluated for full cubes only, non-full cubes are ignored. This is the default behavior up to Minecraft 1.12.", "APPROXIMATE - The player can move into more spaces, but will still be pushed out of some. Collisions are evaluated for full cubes only, non-full cubes are ignored.", "EXACT - The player can move into all spaces as expected. Collisions are evaluated for all types of cubes. This is the default behavior in Minecraft 1.13 and onwards."})
    public static PlayerBlockCollisions playerBlockCollisions = PlayerBlockCollisions.APPROXIMATE;
    @Config.Name(value="blocks")
    @Config.Comment(value={"Block-related config options (must match server)."})
    public static BlocksConfig blocksConfig;
    @Config.Name(value="movement")
    @Config.Comment(value={"Movement related config options."})
    public static MovementConfig movementConfig;
    @Config.Name(value="miscellaneous")
    @Config.Comment(value={"Config options for various features of the mod."})
    public static MiscellaneousConfig miscellaneousConfig;
    @Config.Name(value="integration")
    @Config.Comment(value={"Control compatibility settings for individual mods."})
    public static IntegrationConfig integrationConfig;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.getModID().equals("aquaacrobatics")) {
            ConfigManager.sync((String)"aquaacrobatics", (Config.Type)Config.Type.INSTANCE);
        }
        BiomeWaterFogColors.recomputeColors();
        FogHandler.recomputeBlacklist();
    }

    public static enum PlayerBlockCollisions {
        STANDARD,
        APPROXIMATE,
        EXACT;

    }

    public static class IntegrationConfig {
        private static final String COMPAT_DESCRIPTION = "Only applies when the mod is installed. Disable when there are issues with the mod.";
        @Config.Name(value="Applied Energistics 2 Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        @Config.RequiresMcRestart
        public static boolean ae2Integration = true;
        @Config.Name(value="Betweenlands Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        @Config.RequiresMcRestart
        public static boolean betweenlandsIntegration = true;
        @Config.Name(value="Chiseled Me Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        @Config.RequiresMcRestart
        public static boolean chiseledMeIntegration = true;
        @Config.Name(value="Ender IO Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        @Config.RequiresMcRestart
        public static boolean enderIoIntegration = true;
        @Config.Name(value="Random Patches Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        public static boolean randomPatchesIntegration = true;
        @Config.Name(value="Mo' Bends Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        @Config.RequiresMcRestart
        public static boolean moBendsIntegration = true;
        @Config.Name(value="Wings Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        public static boolean wingsIntegration = true;
        @Config.Name(value="ArtemisLib Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        @Config.RequiresMcRestart
        public static boolean artemisLibIntegration = true;
        @Config.Name(value="Morph Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        public static boolean morphIntegration = true;
        @Config.Name(value="Hats Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        @Config.RequiresMcRestart
        public static boolean hatsIntegration = true;
        @Config.Name(value="Thaumic Augmentation Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        public static boolean thaumicAugmentationIntegration = true;
        @Config.Name(value="Trinkets and Baubles Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        public static boolean trinketsAndBaublesIntegration = true;
        @Config.Name(value="Witchery: Resurrected Integration")
        @Config.Comment(value={"Only applies when the mod is installed. Disable when there are issues with the mod."})
        public static boolean witcheryResurrectedIntegration = true;
    }

    public static class MiscellaneousConfig {
        @Config.Name(value="Replenish Air Slowly")
        @Config.Comment(value={"Replenish air slowly when out of water instead of immediately."})
        public static boolean slowAirReplenish = false;
        @Config.Name(value="Sneaking Dismounts Parrots")
        @Config.Comment(value={"Parrots no longer leave the players shoulders as easily, instead the player needs to press the sneak key."})
        public static boolean sneakingForParrots = true;
        @Config.Name(value="Eating Animation")
        @Config.Comment(value={"Animate eating in third-person view."})
        public static boolean eatingAnimation = true;
        @Config.Name(value="Bubble Columns")
        @Config.Comment(value={"Enable bubble columns."})
        public static boolean bubbleColumns = false;
        @Config.Name(value="Custom Biome Water Colors")
        @Config.Comment(value={"Allows overriding the water and fog colors for a biome. Specify each entry like this (without quotes) - 'modname:biome,color,fogcolor'"})
        public static String[] customBiomeWaterColors = new String[0];
        @Config.Name(value="WorldProvider Fog Blacklist")
        @Config.Comment(value={"List of WorldProviders in which fog should be disabled."})
        public static String[] providerFogBlacklist = new String[]{"thebetweenlands.common.world.WorldProviderBetweenlands"};
        @Config.Name(value="Floating Items")
        @Config.Comment(value={"Whether or not items should float in water like in 1.13+."})
        public static boolean floatingItems = true;
    }

    public static class BlocksConfig {
        @Config.Name(value="Seagrass")
        @Config.Comment(value={"Allow seagrass to generate in the world."})
        public static boolean seagrass = false;
        @Config.Name(value="Brighter Water")
        @Config.Comment(value={"Make water only reduce light level by 1 per Y-level, instead of 3."})
        public static boolean brighterWater = true;
        @Config.Name(value="New Water")
        @Config.Comment(value={"Use the new water rendering in 1.13+."})
        public static boolean newWaterColors = true;
        @Config.Name(value="New Water Fog")
        @Config.Comment(value={"Use the new fog rendering in 1.13+."})
        public static boolean newWaterFog = true;
    }

    public static class MovementConfig {
        @Config.Name(value="Easy Elytra Takeoff")
        @Config.Comment(value={"Taking off with an elytra from the ground is now far easier like in Minecraft 1.15 and onwards."})
        public static boolean easyElytraTakeoff = true;
        @Config.Name(value="No Double Tab Sprinting")
        @Config.Comment(value={"Prevent sprinting from being triggered by double tapping the walk forward key."})
        public static boolean noDoubleTapSprinting = false;
        @Config.Name(value="Sideways Sprinting")
        @Config.Comment(value={"Enables sprinting to the left and right."})
        public static boolean sidewaysSprinting = false;
        @Config.Name(value="Sideways Swimming")
        @Config.Comment(value={"Enables swimming to the left and right."})
        public static boolean sidewaysSwimming = false;
        @Config.Name(value="Enable Crawling")
        @Config.Comment(value={"Enables crawling to prevent suffocation. Note that if you disable this there will probably be behavioral differences from 1.13."})
        public static boolean enableCrawling = true;
        @Config.Name(value="Enable Toggle Crawling")
        @Config.Comment(value={"Enables a keybind to toggle crawling."})
        public static boolean enableToggleCrawling = false;
        @Config.Name(value="New Projectile Behavior")
        @Config.Comment(value={"Modify projectile behavior to be closer to that of newer versions (fixes MC-73884 and allows bubble columns to work with ender pearls)."})
        public static boolean newProjectileBehavior = false;
        @Config.Name(value="New Climbing Behavior")
        @Config.Comment(value={"Allow climbing vines and climbing by pressing jump."})
        public static boolean newClimbingBehavior = false;
    }
}

