/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.damagecontrol.handler;

import net.darkhax.damagecontrol.handler.ConfigurationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DamageHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWorldLoad(WorldEvent.Load event) {
        if (ConfigurationHandler.healthAllowed) {
            for (ResourceLocation entityId : EntityList.field_75627_a.keySet()) {
                Entity entity = EntityList.func_188429_b((ResourceLocation)entityId, (World)event.getWorld());
                if (!(entity instanceof EntityLivingBase)) continue;
                ConfigurationHandler.getMaxHealth(entityId, (EntityLivingBase)entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityLivingBase entity;
        float modifiedMaxHealth;
        if (ConfigurationHandler.healthAllowed && event.getEntity() instanceof EntityLivingBase && (modifiedMaxHealth = ConfigurationHandler.getMaxHealth(entity = (EntityLivingBase)event.getEntity()) * ConfigurationHandler.healthModifier) >= 0.0f) {
            float currentMaxHealth = (float)entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
            if (currentMaxHealth != modifiedMaxHealth) {
                entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)modifiedMaxHealth);
            }
            if (entity.func_110143_aJ() == currentMaxHealth) {
                entity.func_70606_j(modifiedMaxHealth);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityHurt(LivingHurtEvent event) {
        event.setAmount(event.getAmount() * ConfigurationHandler.getDamageModifier(event.getSource()));
    }
}

