/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.damagecontrol.handler;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    private static final Map<ResourceLocation, Float> entityBaseHealth = new HashMap<ResourceLocation, Float>();
    private static final Map<DamageSource, Float> damageModifiers = new HashMap<DamageSource, Float>();
    public static float healthModifier = 1.0f;
    public static boolean healthAllowed = true;
    private static Configuration config = null;

    public static void initConfig(File file) {
        config = new Configuration(file);
    }

    public static void syncConfig() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void initGlobalModifiers() {
        String category = "GLOBAL_MODIFIERS";
        healthModifier = config.getFloat("GlobalMaxHealthModifier", "GLOBAL_MODIFIERS", 1.0f, 0.0f, 1024.0f, "The global max health modifier.");
        healthAllowed = config.getBoolean("AllowHealthModification", "GLOBAL_MODIFIERS", true, "Whether to allow health modification by the mod. If false, health modifiers will not be applied. Useful for compatibility reasons");
        ConfigurationHandler.syncConfig();
    }

    public static void initDamageSourceModifiers() {
        DamageSource[] sources;
        for (DamageSource source : sources = new DamageSource[]{DamageSource.field_76372_a, DamageSource.field_180137_b, DamageSource.field_76370_b, DamageSource.field_76371_c, DamageSource.field_190095_e, DamageSource.field_76368_d, DamageSource.field_76369_e, DamageSource.field_76366_f, DamageSource.field_76367_g, DamageSource.field_76379_h, DamageSource.field_188406_j, DamageSource.field_76380_i, DamageSource.field_76377_j, DamageSource.field_76376_m, DamageSource.field_82727_n, DamageSource.field_82728_o, DamageSource.field_82729_p, DamageSource.field_188407_q}) {
            ConfigurationHandler.getDamageModifier(source);
        }
    }

    public static float getMaxHealth(EntityLivingBase entity) {
        return ConfigurationHandler.getMaxHealth(EntityList.func_191301_a((Entity)entity), entity);
    }

    public static float getDamageModifier(DamageSource source) {
        if (damageModifiers.containsKey(source)) {
            return damageModifiers.get(source).floatValue();
        }
        float modifier = config.getFloat("DamageModifier_" + source.field_76373_n, "DAMAGE_SOURCE_MODIFIERS", 1.0f, 0.0f, 1024.0f, "The modifier for all damage from the " + source.field_76373_n + " source.");
        damageModifiers.put(source, Float.valueOf(modifier));
        ConfigurationHandler.syncConfig();
        return modifier;
    }

    public static float getMaxHealth(ResourceLocation entityId, EntityLivingBase entity) {
        if (entityBaseHealth.containsKey(entityId)) {
            return entityBaseHealth.get(entityId).floatValue();
        }
        float configAmount = config.getFloat("MaxHealth_" + entityId, "MAX_HEALTH", (float)entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e(), -1.0f, (float)((RangedAttribute)SharedMonsterAttributes.field_111267_a).field_111118_b, "The maximum health value for " + entityId + ". Negative values deactivate health modification for this entity.");
        entityBaseHealth.put(entityId, Float.valueOf(configAmount));
        ConfigurationHandler.syncConfig();
        return configAmount;
    }
}

