/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.packer;

import com.codetaylor.mc.athenaeum.packer.ImageMetaData;
import com.codetaylor.mc.athenaeum.packer.ImageVisitor;
import com.codetaylor.mc.athenaeum.packer.PackData;
import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ImageCollector {
    private final Gson gson;

    public ImageCollector(Gson gson) {
        this.gson = gson;
    }

    public Map<String, Map<String, ImageData>> collect(PackData.PathData[] input) throws IOException {
        HashMap<String, Map<String, ImageData>> map = new HashMap<String, Map<String, ImageData>>();
        for (PackData.PathData pathData : input) {
            Path path = pathData.path;
            String atlas = pathData.atlas;
            Map imageMap = map.computeIfAbsent(atlas, k -> new TreeMap());
            Files.walkFileTree(path, new ImageVisitor(this.gson, path, imageMap));
        }
        return map;
    }

    public static class ImageData {
        public BufferedImage image;
        public ImageMetaData metaData;
    }
}

