/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.util;

import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.util.InteractionRayTraceData;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class InteractionRayTracer {
    private static final double NORTH_SIN = Math.sin(0.0);
    private static final double NORTH_COS = Math.cos(0.0);
    private static final double EAST_SIN = Math.sin(4.71238898038469);
    private static final double EAST_COS = Math.cos(4.71238898038469);
    private static final double SOUTH_SIN = Math.sin(Math.PI);
    private static final double SOUTH_COS = Math.cos(Math.PI);
    private static final double WEST_SIN = Math.sin(1.5707963267948966);
    private static final double WEST_COS = Math.cos(1.5707963267948966);

    @Nullable
    public static <T extends TileEntity> RayTraceResult collisionRayTrace(RayTraceResult result, T tile, IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, Vec3d end) {
        if (result == null) {
            return null;
        }
        Vec3d blockStart = new Vec3d(start.field_72450_a - (double)pos.func_177958_n(), start.field_72448_b - (double)pos.func_177956_o(), start.field_72449_c - (double)pos.func_177952_p());
        Vec3d blockEnd = new Vec3d(end.field_72450_a - (double)pos.func_177958_n(), end.field_72448_b - (double)pos.func_177956_o(), end.field_72449_c - (double)pos.func_177952_p());
        EnumFacing tileFacing = ((ITileInteractable)tile).getTileFacing(world, pos, blockState);
        blockStart = InteractionRayTracer.rotate(blockStart, tileFacing);
        blockEnd = InteractionRayTracer.rotate(blockEnd, tileFacing);
        Vec3d grow = blockEnd.func_178788_d(blockStart).func_72432_b().func_186678_a(2.0);
        blockStart = blockStart.func_178788_d(grow);
        blockEnd = blockEnd.func_178787_e(grow);
        IInteraction[] interactions = ((ITileInteractable)tile).getInteractions();
        if (interactions.length == 0) {
            return result;
        }
        InteractionRayTraceData.List resultDataList = new InteractionRayTraceData.List();
        for (int i = 0; i < interactions.length; ++i) {
            RayTraceResult candidateTrace;
            if (!interactions[i].isEnabled() || (candidateTrace = interactions[i].getInteractionBounds(world, pos, blockState).func_72327_a(blockStart, blockEnd)) == null || !interactions[i].allowInteractionWithSide(candidateTrace.field_178784_b)) continue;
            RayTraceResult trace = new RayTraceResult(candidateTrace.field_72313_a, candidateTrace.field_72307_f, candidateTrace.field_178784_b, pos);
            double distanceSq = blockStart.func_72436_e(trace.field_72307_f);
            resultDataList.add(new InteractionRayTraceData(distanceSq, trace, interactions[i]));
        }
        if (resultDataList.isEmpty()) {
            return result;
        }
        Collections.sort(resultDataList);
        result.hitInfo = resultDataList;
        return result;
    }

    private static Vec3d rotate(Vec3d vec, EnumFacing tileFacing) {
        switch (tileFacing) {
            case NORTH: {
                return new Vec3d(0.5 + (vec.field_72450_a - 0.5) * NORTH_COS - (vec.field_72449_c - 0.5) * NORTH_SIN, vec.field_72448_b, 0.5 + (vec.field_72450_a - 0.5) * NORTH_SIN + (vec.field_72449_c - 0.5) * NORTH_COS);
            }
            case EAST: {
                return new Vec3d(0.5 + (vec.field_72450_a - 0.5) * EAST_COS - (vec.field_72449_c - 0.5) * EAST_SIN, vec.field_72448_b, 0.5 + (vec.field_72450_a - 0.5) * EAST_SIN + (vec.field_72449_c - 0.5) * EAST_COS);
            }
            case SOUTH: {
                return new Vec3d(0.5 + (vec.field_72450_a - 0.5) * SOUTH_COS - (vec.field_72449_c - 0.5) * SOUTH_SIN, vec.field_72448_b, 0.5 + (vec.field_72450_a - 0.5) * SOUTH_SIN + (vec.field_72449_c - 0.5) * SOUTH_COS);
            }
            case WEST: {
                return new Vec3d(0.5 + (vec.field_72450_a - 0.5) * WEST_COS - (vec.field_72449_c - 0.5) * WEST_SIN, vec.field_72448_b, 0.5 + (vec.field_72450_a - 0.5) * WEST_SIN + (vec.field_72449_c - 0.5) * WEST_COS);
            }
        }
        throw new IllegalArgumentException("Unsupported facing: " + tileFacing);
    }

    private InteractionRayTracer() {
    }
}

