/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.spi;

import com.codetaylor.mc.athenaeum.ModAthenaeumConfig;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.ITileInteractable;
import com.codetaylor.mc.athenaeum.interaction.util.InteractionRayTraceData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;

public class TESRInteractable<T extends TileEntity>
extends TileEntitySpecialRenderer<T> {
    public void func_192841_a(T te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        RayTraceResult rayTraceResult;
        World world = te.func_145831_w();
        IBlockState blockState = world.func_180495_p(te.func_174877_v());
        boolean allowInteractionWithPlayer = ((ITileInteractable)te).allowInteractionWithPlayer((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int renderPass = MinecraftForgeClient.getRenderPass();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        EnumFacing facing = ((ITileInteractable)te).getTileFacing(world, te.func_174877_v(), blockState);
        int yaw = 0;
        switch (facing) {
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                yaw = -90;
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                yaw = -180;
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                yaw = -270;
            }
        }
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        if (renderPass == 0) {
            this.renderSolidPass(te, world, blockState, partialTicks);
        } else if (renderPass == 1 && allowInteractionWithPlayer) {
            this.renderAdditivePass(te, partialTicks, world, blockState);
        }
        if (allowInteractionWithPlayer && (rayTraceResult = Minecraft.func_71410_x().field_71476_x) != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && (te.func_174877_v().equals((Object)rayTraceResult.func_178782_a()) || ((ITileInteractable)te).isExtendedInteraction(world, rayTraceResult.func_178782_a(), world.func_180495_p(rayTraceResult.func_178782_a())))) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (minecraft.field_71439_g.func_70093_af() || ModAthenaeumConfig.INTERACTION_CLIENT.ALWAYS_SHOW_QUANTITIES) {
                FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
                IInteraction[] interactions = ((ITileInteractable)te).getInteractions();
                EnumFacing horizontalFacing = minecraft.field_71439_g.func_174811_aO();
                for (int i = 0; i < interactions.length; ++i) {
                    Vec3d textOffset = interactions[i].getTextOffset(facing, horizontalFacing, rayTraceResult.field_178784_b);
                    if (textOffset == null) continue;
                    interactions[i].renderSolidPassText(world, fontrenderer, yaw, textOffset, te.func_174877_v(), blockState, partialTicks);
                }
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    protected void renderSolidPass(T te, World world, IBlockState blockState, float partialTicks) {
        Minecraft minecraft = Minecraft.func_71410_x();
        RenderItem renderItem = minecraft.func_175599_af();
        RenderHelper.func_74519_b();
        GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
        IInteraction[] interactions = ((ITileInteractable)te).getInteractions();
        for (int i = 0; i < interactions.length; ++i) {
            interactions[i].renderSolidPass(world, renderItem, te.func_174877_v(), blockState, partialTicks);
        }
    }

    protected void renderAdditivePass(T te, float partialTicks, World world, IBlockState blockState) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        RayTraceResult rayTraceResult = Minecraft.func_71410_x().field_71476_x;
        if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && rayTraceResult.hitInfo instanceof InteractionRayTraceData.List && (te.func_174877_v().equals((Object)rayTraceResult.func_178782_a()) || ((ITileInteractable)te).isExtendedInteraction(world, rayTraceResult.func_178782_a(), world.func_180495_p(rayTraceResult.func_178782_a())))) {
            int i;
            InteractionRayTraceData.List results = (InteractionRayTraceData.List)rayTraceResult.hitInfo;
            for (i = 0; i < results.size(); ++i) {
                InteractionRayTraceData data = (InteractionRayTraceData)results.get(i);
                IInteraction interaction = data.getInteraction();
                RayTraceResult result = data.getRayTraceResult();
                if ((!player.func_70093_af() || interaction.forceRenderAdditivePassWhileSneaking()) && interaction.allowInteractionWithSide(result.field_178784_b) && interaction.renderAdditivePass(world, renderItem, result.field_178784_b, result.field_72307_f, result.func_178782_a(), blockState, player.func_184614_ca(), partialTicks)) break;
            }
            if (!results.isEmpty() && ModAthenaeumConfig.INTERACTION_CLIENT.SHOW_INTERACTION_BOUNDS) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.func_179141_d();
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GlStateManager.func_179091_B();
                GlStateManager.func_187441_d((float)8.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (i = 0; i < results.size(); ++i) {
                    BlockPos pos = rayTraceResult.func_178782_a();
                    InteractionRayTraceData data = (InteractionRayTraceData)results.get(i);
                    IInteraction interaction = data.getInteraction();
                    AxisAlignedBB bounds = interaction.getInteractionBounds(world, pos, blockState).func_72321_a((double)0.002f, (double)0.002f, (double)0.002f);
                    RenderGlobal.func_189697_a((AxisAlignedBB)bounds, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179101_C();
                GlStateManager.func_179098_w();
            }
        }
    }
}

