/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.spi;

import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteractionItem;
import com.codetaylor.mc.athenaeum.interaction.spi.InteractionBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class InteractionUseItemBase<T extends TileEntity>
extends InteractionBase<T> {
    public InteractionUseItemBase(EnumFacing[] sides, AxisAlignedBB bounds) {
        super(sides, bounds);
    }

    @Override
    public boolean allowInteractionWithType(IInteraction.EnumType type) {
        return type == IInteraction.EnumType.MouseClick;
    }

    @Override
    public boolean interact(IInteraction.EnumType type, T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (this.allowInteractionWithHand(hand) && this.allowInteractionWithType(type) && this.allowInteraction(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ)) {
            boolean complete = this.doInteraction(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ);
            if (complete) {
                this.postInteraction(tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ);
            }
            return complete;
        }
        return false;
    }

    protected void postInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !player.func_184812_l_()) {
            this.applyItemDamage(player.func_184586_b(hand), player);
        }
    }

    protected void applyItemDamage(ItemStack itemStack, EntityPlayer player) {
        if (itemStack.func_77973_b() instanceof IInteractionItem) {
            ((IInteractionItem)itemStack.func_77973_b()).applyItemDamage(itemStack, player);
        } else {
            itemStack.func_77972_a(this.getItemDamage(itemStack), (EntityLivingBase)player);
        }
    }

    protected int getItemDamage(ItemStack itemStack) {
        return 1;
    }

    protected boolean allowInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184614_ca();
        Item item = heldItem.func_77973_b();
        if (item instanceof IInteractionItem) {
            return ((IInteractionItem)item).allowInteraction((TileEntity)tile, world, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ);
        }
        return false;
    }

    protected boolean doInteraction(T tile, World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184614_ca();
        Item item = heldItem.func_77973_b();
        if (item instanceof IInteractionItem) {
            return ((IInteractionItem)item).doInteraction((TileEntity)tile, world, heldItem, hitPos, state, player, hand, hitSide, hitX, hitY, hitZ);
        }
        return false;
    }
}

