/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.network;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.container.ContainerEntityEditor;
import com.tmtravlr.mapgadgets.container.ContainerItemEditor;
import com.tmtravlr.mapgadgets.container.ContainerPotionMaker;
import com.tmtravlr.mapgadgets.container.ContainerTradeEditor;
import com.tmtravlr.mapgadgets.items.ItemSpawnerEditor;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketHandlerServer
implements IMessageHandler<CToSMessage, IMessage> {
    public static final int UPDATE_ITEM_EDITOR = 0;
    public static final int UPDATE_VILLAGER_TRADE_INDEX = 1;
    public static final int UPDATE_VILLAGER_INFINITE_TRADES = 2;
    public static final int UPDATE_VILLAGER_NAME_INVULNERABLE = 3;
    public static final int UPDATE_SPAWNER_STATS = 4;
    public static final int UPDATE_POTION_MAKER = 5;
    public static final int UPDATE_ENTITY_EDITOR_ENTTIY_STATS = 6;
    public static final int UPDATE_ENTITY_EDITOR_MOB_STATS = 7;
    public static final int UPDATE_ENTITY_EDITOR_EQUIPMENT = 8;
    public static final int UPDATE_ENTITY_EDITOR_ATTRIBUTES = 9;

    public IMessage onMessage(CToSMessage packet, MessageContext context) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return null;
        }
        PacketBuffer buff = new PacketBuffer(Unpooled.wrappedBuffer((byte[])packet.getData()));
        int type = buff.readInt();
        switch (type) {
            case 0: {
                server.func_152344_a(() -> {
                    try {
                        int dimensionId = buff.readInt();
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        ItemStack enchStack = buff.func_150791_c();
                        WorldServer world = server.func_71218_a(dimensionId);
                        EntityPlayer player = world.func_152378_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.field_71070_bA instanceof ContainerItemEditor) {
                            ((ContainerItemEditor)player.field_71070_bA).updateEnchantedItem(enchStack);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update item editor.", (Throwable)e);
                    }
                });
                break;
            }
            case 1: {
                server.func_152344_a(() -> {
                    try {
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        int index = buff.readInt();
                        EntityPlayerMP player = server.func_184103_al().func_177451_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.field_71070_bA instanceof ContainerTradeEditor) {
                            ((ContainerTradeEditor)player.field_71070_bA).changeRecipe(index);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update villager trade index.", (Throwable)e);
                    }
                });
                break;
            }
            case 2: {
                server.func_152344_a(() -> {
                    try {
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        boolean infiniteTrades = buff.readBoolean();
                        EntityPlayerMP player = server.func_184103_al().func_177451_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.field_71070_bA instanceof ContainerTradeEditor) {
                            ((ContainerTradeEditor)player.field_71070_bA).setInfiniteTrades(infiniteTrades);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update villager infinite trades.", (Throwable)e);
                    }
                });
                break;
            }
            case 3: {
                server.func_152344_a(() -> {
                    try {
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        int dimensionId = buff.readInt();
                        boolean invulnerable = buff.readBoolean();
                        String customNameTag = buff.func_150789_c(1000);
                        EntityPlayerMP player = server.func_184103_al().func_177451_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.field_71070_bA instanceof ContainerTradeEditor) {
                            ((ContainerTradeEditor)player.field_71070_bA).setNameInvulnerable(customNameTag, invulnerable);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update villager name and invulnerability.", (Throwable)e);
                    }
                });
                break;
            }
            case 4: {
                server.func_152344_a(() -> {
                    try {
                        TileEntity te;
                        WorldServer world;
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        int dimensionId = buff.readInt();
                        BlockPos spawnerPos = buff.func_179259_c();
                        EntityPlayerMP player = server.func_184103_al().func_177451_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.func_189808_dh() && (world = server.func_71218_a(dimensionId)) != null && (te = world.func_175625_s(spawnerPos)) instanceof TileEntityMobSpawner) {
                            NBTTagCompound spawnerTag = te.func_189515_b(new NBTTagCompound());
                            short spawnCount = (short)MathHelper.func_76125_a((int)buff.readShort(), (int)0, (int)Short.MAX_VALUE);
                            short maxNearby = (short)MathHelper.func_76125_a((int)buff.readShort(), (int)0, (int)Short.MAX_VALUE);
                            short spawnRange = (short)MathHelper.func_76125_a((int)buff.readShort(), (int)0, (int)Short.MAX_VALUE);
                            short playerRange = (short)MathHelper.func_76125_a((int)buff.readShort(), (int)0, (int)Short.MAX_VALUE);
                            short delay = (short)MathHelper.func_76125_a((int)buff.readShort(), (int)-1, (int)Short.MAX_VALUE);
                            short minDelay = (short)MathHelper.func_76125_a((int)buff.readShort(), (int)1, (int)Short.MAX_VALUE);
                            short maxDelay = (short)MathHelper.func_76125_a((int)buff.readShort(), (int)1, (int)Short.MAX_VALUE);
                            spawnerTag.func_74777_a("SpawnCount", spawnCount);
                            spawnerTag.func_74777_a("MaxNearbyEntities", maxNearby);
                            spawnerTag.func_74777_a("SpawnRange", spawnRange);
                            spawnerTag.func_74777_a("RequiredPlayerRange", playerRange);
                            spawnerTag.func_74777_a("Delay", delay);
                            spawnerTag.func_74777_a("MinSpawnDelay", minDelay);
                            spawnerTag.func_74777_a("MaxSpawnDelay", maxDelay);
                            te.func_145839_a(spawnerTag);
                            ItemStack stack = ItemSpawnerEditor.getHeldSpawnerEditor((EntityPlayer)player);
                            if (!stack.func_190926_b()) {
                                ItemSpawnerEditor.saveSpawnerToItem(stack, (TileEntityMobSpawner)te);
                            }
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update villager name and invulnerability.", (Throwable)e);
                    }
                });
                break;
            }
            case 5: {
                server.func_152344_a(() -> {
                    try {
                        int dimensionId = buff.readInt();
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        NBTTagCompound potionTag = buff.func_150793_b();
                        WorldServer world = server.func_71218_a(dimensionId);
                        EntityPlayer player = world.func_152378_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (potionTag != null && player != null && player.field_71070_bA instanceof ContainerPotionMaker) {
                            ((ContainerPotionMaker)player.field_71070_bA).updatePotionTag(potionTag);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update potion maker tag.", (Throwable)e);
                    }
                });
                break;
            }
            case 6: {
                server.func_152344_a(() -> {
                    try {
                        int dimensionId = buff.readInt();
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        WorldServer world = server.func_71218_a(dimensionId);
                        EntityPlayer player = world.func_152378_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.field_71070_bA instanceof ContainerEntityEditor) {
                            ((ContainerEntityEditor)player.field_71070_bA).updateEntityStats(buff);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update potion maker tag.", (Throwable)e);
                    }
                });
                break;
            }
            case 7: {
                server.func_152344_a(() -> {
                    try {
                        int dimensionId = buff.readInt();
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        WorldServer world = server.func_71218_a(dimensionId);
                        EntityPlayer player = world.func_152378_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.field_71070_bA instanceof ContainerEntityEditor) {
                            ((ContainerEntityEditor)player.field_71070_bA).updateMobStats(buff);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update potion maker tag.", (Throwable)e);
                    }
                });
                break;
            }
            case 8: {
                server.func_152344_a(() -> {
                    try {
                        int dimensionId = buff.readInt();
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        WorldServer world = server.func_71218_a(dimensionId);
                        EntityPlayer player = world.func_152378_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.field_71070_bA instanceof ContainerEntityEditor) {
                            ((ContainerEntityEditor)player.field_71070_bA).updateEquipment(buff);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update potion maker tag.", (Throwable)e);
                    }
                });
                break;
            }
            case 9: {
                server.func_152344_a(() -> {
                    try {
                        int dimensionId = buff.readInt();
                        long playerUUIDMost = buff.readLong();
                        long playerUUIDLeast = buff.readLong();
                        WorldServer world = server.func_71218_a(dimensionId);
                        EntityPlayer player = world.func_152378_a(new UUID(playerUUIDMost, playerUUIDLeast));
                        if (player != null && player.field_71070_bA instanceof ContainerEntityEditor) {
                            ((ContainerEntityEditor)player.field_71070_bA).updateAttributes(buff);
                        }
                    }
                    catch (Exception e) {
                        MapGadgetsMod.logger.warn("Error while trying to update potion maker tag.", (Throwable)e);
                    }
                });
                break;
            }
        }
        return null;
    }
}

