/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.items;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.gui.CommonGuiStuff;
import com.tmtravlr.mapgadgets.items.ItemInteractor;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTradeEditor
extends ItemInteractor {
    public static final Item INSTANCE = (Item)new ItemTradeEditor().func_77625_d(1).func_77637_a(MapGadgetsMod.creativeTab).func_77655_b("trade_editor").setRegistryName("mapgadgets", "trade_editor");

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_189808_dh()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.trade_editor.info.line1"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.trade_editor.info.line2"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.trade_editor.info.line3"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.trade_editor.info.line4"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.trade_editor.info.line5"));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74775_l("Villager").func_74764_b("CustomName") && !stack.func_77978_p().func_74775_l("Villager").func_74779_i("CustomName").isEmpty()) {
                name = name + " - " + stack.func_77978_p().func_74775_l("Villager").func_74779_i("CustomName");
            } else if (stack.func_77978_p().func_74775_l("Villager").func_74775_l("ForgeData").func_74764_b("OriginalVillagerName")) {
                name = name + " - " + stack.func_77978_p().func_74775_l("Villager").func_74775_l("ForgeData").func_74779_i("OriginalVillagerName");
            }
        }
        return name;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_189808_dh()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!stack.func_77942_o() || stack.func_77978_p().func_74775_l("Villager").func_82582_d() || !stack.func_77978_p().func_74775_l("Villager").func_74764_b("id")) {
            return EnumActionResult.FAIL;
        }
        NBTTagCompound villagerTag = stack.func_77978_p().func_74775_l("Villager");
        ResourceLocation villagerId = new ResourceLocation(villagerTag.func_74779_i("id"));
        BlockPos offsetPos = pos.func_177972_a(facing);
        Entity entity = EntityList.func_188429_b((ResourceLocation)villagerId, (World)world);
        if (!(entity instanceof EntityVillager)) {
            return EnumActionResult.FAIL;
        }
        EntityVillager villager = (EntityVillager)entity;
        float rotationYaw = player.field_70177_z + 180.0f;
        villager.func_70012_b((double)offsetPos.func_177958_n() + 0.5, (double)offsetPos.func_177956_o() + 0.1, (double)offsetPos.func_177952_p() + 0.5, rotationYaw > 360.0f ? rotationYaw - 360.0f : rotationYaw, 0.0f);
        villager.field_70759_as = villager.field_70177_z;
        villager.field_70761_aq = villager.field_70177_z;
        villager.func_180482_a(world.func_175649_E(offsetPos), (IEntityLivingData)null);
        world.func_72838_d(entity);
        villager.func_70642_aH();
        NBTTagCompound currentVillagerTag = villager.func_189511_e(new NBTTagCompound());
        UUID uuid = villager.func_110124_au();
        currentVillagerTag.func_179237_a(villagerTag);
        villager.func_70020_e(currentVillagerTag);
        villager.func_184221_a(uuid);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void interact(ItemStack tradeStack, EntityPlayer player, Entity entity) {
        if (player.field_70170_p.field_72995_K || !(entity instanceof EntityVillager)) {
            return;
        }
        EntityVillager villager = (EntityVillager)entity;
        ItemTradeEditor.setVillagerTag(tradeStack, villager);
        int invulnerable = villager.func_190530_aW() ? 1 : 0;
        int infiniteTrades = villager.getEntityData().func_74767_n("Mapmaker's Gadgets - Infinite Trades") ? 1 : 0;
        player.openGui((Object)MapGadgetsMod.instance, MapGadgetsMod.GUI_TRADE_EDITOR, player.field_70170_p, villager.func_145782_y(), infiniteTrades, invulnerable);
    }

    public static void setVillagerTag(ItemStack stack, EntityVillager villager) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound villagerTag = new NBTTagCompound();
        villagerTag = villager.func_189511_e(villagerTag);
        villagerTag.func_74778_a("id", String.valueOf(EntityList.func_191301_a((Entity)villager)));
        NBTTagCompound forgeData = villagerTag.func_74775_l("ForgeData");
        forgeData.func_74778_a("OriginalVillagerName", CommonGuiStuff.getOriginalEntityName((Entity)villager));
        villagerTag.func_74782_a("ForgeData", (NBTBase)forgeData);
        villagerTag.func_82580_o("Pos");
        villagerTag.func_82580_o("Rotation");
        stack.func_77978_p().func_74782_a("Villager", (NBTBase)villagerTag);
    }

    public static void addToVillagerTag(ItemStack stack, String customNameTag, boolean invulnerable) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound villagerTag = stack.func_77978_p().func_74775_l("Villager");
        villagerTag.func_74757_a("Invulnerable", invulnerable);
        villagerTag.func_74778_a("CustomName", customNameTag);
        stack.func_77978_p().func_74782_a("Villager", (NBTBase)villagerTag);
    }
}

