/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.items;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpawnerEditor
extends Item {
    public static final Item INSTANCE = (Item)new ItemSpawnerEditor().func_77625_d(1).func_77637_a(MapGadgetsMod.creativeTab).func_77655_b("spawner_editor").setRegistryName("mapgadgets", "spawner_editor");

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_189808_dh()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.spawner_editor.info.line1"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.spawner_editor.info.line2"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.spawner_editor.info.line3"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.spawner_editor.info.line4"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.spawner_editor.info.line5"));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        if (stack.func_77942_o() && stack.func_77978_p().func_74775_l("SpawnerTag").func_150297_b("SpawnData", 10)) {
            String mobName = EntityList.func_191302_a((ResourceLocation)new ResourceLocation(stack.func_179543_a("SpawnerTag").func_74775_l("SpawnData").func_74779_i("id")));
            name = mobName == null || stack.func_179543_a("SpawnerTag").func_74775_l("SpawnData").func_74764_b("CustomName") ? name + " - " + stack.func_179543_a("SpawnerTag").func_74775_l("SpawnData").func_74779_i("CustomName") : name + " - " + I18n.func_74838_a((String)("entity." + mobName + ".name"));
        }
        return name;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te;
        if (!world.field_72995_K && player instanceof EntityPlayerMP && player.func_189808_dh() && !player.func_70093_af() && (te = world.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
            ItemSpawnerEditor.displayGui((EntityPlayerMP)player, pos);
            ItemSpawnerEditor.saveSpawnerToItem(player.func_184586_b(hand), (TileEntityMobSpawner)te);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState spawnerState;
        ItemStack stack;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if ((stack = player.func_184586_b(hand)).func_77942_o() && stack.func_77978_p().func_150297_b("SpawnerTag", 10) && !world.field_72995_K && player instanceof EntityPlayerMP && player.func_189808_dh() && player.func_175151_a(pos, facing, stack) && world.func_190527_a(Blocks.field_150474_ac, pos, false, facing, null) && world.func_180501_a(pos, spawnerState = Blocks.field_150474_ac.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand), 11)) {
            spawnerState = world.func_180495_p(pos);
            SoundType soundtype = spawnerState.func_177230_c().getSoundType(spawnerState, world, pos, (Entity)player);
            String soundName = soundtype.func_185841_e().getRegistryName().toString();
            float volume = (soundtype.func_185843_a() + 1.0f) / 2.0f;
            float pitch = soundtype.func_185847_b() * 0.8f;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketCustomSound(soundName, SoundCategory.BLOCKS, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, volume, pitch));
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityMobSpawner) {
                NBTTagCompound spawnerTag = te.func_189515_b(new NBTTagCompound());
                spawnerTag.func_179237_a(stack.func_179543_a("SpawnerTag"));
                te.func_145839_a(spawnerTag);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static void displayGui(EntityPlayerMP player, BlockPos pos) {
        player.openGui((Object)MapGadgetsMod.instance, MapGadgetsMod.GUI_SPAWNER_EDITOR, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void saveSpawnerToItem(ItemStack stack, TileEntityMobSpawner spawner) {
        NBTTagCompound spawnerTag = spawner.func_189515_b(new NBTTagCompound());
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        spawnerTag.func_82580_o("x");
        spawnerTag.func_82580_o("y");
        spawnerTag.func_82580_o("z");
        spawnerTag.func_82580_o("id");
        stack.func_77978_p().func_74782_a("SpawnerTag", (NBTBase)spawnerTag);
    }

    public static ItemStack getHeldSpawnerEditor(EntityPlayer player) {
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == INSTANCE) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        if (player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() == INSTANCE) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        return ItemStack.field_190927_a;
    }
}

