/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.items;

import com.tmtravlr.mapgadgets.ConfigLoader;
import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.items.ItemInteractor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNBTChecker
extends ItemInteractor {
    public static final Item INSTANCE = (Item)new ItemNBTChecker().func_77625_d(1).func_77637_a(MapGadgetsMod.creativeTab).func_77655_b("nbt_checker").setRegistryName("mapgadgets", "nbt_checker");

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && player.func_189808_dh() && hand == EnumHand.MAIN_HAND) {
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tag = te.func_189515_b(tag);
                this.copyAndSaveNBTString(tag, player);
                return EnumActionResult.SUCCESS;
            }
            TextComponentTranslation message = new TextComponentTranslation("item.nbt_checker.message.noBlock", new Object[]{"" + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p()});
            message.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)message);
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && !player.field_70170_p.field_72995_K && player.func_189808_dh()) {
            ItemStack heldItem = player.func_184592_cb();
            if (!heldItem.func_190926_b()) {
                this.copyAndSaveNBTString(heldItem.func_77978_p(), player);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
            }
            TextComponentTranslation message = new TextComponentTranslation("item.nbt_checker.message.noItem", new Object[0]);
            message.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)message);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    public void interact(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag = entity.func_189511_e(tag);
            this.copyAndSaveNBTString(tag, player);
        }
    }

    private void copyAndSaveNBTString(NBTTagCompound tag, EntityPlayer player) {
        String nbtString = tag == null ? "{}" : tag.toString();
        try {
            StringSelection selection = new StringSelection(nbtString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            File nbtOutput = new File(ConfigLoader.configFolder, "NBTOutput.txt");
            clipboard.setContents(selection, selection);
            PrintStream writeStream = new PrintStream(nbtOutput);
            writeStream.println(nbtString);
            writeStream.close();
            player.func_145747_a((ITextComponent)new TextComponentTranslation("item.nbt_checker.message.savednbt", new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            TextComponentTranslation message = new TextComponentTranslation("item.nbt_checker.message.failed", new Object[]{e.getMessage()});
            message.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)message);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_189808_dh()) {
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line1"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line2"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line3"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line4"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line5"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line6"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line7"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line8"));
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)"item.nbt_checker.info.line9"));
        }
    }
}

