/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.item;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.gui.GuiCheckbox;
import com.tmtravlr.mapgadgets.gui.item.GuiItemEditor;
import com.tmtravlr.mapgadgets.gui.item.TabItemEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringJoiner;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class TabItemEditorStats
extends TabItemEditor
implements GuiPageButtonList.GuiResponder {
    private static final ResourceLocation STATS_EDITOR_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/item_editor/stats_editor.png");
    private static final int TEXT_HIDE_FLAGS = 0;
    private static final int TEXT_COLOR = 1;
    private static final int TEXT_CAN_DESTROY = 2;
    private static final int TEXT_CAN_PLACE = 3;
    private static final int CHECKBOX_UNBREAKABLE = 4;
    private static final int CHECKBOX_COLOR = 5;
    private GuiTextField hideFlags;
    private GuiTextField canDestroy;
    private GuiTextField canPlaceOn;
    private GuiTextField color;
    private GuiCheckbox unbreakableCheckbox;
    private GuiCheckbox colorCheckbox;
    private float sliderRed = 0.0f;
    private float sliderGreen = 0.0f;
    private float sliderBlue = 0.0f;
    private boolean wasClicking;
    private boolean slidingRed;
    private boolean slidingGreen;
    private boolean slidingBlue;

    public TabItemEditorStats(GuiItemEditor itemEditor) {
        super(itemEditor);
    }

    @Override
    public void initGui() {
        int i;
        StringJoiner joiner;
        NBTTagList tagList;
        int guiX = (this.itemEditor.field_146294_l - this.itemEditor.getXSize()) / 2;
        int guiY = (this.itemEditor.field_146295_m - this.itemEditor.getYSize()) / 2;
        ItemStack stack = this.itemEditor.itemSlot.func_75211_c();
        String oldText = this.hideFlags != null ? this.hideFlags.func_146179_b() : (stack.func_77942_o() ? String.valueOf(stack.func_77978_p().func_74762_e("HideFlags")) : "0");
        this.hideFlags = new GuiTextField(0, this.itemEditor.getFontRenderer(), guiX + 16, guiY + 60, 18, 10);
        this.hideFlags.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.hideFlags.func_175205_a(text -> text.matches("^$|\\d+"));
        this.hideFlags.func_146193_g(-1);
        this.hideFlags.func_146204_h(-1);
        this.hideFlags.func_146185_a(false);
        this.hideFlags.func_146203_f(2);
        this.hideFlags.func_146180_a(oldText);
        oldText = this.color != null ? this.color.func_146179_b() : (stack.func_77942_o() ? String.valueOf(stack.func_190925_c("display").func_74762_e("color")) : "0");
        this.color = new GuiTextField(1, this.itemEditor.getFontRenderer(), guiX + 106, guiY + 67, 54, 10);
        this.color.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.color.func_175205_a(text -> text.matches("(0x|#)?[a-fA-F\\d]*"));
        this.color.func_146193_g(-1);
        this.color.func_146204_h(-1);
        this.color.func_146185_a(false);
        this.color.func_146203_f(8);
        this.color.func_146180_a(oldText);
        if (this.canDestroy != null) {
            oldText = this.canDestroy.func_146179_b();
        } else {
            oldText = "";
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CanDestroy", 9)) {
                tagList = stack.func_77978_p().func_150295_c("CanDestroy", 8);
                joiner = new StringJoiner(",");
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    joiner.add(tagList.func_150307_f(i));
                }
                oldText = joiner.toString();
            }
        }
        this.canDestroy = new GuiTextField(2, this.itemEditor.getFontRenderer(), guiX + 16, guiY + 88, 144, 10);
        this.canDestroy.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.canDestroy.func_146193_g(-1);
        this.canDestroy.func_146204_h(-1);
        this.canDestroy.func_146185_a(false);
        this.canDestroy.func_146203_f(10000);
        this.canDestroy.func_146180_a(oldText);
        if (this.canPlaceOn != null) {
            oldText = this.canPlaceOn.func_146179_b();
        } else {
            oldText = "";
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CanPlaceOn", 9)) {
                tagList = stack.func_77978_p().func_150295_c("CanPlaceOn", 8);
                joiner = new StringJoiner(",");
                for (i = 0; i < tagList.func_74745_c(); ++i) {
                    joiner.add(tagList.func_150307_f(i));
                }
                oldText = joiner.toString();
            }
        }
        this.canPlaceOn = new GuiTextField(3, this.itemEditor.getFontRenderer(), guiX + 16, guiY + 116, 144, 10);
        this.canPlaceOn.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.canPlaceOn.func_146193_g(-1);
        this.canPlaceOn.func_146204_h(-1);
        this.canPlaceOn.func_146185_a(false);
        this.canPlaceOn.func_146203_f(10000);
        this.canPlaceOn.func_146180_a(oldText);
        boolean wasChecked = this.unbreakableCheckbox != null ? this.unbreakableCheckbox.checked : (stack.func_77942_o() ? stack.func_77978_p().func_74767_n("Unbreakable") : false);
        this.unbreakableCheckbox = this.itemEditor.func_189646_b(new GuiCheckbox(4, guiX + 14, guiY + 31, 176, 14, STATS_EDITOR_GUI_TEXTURE));
        this.unbreakableCheckbox.checked = wasChecked;
        wasChecked = this.colorCheckbox != null ? this.colorCheckbox.checked : (stack.func_77942_o() ? stack.func_190925_c("display").func_150297_b("color", 3) : false);
        this.colorCheckbox = this.itemEditor.func_189646_b(new GuiCheckbox(5, guiX + 103, guiY + 31, 176, 14, STATS_EDITOR_GUI_TEXTURE));
        this.colorCheckbox.checked = wasChecked;
    }

    @Override
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.itemEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.item_editor.unbreakable", (Object[])new Object[0]), 29, 33, 3416887);
        this.itemEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.item_editor.hasColor", (Object[])new Object[0]), 118, 33, 3416887);
        this.itemEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.item_editor.hideFlags", (Object[])new Object[0]), 14, 47, 3416887);
        this.itemEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"item.canBreak", (Object[])new Object[0]), 14, 75, 3416887);
        this.itemEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"item.canPlace", (Object[])new Object[0]), 14, 103, 3416887);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.itemEditor.field_146297_k.func_110434_K().func_110577_a(STATS_EDITOR_GUI_TEXTURE);
        int guiX = (this.itemEditor.field_146294_l - this.itemEditor.getXSize()) / 2;
        int guiY = (this.itemEditor.field_146295_m - this.itemEditor.getYSize()) / 2;
        this.itemEditor.func_73729_b(guiX, guiY, 0, 0, this.itemEditor.getXSize(), this.itemEditor.getYSize());
        int sliderX = this.itemEditor.getGuiLeft() + 96;
        int sliderY = this.itemEditor.getGuiTop() + 43;
        this.itemEditor.func_175174_a((float)sliderX + (this.needsScrollBars() ? 70.0f * this.sliderRed : 0.0f), sliderY, 196 + (this.needsScrollBars() ? 0 : 5), 14, 5, 6);
        this.itemEditor.func_175174_a((float)sliderX + (this.needsScrollBars() ? 70.0f * this.sliderGreen : 0.0f), sliderY + 6, 196 + (this.needsScrollBars() ? 0 : 5), 14, 5, 6);
        this.itemEditor.func_175174_a((float)sliderX + (this.needsScrollBars() ? 70.0f * this.sliderBlue : 0.0f), sliderY + 12, 196 + (this.needsScrollBars() ? 0 : 5), 14, 5, 6);
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            this.itemEditor.func_73729_b(guiX + 14, guiY + 57, 234, 0, 22, 14);
            this.itemEditor.func_73729_b(guiX + 14, guiY + 85, 0, 215, 148, 14);
            this.itemEditor.func_73729_b(guiX + 14, guiY + 113, 0, 215, 148, 14);
            if (this.colorCheckbox.checked) {
                this.itemEditor.func_73729_b(guiX + 104, guiY + 64, 176, 0, 58, 14);
            }
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        if (Mouse.isButtonDown((int)0)) {
            int blue;
            int green;
            int red;
            int color;
            String colorString;
            boolean mouseDown = Mouse.isButtonDown((int)0);
            int sliderX = this.itemEditor.getGuiLeft() + 98;
            int sliderY = this.itemEditor.getGuiTop() + 43;
            int scrollWidth = 70;
            int scrollHeight = 6;
            if (!this.wasClicking && mouseX >= sliderX && mouseX < sliderX + scrollWidth && mouseY >= sliderY && mouseY < sliderY + scrollHeight) {
                this.slidingRed = this.needsScrollBars();
            }
            if (!this.wasClicking && mouseX >= sliderX && mouseX < sliderX + scrollWidth && mouseY >= sliderY + 6 && mouseY < sliderY + 6 + scrollHeight) {
                this.slidingGreen = this.needsScrollBars();
            }
            if (!this.wasClicking && mouseX >= sliderX && mouseX < sliderX + scrollWidth && mouseY >= sliderY + 12 && mouseY < sliderY + 12 + scrollHeight) {
                this.slidingBlue = this.needsScrollBars();
            }
            this.wasClicking = true;
            if (this.slidingRed) {
                this.sliderRed = (float)(mouseX - sliderX) / (float)scrollWidth;
                this.sliderRed = MathHelper.func_76131_a((float)this.sliderRed, (float)0.0f, (float)1.0f);
            }
            if (this.slidingGreen) {
                this.sliderGreen = (float)(mouseX - sliderX) / (float)scrollWidth;
                this.sliderGreen = MathHelper.func_76131_a((float)this.sliderGreen, (float)0.0f, (float)1.0f);
            }
            if (this.slidingBlue) {
                this.sliderBlue = (float)(mouseX - sliderX) / (float)scrollWidth;
                this.sliderBlue = MathHelper.func_76131_a((float)this.sliderBlue, (float)0.0f, (float)1.0f);
            }
            if ((this.slidingRed || this.slidingGreen || this.slidingBlue) && !(colorString = String.valueOf(color = (red = (int)(255.0f * this.sliderRed)) << 16 | (green = (int)(255.0f * this.sliderGreen)) << 8 | (blue = (int)(255.0f * this.sliderBlue)))).equals(this.color.func_146179_b())) {
                this.color.func_146180_a(colorString);
                this.func_175319_a(1, colorString);
            }
        } else {
            this.slidingBlue = false;
            this.slidingGreen = false;
            this.slidingRed = false;
            this.wasClicking = false;
        }
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            GlStateManager.func_179140_f();
            this.hideFlags.func_146194_f();
            this.canDestroy.func_146194_f();
            this.canPlaceOn.func_146194_f();
            if (this.colorCheckbox.checked) {
                this.color.func_146194_f();
            }
        }
    }

    @Override
    public void renderHoveredToolTip(int mouseX, int mouseY) {
        int guiX = this.itemEditor.getGuiLeft();
        int guiY = this.itemEditor.getGuiTop();
        if (mouseX > guiX + 5 && mouseX < guiX + 12) {
            ArrayList<String> hoverInfo;
            if (mouseY > guiY + 59 && mouseY < guiY + 69) {
                hoverInfo = new ArrayList<String>();
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.hideFlags.info1", (Object[])new Object[0]));
                hoverInfo.add("");
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.hideFlags.info2", (Object[])new Object[0]));
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.hideFlags.info3", (Object[])new Object[0]));
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.hideFlags.info4", (Object[])new Object[0]));
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.hideFlags.info5", (Object[])new Object[0]));
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.hideFlags.info6", (Object[])new Object[0]));
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.hideFlags.info7", (Object[])new Object[0]));
                hoverInfo.add("");
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.hideFlags.info8", (Object[])new Object[0]));
                this.itemEditor.func_146283_a(hoverInfo, mouseX, mouseY);
            }
            if (mouseY > guiY + 87 && mouseY < guiY + 97 || mouseY > guiY + 115 && mouseY < guiY + 125) {
                hoverInfo = new ArrayList();
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.canPlaceBreak.info1", (Object[])new Object[0]));
                hoverInfo.add("");
                hoverInfo.add(I18n.func_135052_a((String)"gui.item_editor.canPlaceBreak.info2", (Object[])new Object[0]));
                this.itemEditor.func_146283_a(hoverInfo, mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            if (this.hideFlags.func_146201_a(typedChar, keyCode)) {
                return true;
            }
            if (this.canDestroy.func_146201_a(typedChar, keyCode)) {
                return true;
            }
            if (this.canPlaceOn.func_146201_a(typedChar, keyCode)) {
                return true;
            }
            if (this.colorCheckbox.checked && this.color.func_146201_a(typedChar, keyCode)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            this.hideFlags.func_146192_a(mouseX, mouseY, mouseButton);
            this.canDestroy.func_146192_a(mouseX, mouseY, mouseButton);
            this.canPlaceOn.func_146192_a(mouseX, mouseY, mouseButton);
            if (this.colorCheckbox.checked) {
                this.color.func_146192_a(mouseX, mouseY, mouseButton);
            }
        }
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        ItemStack stack = this.itemEditor.itemSlot.func_75211_c();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (button.field_146127_k == 5) {
            this.colorCheckbox.toggleCheckbox();
            if (this.colorCheckbox.checked) {
                this.func_175319_a(1, this.color.func_146179_b());
            } else {
                stack.func_190925_c("display").func_82580_o("color");
                this.itemEditor.sendItemChanges(stack);
            }
        } else if (button.field_146127_k == 4) {
            this.unbreakableCheckbox.toggleCheckbox();
            if (this.unbreakableCheckbox.checked) {
                stack.func_77978_p().func_74757_a("Unbreakable", this.unbreakableCheckbox.checked);
            } else {
                stack.func_77978_p().func_82580_o("Unbreakable");
            }
            this.itemEditor.sendItemChanges(stack);
        }
    }

    @Override
    public void onStackChanged() {
        int i;
        StringJoiner joiner;
        NBTTagList tagList;
        ItemStack stack = this.itemEditor.itemSlot.func_75211_c();
        this.hideFlags.func_146180_a(stack.func_77942_o() ? String.valueOf(stack.func_77978_p().func_74762_e("HideFlags")) : "0");
        this.color.func_146180_a(stack.func_77942_o() ? String.valueOf(stack.func_190925_c("display").func_74762_e("color")) : "0");
        this.unbreakableCheckbox.checked = stack.func_77942_o() ? stack.func_77978_p().func_74767_n("Unbreakable") : false;
        this.colorCheckbox.checked = stack.func_77942_o() ? stack.func_190925_c("display").func_150297_b("color", 3) : false;
        String text = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CanDestroy", 9)) {
            tagList = stack.func_77978_p().func_150295_c("CanDestroy", 8);
            joiner = new StringJoiner(",");
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                joiner.add(tagList.func_150307_f(i));
            }
            text = joiner.toString();
        }
        this.canDestroy.func_146180_a(text);
        text = "";
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CanPlaceOn", 9)) {
            tagList = stack.func_77978_p().func_150295_c("CanPlaceOn", 8);
            joiner = new StringJoiner(",");
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                joiner.add(tagList.func_150307_f(i));
            }
            text = joiner.toString();
        }
        this.canPlaceOn.func_146180_a(text);
        int color = stack.func_190925_c("display").func_74762_e("color");
        int red = color >> 16;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        this.sliderRed = (float)red / 255.0f;
        this.sliderGreen = (float)green / 255.0f;
        this.sliderBlue = (float)blue / 255.0f;
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        ItemStack stack = this.itemEditor.itemSlot.func_75211_c();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (id == 0) {
            int hideFlags = 0;
            if (!value.isEmpty()) {
                try {
                    hideFlags = Integer.valueOf(value);
                }
                catch (NumberFormatException e) {
                    MapGadgetsMod.logger.warn("Caught exception while trying to parse hide flags integer: ", (Throwable)e);
                }
            }
            if (hideFlags > 0) {
                stack.func_77978_p().func_74768_a("HideFlags", hideFlags);
            } else {
                stack.func_77978_p().func_82580_o("HideFlags");
            }
        } else if (this.colorCheckbox.checked && id == 1) {
            int color = 0;
            if (!value.isEmpty()) {
                try {
                    if (value.startsWith("0x")) {
                        if ((value = value.substring(2)).isEmpty()) {
                            value = "0";
                        }
                        color = Integer.parseInt(value, 16);
                    } else if (value.startsWith("#")) {
                        if ((value = value.substring(1)).isEmpty()) {
                            value = "0";
                        }
                        color = Integer.parseInt(value, 16);
                    } else {
                        color = Integer.valueOf(value);
                    }
                }
                catch (NumberFormatException e) {
                    MapGadgetsMod.logger.warn("Caught exception while trying to parse color integer: ", (Throwable)e);
                }
            }
            color = Math.min(color, 0xFFFFFF);
            stack.func_190925_c("display").func_74768_a("color", color);
            int red = color >> 16;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            this.sliderRed = (float)red / 255.0f;
            this.sliderGreen = (float)green / 255.0f;
            this.sliderBlue = (float)blue / 255.0f;
        } else if (id == 2) {
            if (value.isEmpty()) {
                stack.func_77978_p().func_82580_o("CanDestroy");
            } else {
                String[] canDestroyValues = value.split(",");
                NBTTagList canDestroy = new NBTTagList();
                for (String canDestroyValue : canDestroyValues) {
                    canDestroy.func_74742_a((NBTBase)new NBTTagString(canDestroyValue.trim()));
                }
                stack.func_77978_p().func_74782_a("CanDestroy", (NBTBase)canDestroy);
            }
        } else if (id == 3) {
            if (value.isEmpty()) {
                stack.func_77978_p().func_82580_o("CanPlaceOn");
            } else {
                String[] canPlaceOnValues = value.split(",");
                NBTTagList canPlaceOn = new NBTTagList();
                for (String canPlaceOnValue : canPlaceOnValues) {
                    canPlaceOn.func_74742_a((NBTBase)new NBTTagString(canPlaceOnValue.trim()));
                }
                stack.func_77978_p().func_74782_a("CanPlaceOn", (NBTBase)canPlaceOn);
            }
        }
        this.itemEditor.sendItemChanges(stack);
    }

    private boolean needsScrollBars() {
        return !this.itemEditor.itemSlot.func_75211_c().func_190926_b() && this.colorCheckbox.checked;
    }
}

