/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.item;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.gui.CommonGuiStuff;
import com.tmtravlr.mapgadgets.gui.item.GuiItemEditor;
import com.tmtravlr.mapgadgets.gui.item.TabItemEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;

public class TabItemEditorEnchantments
extends TabItemEditor {
    public static final ResourceLocation ENCHANTMENT_EDITOR_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/item_editor/enchantment_editor.png");
    private final List<EnchantmentSelection> selections = new ArrayList<EnchantmentSelection>();
    private final Map<Enchantment, EnchantmentSelection> selectionMap = new HashMap<Enchantment, EnchantmentSelection>();
    public float currentScroll;
    public int scrollIndex;
    public boolean isScrolling;
    public boolean wasClicking;
    public boolean hasInitialized = false;

    public TabItemEditorEnchantments(GuiItemEditor itemEditor) {
        super(itemEditor);
    }

    @Override
    public void initGui() {
        if (!this.hasInitialized) {
            this.hasInitialized = true;
            Enchantment.field_185264_b.forEach(enchantment -> {
                EnchantmentSelection selection = new EnchantmentSelection((Enchantment)enchantment, 0);
                this.selectionMap.put((Enchantment)enchantment, selection);
                this.selections.add(selection);
            });
            this.selections.sort((enchantment1, enchantment2) -> this.translateEnchantmentName(((EnchantmentSelection)enchantment1).enchantment).compareTo(this.translateEnchantmentName(((EnchantmentSelection)enchantment2).enchantment)));
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.itemEditor.field_146297_k.func_110434_K().func_110577_a(ENCHANTMENT_EDITOR_GUI_TEXTURE);
        int guiX = (this.itemEditor.field_146294_l - this.itemEditor.getXSize()) / 2;
        int guiY = (this.itemEditor.field_146295_m - this.itemEditor.getYSize()) / 2;
        this.itemEditor.func_73729_b(guiX, guiY, 0, 0, this.itemEditor.getXSize(), this.itemEditor.getYSize());
        int scrollX = this.itemEditor.getGuiLeft() + 158;
        int scrollY = this.itemEditor.getGuiTop() + 36;
        this.itemEditor.func_175174_a(scrollX, (float)scrollY + 71.0f * this.currentScroll, 176 + (this.needsScrollBar() ? 0 : 12), 0, 12, 15);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        int scrollX = this.itemEditor.getGuiLeft() + 158;
        int scrollY = this.itemEditor.getGuiTop() + 36;
        int scrollWidth = 12;
        int scrollHeight = 86;
        if (!this.wasClicking && mouseDown && mouseX >= scrollX && mouseX < scrollX + scrollWidth && mouseY >= scrollY && mouseY < scrollY + scrollHeight) {
            this.isScrolling = this.needsScrollBar();
        }
        if (!mouseDown) {
            this.isScrolling = false;
        }
        this.wasClicking = mouseDown;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - scrollY) - 7.5f) / ((float)scrollHeight - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollIndex = Math.round((float)(this.selections.size() - 6) * this.currentScroll);
        }
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            for (int i = 0; i < 6; ++i) {
                if (i + this.scrollIndex >= this.selections.size()) continue;
                this.selections.get(i + this.scrollIndex).onDrawScreen(mouseX, mouseY, this.itemEditor.getGuiLeft() + 10, this.itemEditor.getGuiTop() + 37 + i * 14, partialTicks);
            }
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBar()) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.scrollIndex = MathHelper.func_76125_a((int)(this.scrollIndex - i), (int)0, (int)(this.selections.size() - 6));
            this.currentScroll = (float)this.scrollIndex / (float)(this.selections.size() - 6);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            for (int i = 0; i < this.selections.size(); ++i) {
                if (!this.isSelectionVisible(i) || !this.selections.get(i).onKeyTyped(typedChar, keyCode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            for (int i = 0; i < this.selections.size(); ++i) {
                if (this.isSelectionVisible(i)) {
                    this.selections.get(i).onMouseClicked(mouseX, mouseY, mouseButton);
                    continue;
                }
                this.selections.get(i).onMouseClickedNotVisible();
            }
        }
    }

    @Override
    public void onStackChanged() {
        this.setEnchantmentsFromStack(this.itemEditor.itemSlot.func_75211_c());
        this.currentScroll = 0.0f;
        this.scrollIndex = 0;
    }

    private void setEnchantmentAmount(Enchantment enchantment, int amount) {
        ItemStack stack = this.itemEditor.itemSlot.func_75211_c();
        if (amount > 0) {
            if (stack.func_77973_b() == Items.field_151122_aG) {
                ItemStack tempStack = new ItemStack(Items.field_151134_bR);
                tempStack.func_77982_d(stack.func_77978_p());
                stack = tempStack;
                this.itemEditor.itemSlot.func_75215_d(stack);
            }
            Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchMap.put(enchantment, amount);
            if (stack.func_77942_o() && stack.func_77973_b() == Items.field_151134_bR) {
                stack.func_77978_p().func_82580_o("StoredEnchantments");
            }
            EnchantmentHelper.func_82782_a((Map)enchMap, (ItemStack)stack);
        } else {
            Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
            enchMap.remove(enchantment);
            if (stack.func_77942_o() && stack.func_77973_b() == Items.field_151134_bR) {
                stack.func_77978_p().func_82580_o("StoredEnchantments");
            }
            EnchantmentHelper.func_82782_a((Map)enchMap, (ItemStack)stack);
            if (enchMap.isEmpty() && stack.func_77973_b() == Items.field_151134_bR) {
                ItemStack tempStack = new ItemStack(Items.field_151122_aG);
                tempStack.func_77982_d(stack.func_77978_p());
                stack = tempStack;
                this.itemEditor.itemSlot.func_75215_d(stack);
            }
        }
        this.itemEditor.sendItemChanges(stack);
    }

    private boolean isSelectionVisible(int id) {
        return id >= this.scrollIndex && id < this.scrollIndex + 6;
    }

    private boolean needsScrollBar() {
        return !this.itemEditor.itemSlot.func_75211_c().func_190926_b() && this.selections.size() > 6;
    }

    private String translateEnchantmentName(Enchantment enchantment) {
        String displayName = I18n.func_135052_a((String)enchantment.func_77320_a(), (Object[])new Object[0]);
        if (enchantment.func_190936_d()) {
            displayName = TextFormatting.RED + displayName;
        }
        return displayName;
    }

    private void setEnchantmentsFromStack(ItemStack stack) {
        this.selections.forEach(selection -> ((EnchantmentSelection)selection).setAmount(0));
        Map enchMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Enchantment enchantment : enchMap.keySet()) {
            EnchantmentSelection selection2 = this.selectionMap.get(enchantment);
            if (selection2 == null) continue;
            selection2.setAmount((Integer)enchMap.get(enchantment));
        }
    }

    private class EnchantmentSelection {
        private GuiTextField amountText;
        private Enchantment enchantment;
        private boolean enchantmentEnabled;
        private int y = 0;

        private EnchantmentSelection(Enchantment enchantment, int amount) {
            this.enchantment = enchantment;
            this.amountText = new GuiTextField(0, TabItemEditorEnchantments.this.itemEditor.getFontRenderer(), 0, 0, 26, 10){

                public void func_190516_a(int id, String text) {
                    EnchantmentSelection.this.onAmountChanged(text);
                }

                public void func_146195_b(boolean isFocused) {
                    super.func_146195_b(isFocused);
                    if (!isFocused) {
                        this.func_146199_i(this.func_146198_h());
                    }
                }
            };
            this.amountText.func_146203_f(4);
            this.amountText.func_175205_a(text -> text.matches("^$|\\d+"));
            this.amountText.func_146193_g(-1);
            this.amountText.func_146204_h(-1);
            this.amountText.func_146185_a(false);
            this.setAmount(amount);
        }

        private void setAmount(int amount) {
            this.amountText.func_146180_a(String.valueOf(amount > 9999 ? 9999 : amount));
            this.enchantmentEnabled = amount > 0;
        }

        private void onMouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amountText.func_146192_a(mouseX, mouseY, mouseButton);
            if (mouseX > TabItemEditorEnchantments.this.itemEditor.getGuiLeft() + 10 && mouseX < TabItemEditorEnchantments.this.itemEditor.getGuiLeft() + 125 && mouseY > this.y && mouseY < this.y + 14) {
                this.amountText.func_146195_b(true);
                this.amountText.func_146202_e();
                this.amountText.func_146199_i(0);
            }
        }

        private void onMouseClickedNotVisible() {
            if (this.amountText.func_146206_l()) {
                this.amountText.func_146195_b(false);
            }
        }

        private boolean onKeyTyped(char typedChar, int keyCode) {
            return this.amountText.func_146201_a(typedChar, keyCode);
        }

        private void onDrawScreen(int mouseX, int mouseY, int x, int y, float partialTicks) {
            this.amountText.field_146210_g = y + 3;
            this.amountText.field_146209_f = TabItemEditorEnchantments.this.itemEditor.getGuiLeft() + 127;
            this.y = y;
            GlStateManager.func_179140_f();
            if (this.enchantmentEnabled) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TabItemEditorEnchantments.this.itemEditor.field_146297_k.func_110434_K().func_110577_a(ENCHANTMENT_EDITOR_GUI_TEXTURE);
                TabItemEditorEnchantments.this.itemEditor.func_73729_b(x, y, 0, 215, 144, 14);
            }
            this.amountText.func_146193_g(this.enchantmentEnabled ? 0xFFFFFF : 0x888888);
            this.amountText.func_146194_f();
            String displayEnchantmentName = CommonGuiStuff.trimWithDots(TabItemEditorEnchantments.this.itemEditor.getFontRenderer(), TabItemEditorEnchantments.this.translateEnchantmentName(this.enchantment), 110);
            TabItemEditorEnchantments.this.itemEditor.getFontRenderer().func_175063_a(displayEnchantmentName, (float)(x + 2), (float)(y + 3), this.enchantmentEnabled ? 0xFFFFFF : 0x888888);
        }

        private void onAmountChanged(String newText) {
            int amount = 0;
            if (!newText.isEmpty()) {
                try {
                    amount = Integer.valueOf(newText);
                }
                catch (NumberFormatException e) {
                    MapGadgetsMod.logger.warn("Tried to parse invalid enchantment amount:", (Throwable)e);
                }
            }
            this.enchantmentEnabled = amount > 0;
            TabItemEditorEnchantments.this.setEnchantmentAmount(this.enchantment, amount);
        }
    }
}

