/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.gui.CommonGuiStuff;
import com.tmtravlr.mapgadgets.gui.item.GuiItemEditor;
import com.tmtravlr.mapgadgets.gui.item.TabItemEditor;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class TabItemEditorAttributes
extends TabItemEditor {
    private static final ResourceLocation ATTRIBUTE_MODIFIER_EDITOR_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/item_editor/attribute_modifier_editor.png");
    private static final UUID TEMP_UUID = UUID.fromString("AA3F56D3-543C-4FBC-4495-B90233D45C9");
    private static final String[] DEFAULT_SELECTION_NAMES = new String[]{"generic.attackDamage", "generic.attackSpeed", "generic.armor", "generic.armorToughness", "generic.maxHealth", "generic.movementSpeed", "generic.knockbackResistance", "generic.reachDistance", "generic.luck", "generic.followRange", "horse.jumpStrength", "zombie.spawnReinforcements", "generic.flyingSpeed"};
    private final List<AttributeModifierSelection> selections = new ArrayList<AttributeModifierSelection>();
    private GuiTextField addAttribute;
    public float currentScroll;
    public int scrollIndex;
    public boolean isScrolling;
    public boolean wasClicking;
    public boolean hasInitialized = false;

    public TabItemEditorAttributes(GuiItemEditor itemEditor) {
        super(itemEditor);
    }

    @Override
    public void initGui() {
        if (!this.hasInitialized) {
            this.hasInitialized = true;
            this.setAttributeModifiersFromStack(this.itemEditor.itemSlot.func_75211_c());
        }
        String oldText = "";
        if (this.addAttribute != null) {
            oldText = this.addAttribute.func_146179_b();
        }
        this.addAttribute = new GuiTextField(-1, this.itemEditor.getFontRenderer(), this.itemEditor.getGuiLeft() + 19, -100, 136, 10);
        this.addAttribute.func_146193_g(-1);
        this.addAttribute.func_146204_h(-1);
        this.addAttribute.func_146185_a(false);
        this.addAttribute.func_146203_f(45);
        this.addAttribute.func_146180_a(oldText);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.itemEditor.field_146297_k.func_110434_K().func_110577_a(ATTRIBUTE_MODIFIER_EDITOR_GUI_TEXTURE);
        int guiX = (this.itemEditor.field_146294_l - this.itemEditor.getXSize()) / 2;
        int guiY = (this.itemEditor.field_146295_m - this.itemEditor.getYSize()) / 2;
        this.itemEditor.func_73729_b(guiX, guiY, 0, 0, this.itemEditor.getXSize(), this.itemEditor.getYSize());
        int scrollX = this.itemEditor.getGuiLeft() + 160;
        int scrollY = this.itemEditor.getGuiTop() + 36;
        this.itemEditor.func_175174_a(scrollX, (float)scrollY + 71.0f * this.currentScroll, 176 + (this.needsScrollBar() ? 0 : 12), 0, 12, 15);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        boolean mouseDown = Mouse.isButtonDown((int)0);
        int scrollX = this.itemEditor.getGuiLeft() + 160;
        int scrollY = this.itemEditor.getGuiTop() + 36;
        int scrollWidth = 12;
        int scrollHeight = 86;
        if (!this.wasClicking && mouseDown && mouseX >= scrollX && mouseX < scrollX + scrollWidth && mouseY >= scrollY && mouseY < scrollY + scrollHeight) {
            this.isScrolling = this.needsScrollBar();
        }
        if (!mouseDown) {
            this.isScrolling = false;
        }
        this.wasClicking = mouseDown;
        if (this.isScrolling) {
            this.setCurrentScroll(((float)(mouseY - scrollY) - 7.5f) / ((float)scrollHeight - 15.0f));
        }
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            for (int i = 0; i < 6; ++i) {
                if (i + this.scrollIndex < this.selections.size()) {
                    this.selections.get(i + this.scrollIndex).onDrawScreen(mouseX, mouseY, this.itemEditor.getGuiLeft() + 6, this.itemEditor.getGuiTop() + 37 + i * 14, partialTicks);
                    continue;
                }
                if (i + this.scrollIndex != this.selections.size()) continue;
                this.addAttribute.field_146210_g = this.itemEditor.getGuiTop() + 39 + i * 14;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.itemEditor.field_146297_k.func_110434_K().func_110577_a(ATTRIBUTE_MODIFIER_EDITOR_GUI_TEXTURE);
                this.itemEditor.func_73729_b(this.addAttribute.field_146209_f - 13, this.addAttribute.field_146210_g - 2, 0, 229, 151, 14);
                this.addAttribute.func_146194_f();
            }
        }
    }

    @Override
    public void renderHoveredToolTip(int mouseX, int mouseY) {
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            for (int i = 0; i < 6; ++i) {
                if (i + this.scrollIndex >= this.selections.size()) continue;
                this.selections.get(i + this.scrollIndex).onRenderHoveredToolTip(mouseX, mouseY);
            }
            if (this.isSelectionVisible(this.selections.size()) && mouseX > this.itemEditor.getGuiLeft() + 6 && mouseX < this.itemEditor.getGuiLeft() + 19 && mouseY > this.addAttribute.field_146210_g && mouseY < this.addAttribute.field_146210_g + 14) {
                ArrayList<String> hoverInfo = new ArrayList<String>();
                hoverInfo.addAll(this.itemEditor.getFontRenderer().func_78271_c(I18n.func_135052_a((String)"gui.attribute.add.info1", (Object[])new Object[0]), 200));
                hoverInfo.add("");
                hoverInfo.addAll(this.itemEditor.getFontRenderer().func_78271_c(I18n.func_135052_a((String)"gui.attribute.add.info2", (Object[])new Object[0]), 200));
                hoverInfo.add("");
                hoverInfo.addAll(this.itemEditor.getFontRenderer().func_78271_c(I18n.func_135052_a((String)"gui.attribute.add.info3", (Object[])new Object[0]), 200));
                this.itemEditor.func_146283_a(hoverInfo, mouseX, mouseY);
            }
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBar()) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.setScrollIndex(MathHelper.func_76125_a((int)(this.scrollIndex - i), (int)0, (int)(this.selections.size() - 5)));
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            for (int i = 0; i < this.selections.size(); ++i) {
                if (!this.isSelectionVisible(i) || !this.selections.get(i).onKeyTyped(typedChar, keyCode)) continue;
                return true;
            }
            if (this.isSelectionVisible(this.selections.size())) {
                if (keyCode == 28 || keyCode == 156) {
                    this.selections.add(new AttributeModifierSelection(new AttributeModifier(TEMP_UUID, this.addAttribute.func_146179_b(), 0.0, 0)));
                    this.addAttribute.func_146180_a("");
                    this.addAttribute.func_146195_b(false);
                    this.setScrollIndex(this.scrollIndex + 1);
                } else if (this.addAttribute.func_146201_a(typedChar, keyCode)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.itemEditor.itemSlot.func_75211_c().func_190926_b()) {
            for (int i = 0; i < this.selections.size(); ++i) {
                if (this.isSelectionVisible(i)) {
                    this.selections.get(i).onMouseClicked(mouseX, mouseY, mouseButton);
                    continue;
                }
                this.selections.get(i).onMouseClickedNotVisible();
            }
            if (this.isSelectionVisible(this.selections.size())) {
                this.addAttribute.func_146192_a(mouseX, mouseY, mouseButton);
            } else if (this.addAttribute.func_146206_l()) {
                this.addAttribute.func_146195_b(false);
            }
        }
    }

    @Override
    public void onStackChanged() {
        this.setAttributeModifiersFromStack(this.itemEditor.itemSlot.func_75211_c());
        this.setScrollIndex(0);
    }

    private void setScrollIndex(int scrollIndex) {
        this.scrollIndex = scrollIndex;
        this.scrollIndex = MathHelper.func_76125_a((int)this.scrollIndex, (int)0, (int)(this.selections.size() - 5));
        this.currentScroll = (float)this.scrollIndex / (float)(this.selections.size() - 5);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
    }

    private void setCurrentScroll(float currentScroll) {
        this.currentScroll = currentScroll;
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        this.scrollIndex = Math.round((float)(this.selections.size() - 5) * this.currentScroll);
    }

    private boolean isSelectionVisible(int id) {
        return id >= this.scrollIndex && id < this.scrollIndex + 6;
    }

    private boolean needsScrollBar() {
        return !this.itemEditor.itemSlot.func_75211_c().func_190926_b() && this.selections.size() > 5;
    }

    private List<AttributeModifierSelection> getModifiers(ItemStack stack) {
        ArrayList<AttributeModifierSelection> modifiers = new ArrayList<AttributeModifierSelection>();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            Multimap stackModifiers = stack.func_111283_C(slot);
            stackModifiers.forEach((name, modifier) -> {
                AttributeModifier namedModifier = new AttributeModifier(modifier.func_111167_a(), name, modifier.func_111164_d(), modifier.func_111169_c());
                modifiers.add(new AttributeModifierSelection(namedModifier, slot));
            });
        }
        return modifiers;
    }

    private List<AttributeModifierSelection> getOriginalModifiers(ItemStack stack) {
        ItemStack noModifiersStack = stack.func_77946_l();
        if (noModifiersStack.func_77942_o()) {
            noModifiersStack.func_77978_p().func_82580_o("AttributeModifiers");
        }
        return this.getModifiers(noModifiersStack);
    }

    private void setAttributeModifiersFromStack(ItemStack stack) {
        this.selections.clear();
        List<AttributeModifierSelection> modifiers = this.getModifiers(stack);
        HashMultimap namedSelections = HashMultimap.create();
        modifiers.forEach(arg_0 -> TabItemEditorAttributes.lambda$setAttributeModifiersFromStack$1((Multimap)namedSelections, arg_0));
        for (String name : DEFAULT_SELECTION_NAMES) {
            if (namedSelections.containsKey((Object)name)) {
                Collection currentSelections = namedSelections.get((Object)name);
                currentSelections.forEach(selection -> this.selections.add((AttributeModifierSelection)selection));
                namedSelections.removeAll((Object)name);
                continue;
            }
            this.selections.add(new AttributeModifierSelection(new AttributeModifier(TEMP_UUID, name, 0.0, 0)));
        }
        namedSelections.keySet().forEach(arg_0 -> this.lambda$setAttributeModifiersFromStack$4((Multimap)namedSelections, arg_0));
    }

    private void updateAttributeModifiers() {
        ItemStack stack = this.itemEditor.itemSlot.func_75211_c();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        ArrayList<AttributeModifierSelection> selectionsToApply = new ArrayList<AttributeModifierSelection>();
        for (AttributeModifierSelection selection : this.selections) {
            if (selection.attributeModifier.func_111164_d() == 0.0) continue;
            selectionsToApply.add(selection);
        }
        if (selectionsToApply.isEmpty() || new HashSet<AttributeModifierSelection>(this.getOriginalModifiers(stack)).equals(new HashSet(selectionsToApply))) {
            tag.func_82580_o("AttributeModifiers");
        } else {
            NBTTagList modifiersTag = new NBTTagList();
            for (AttributeModifierSelection selection : selectionsToApply) {
                AttributeModifier modifierToApply = selection.attributeModifier;
                if (modifierToApply.func_111167_a() == TEMP_UUID) {
                    modifierToApply = new AttributeModifier(modifierToApply.func_111166_b(), modifierToApply.func_111164_d(), modifierToApply.func_111169_c());
                }
                NBTTagCompound modifierTag = new NBTTagCompound();
                modifierTag.func_74778_a("AttributeName", modifierToApply.func_111166_b());
                modifierTag.func_74778_a("Name", modifierToApply.func_111166_b());
                modifierTag.func_74768_a("Operation", modifierToApply.func_111169_c());
                modifierTag.func_74780_a("Amount", modifierToApply.func_111164_d());
                modifierTag.func_74778_a("Slot", selection.attributeSlot.func_188450_d());
                modifierTag.func_74772_a("UUIDLeast", modifierToApply.func_111167_a().getLeastSignificantBits());
                modifierTag.func_74772_a("UUIDMost", modifierToApply.func_111167_a().getMostSignificantBits());
                modifiersTag.func_74742_a((NBTBase)modifierTag);
            }
            tag.func_74782_a("AttributeModifiers", (NBTBase)modifiersTag);
        }
        this.itemEditor.sendItemChanges(stack);
    }

    private /* synthetic */ void lambda$setAttributeModifiersFromStack$4(Multimap namedSelections, String name) {
        namedSelections.get((Object)name).forEach(leftoverSelection -> this.selections.add((AttributeModifierSelection)leftoverSelection));
    }

    private static /* synthetic */ void lambda$setAttributeModifiersFromStack$1(Multimap namedSelections, AttributeModifierSelection selection) {
        namedSelections.put((Object)selection.attributeModifier.func_111166_b(), (Object)selection);
    }

    private class AttributeModifierSelection {
        private GuiTextField amountText;
        private AttributeModifier attributeModifier;
        private EntityEquipmentSlot attributeSlot;
        private boolean attributeModifierEnabled;
        private int y = 0;

        private AttributeModifierSelection(AttributeModifier attributeModifier) {
            this(attributeModifier, EntityEquipmentSlot.MAINHAND);
        }

        private AttributeModifierSelection(AttributeModifier attributeModifier, EntityEquipmentSlot slot) {
            this.attributeModifier = attributeModifier;
            this.attributeSlot = slot == null ? EntityEquipmentSlot.MAINHAND : slot;
            this.amountText = new GuiTextField(0, TabItemEditorAttributes.this.itemEditor.getFontRenderer(), 0, 0, 26, 10){

                public void func_190516_a(int id, String text) {
                    AttributeModifierSelection.this.onAmountChanged(text);
                }

                public void func_146195_b(boolean isFocused) {
                    super.func_146195_b(isFocused);
                    if (!isFocused) {
                        this.func_146199_i(this.func_146198_h());
                    }
                }
            };
            this.amountText.func_146203_f(7);
            this.amountText.func_175205_a(text -> text.matches("-?\\d*\\.?\\d?\\d?"));
            this.amountText.func_146193_g(-1);
            this.amountText.func_146204_h(-1);
            this.amountText.func_146185_a(false);
            this.setAmountText(attributeModifier.func_111164_d());
        }

        private void setAttributeModifier(AttributeModifier attributeModifier) {
            this.attributeModifier = attributeModifier;
            this.setAmountText(attributeModifier.func_111164_d());
        }

        private void setAmountText(double amount) {
            amount = MathHelper.func_151237_a((double)amount, (double)-9999.0, (double)9999.0);
            DecimalFormat format = new DecimalFormat("#.##");
            this.amountText.func_146180_a(format.format(amount));
            this.attributeModifierEnabled = amount != 0.0;
        }

        private void onMouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amountText.func_146192_a(mouseX, mouseY, mouseButton);
            if (mouseX > TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 10 && mouseX < TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 100 && mouseY > this.y && mouseY < this.y + 14) {
                this.amountText.func_146195_b(true);
                this.amountText.func_146202_e();
                this.amountText.func_146199_i(0);
            }
            if (mouseX > TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 128 && mouseX < TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 143 && mouseY > this.y && mouseY < this.y + 14) {
                int operation = this.attributeModifier.func_111169_c();
                operation = (operation + 1) % 3;
                this.setAttributeModifier(new AttributeModifier(this.attributeModifier.func_111167_a(), this.attributeModifier.func_111166_b(), this.attributeModifier.func_111164_d(), operation));
                TabItemEditorAttributes.this.itemEditor.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                TabItemEditorAttributes.this.updateAttributeModifiers();
            }
            if (mouseX > TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 143 && mouseX < TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 158 && mouseY > this.y && mouseY < this.y + 14) {
                switch (this.attributeSlot) {
                    case MAINHAND: {
                        this.attributeSlot = EntityEquipmentSlot.OFFHAND;
                        break;
                    }
                    case OFFHAND: {
                        this.attributeSlot = EntityEquipmentSlot.HEAD;
                        break;
                    }
                    case HEAD: {
                        this.attributeSlot = EntityEquipmentSlot.CHEST;
                        break;
                    }
                    case CHEST: {
                        this.attributeSlot = EntityEquipmentSlot.LEGS;
                        break;
                    }
                    case LEGS: {
                        this.attributeSlot = EntityEquipmentSlot.FEET;
                        break;
                    }
                    case FEET: {
                        this.attributeSlot = EntityEquipmentSlot.MAINHAND;
                    }
                }
                TabItemEditorAttributes.this.itemEditor.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                TabItemEditorAttributes.this.updateAttributeModifiers();
            }
        }

        private void onMouseClickedNotVisible() {
            if (this.amountText.func_146206_l()) {
                this.amountText.func_146195_b(false);
            }
        }

        private boolean onKeyTyped(char typedChar, int keyCode) {
            return this.amountText.func_146201_a(typedChar, keyCode);
        }

        private void onDrawScreen(int mouseX, int mouseY, int x, int y, float partialTicks) {
            this.amountText.field_146210_g = y + 3;
            this.amountText.field_146209_f = TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 102;
            this.y = y;
            GlStateManager.func_179140_f();
            if (this.attributeModifierEnabled) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TabItemEditorAttributes.this.itemEditor.field_146297_k.func_110434_K().func_110577_a(ATTRIBUTE_MODIFIER_EDITOR_GUI_TEXTURE);
                TabItemEditorAttributes.this.itemEditor.func_73729_b(x, y, 0, 215, 151, 14);
            }
            this.amountText.func_146193_g(this.attributeModifierEnabled ? 0xFFFFFF : 0x888888);
            this.amountText.func_146194_f();
            String displayAttributeName = CommonGuiStuff.trimWithDots(TabItemEditorAttributes.this.itemEditor.getFontRenderer(), I18n.func_135052_a((String)("attribute.name." + this.attributeModifier.func_111166_b()), (Object[])new Object[0]), 93);
            TabItemEditorAttributes.this.itemEditor.getFontRenderer().func_175063_a(displayAttributeName, (float)(x + 2), (float)(y + 3), this.attributeModifierEnabled ? 0xFFFFFF : 0x888888);
            String operation = this.attributeModifier.func_111169_c() == 0 ? "+" : (this.attributeModifier.func_111169_c() == 1 ? "x+" : "x");
            TabItemEditorAttributes.this.itemEditor.func_73732_a(TabItemEditorAttributes.this.itemEditor.getFontRenderer(), operation, x + 130, y + 3, this.attributeModifierEnabled ? 0xFFFFFF : 0x888888);
            int slotOffset = 0;
            switch (this.attributeSlot) {
                case MAINHAND: {
                    slotOffset = 0;
                    break;
                }
                case OFFHAND: {
                    slotOffset = 12;
                    break;
                }
                case HEAD: {
                    slotOffset = 24;
                    break;
                }
                case CHEST: {
                    slotOffset = 36;
                    break;
                }
                case LEGS: {
                    slotOffset = 48;
                    break;
                }
                case FEET: {
                    slotOffset = 60;
                }
            }
            float shade = this.attributeModifierEnabled ? 1.0f : 0.5f;
            GlStateManager.func_179131_c((float)shade, (float)shade, (float)shade, (float)1.0f);
            TabItemEditorAttributes.this.itemEditor.field_146297_k.func_110434_K().func_110577_a(ATTRIBUTE_MODIFIER_EDITOR_GUI_TEXTURE);
            TabItemEditorAttributes.this.itemEditor.func_73729_b(x + 138, y + 1, slotOffset, 243, 12, 12);
        }

        private void onRenderHoveredToolTip(int mouseX, int mouseY) {
            ArrayList<String> hoverInfo = new ArrayList<String>();
            if (mouseX > TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 128 && mouseX < TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 143 && mouseY > this.y && mouseY < this.y + 14) {
                int operation = this.attributeModifier.func_111169_c();
                hoverInfo.add(I18n.func_135052_a((String)("gui.item_editor.attribute.operation." + operation), (Object[])new Object[0]));
                hoverInfo.add("");
                hoverInfo.addAll(TabItemEditorAttributes.this.itemEditor.getFontRenderer().func_78271_c(I18n.func_135052_a((String)("gui.item_editor.attribute.operation." + operation + ".info"), (Object[])new Object[0]), 200));
            }
            if (mouseX > TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 143 && mouseX < TabItemEditorAttributes.this.itemEditor.getGuiLeft() + 158 && mouseY > this.y && mouseY < this.y + 14) {
                hoverInfo.add(I18n.func_135052_a((String)("item.modifiers." + this.attributeSlot.func_188450_d()), (Object[])new Object[0]));
            }
            if (!hoverInfo.isEmpty()) {
                hoverInfo.add("");
                hoverInfo.add(I18n.func_135052_a((String)"gui.clickToCycle", (Object[])new Object[0]));
                TabItemEditorAttributes.this.itemEditor.func_146283_a(hoverInfo, mouseX, mouseY);
            }
        }

        private void onAmountChanged(String newText) {
            double amount = 0.0;
            if (!newText.isEmpty() && !newText.equals("-")) {
                try {
                    amount = Double.valueOf(newText);
                }
                catch (NumberFormatException e) {
                    MapGadgetsMod.logger.warn("Tried to parse invalid attribute amount:", (Throwable)e);
                }
            }
            this.attributeModifierEnabled = amount != 0.0;
            this.attributeModifier = new AttributeModifier(this.attributeModifier.func_111167_a(), this.attributeModifier.func_111166_b(), amount, this.attributeModifier.func_111169_c());
            TabItemEditorAttributes.this.updateAttributeModifiers();
        }

        private TabItemEditorAttributes getOuterType() {
            return TabItemEditorAttributes.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            if (this.attributeModifier != null) {
                long temp = Double.doubleToLongBits(this.attributeModifier.func_111164_d());
                result = 31 * result + (int)(temp ^ temp >>> 32);
                result = 31 * result + (this.attributeModifier.func_111166_b() == null ? 0 : this.attributeModifier.func_111166_b().hashCode());
                result = 31 * result + this.attributeModifier.func_111169_c();
                result = 31 * result + (this.attributeModifier.func_111167_a() == null ? 0 : this.attributeModifier.func_111167_a().hashCode());
            }
            result = 31 * result + (this.attributeSlot == null ? 0 : this.attributeSlot.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeModifierSelection other = (AttributeModifierSelection)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.attributeModifier == null) {
                if (other.attributeModifier != null) {
                    return false;
                }
            } else if (!this.attributeModifier.equals((Object)other.attributeModifier)) {
                if (Double.doubleToLongBits(this.attributeModifier.func_111164_d()) != Double.doubleToLongBits(other.attributeModifier.func_111164_d())) {
                    return false;
                }
                if (this.attributeModifier.func_111166_b() == null ? other.attributeModifier.func_111166_b() != null : !this.attributeModifier.func_111166_b().equals(other.attributeModifier.func_111166_b())) {
                    return false;
                }
                if (this.attributeModifier.func_111169_c() != other.attributeModifier.func_111169_c()) {
                    return false;
                }
                if (this.attributeModifier.func_111167_a() == null ? other.attributeModifier.func_111167_a() != null : !this.attributeModifier.func_111167_a().equals(other.attributeModifier.func_111167_a())) {
                    return false;
                }
            }
            return this.attributeSlot == other.attributeSlot;
        }

        public String toString() {
            return "{ Name: " + this.attributeModifier.func_111166_b() + ", Amount: " + this.attributeModifier.func_111164_d() + ", Operation: " + this.attributeModifier.func_111169_c() + ", Slot: " + this.attributeSlot + ", UUID: " + this.attributeModifier.func_111167_a() + " }";
        }
    }
}

