/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.item;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.container.ContainerItemEditor;
import com.tmtravlr.mapgadgets.gui.item.TabItemEditor;
import com.tmtravlr.mapgadgets.gui.item.TabItemEditorAttributes;
import com.tmtravlr.mapgadgets.gui.item.TabItemEditorEnchantments;
import com.tmtravlr.mapgadgets.gui.item.TabItemEditorLore;
import com.tmtravlr.mapgadgets.gui.item.TabItemEditorStats;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiItemEditor
extends GuiContainer {
    private final TabItemEditorLore tabLore = new TabItemEditorLore(this);
    private final TabItemEditorStats tabStats = new TabItemEditorStats(this);
    private final TabItemEditorEnchantments tabEnchantments = new TabItemEditorEnchantments(this);
    private final TabItemEditorAttributes tabAttributes = new TabItemEditorAttributes(this);
    public final Slot itemSlot;
    public TabItemEditor currentTab = this.tabLore;
    public ItemStack lastItemStack = ItemStack.field_190927_a;

    public GuiItemEditor(InventoryPlayer inventory) {
        super((Container)new ContainerItemEditor(inventory));
        this.field_147000_g = 215;
        this.itemSlot = this.field_147002_h.func_75139_a(0);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.currentTab.initGui();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.currentTab.drawGuiContainerForegroundLayer(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.currentTab.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.currentTab.drawScreen(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        this.currentTab.renderHoveredToolTip(mouseX, mouseY);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.currentTab.handleMouseInput();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.currentTab.keyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        boolean clickedTab = false;
        if (this.currentTab != this.tabLore && mouseX > this.field_147003_i + 61 && mouseX < this.field_147003_i + 88 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 27) {
            this.currentTab = this.tabLore;
            clickedTab = true;
        } else if (this.currentTab != this.tabStats && mouseX > this.field_147003_i + 88 && mouseX < this.field_147003_i + 115 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 27) {
            this.currentTab = this.tabStats;
            clickedTab = true;
        } else if (this.currentTab != this.tabEnchantments && mouseX > this.field_147003_i + 115 && mouseX < this.field_147003_i + 142 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 27) {
            this.currentTab = this.tabEnchantments;
            clickedTab = true;
        } else if (this.currentTab != this.tabAttributes && mouseX > this.field_147003_i + 142 && mouseX < this.field_147003_i + 169 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 27) {
            this.currentTab = this.tabAttributes;
            clickedTab = true;
        } else {
            this.currentTab.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (clickedTab) {
            this.func_73866_w_();
            this.currentTab.onStackChanged();
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.currentTab.actionPerformed(button);
    }

    public void func_73876_c() {
        if (this.stackHasChanged()) {
            this.lastItemStack = this.itemSlot.func_75211_c();
            this.currentTab.onStackChanged();
        }
    }

    public <T extends GuiButton> T func_189646_b(T button) {
        return (T)super.func_189646_b(button);
    }

    public boolean stackHasChanged() {
        return !ItemStack.func_179545_c((ItemStack)this.lastItemStack, (ItemStack)this.itemSlot.func_75211_c());
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void sendItemChanges(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(null);
        }
        this.lastItemStack = stack;
        UUID playerUUID = this.field_146297_k.field_71439_g.func_110124_au();
        PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
        buff.writeInt(0);
        buff.writeInt(this.field_146297_k.field_71441_e.field_73011_w.getDimension());
        buff.writeLong(playerUUID.getMostSignificantBits());
        buff.writeLong(playerUUID.getLeastSignificantBits());
        buff.func_150788_a(this.lastItemStack);
        CToSMessage packet = new CToSMessage((ByteBuf)buff);
        MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
    }
}

