/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.entity;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.gui.GuiCheckbox;
import com.tmtravlr.mapgadgets.gui.entity.GuiEntityEditor;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditor;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLiving;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TabEntityEditorMobStats
extends TabEntityEditor
implements GuiPageButtonList.GuiResponder {
    private static final ResourceLocation ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/entity_editor/mob_editor.png");
    private static final int TEXT_DEATH_LOOT_TABLE = 0;
    private static final int TEXT_DEATH_LOOT_TABLE_SEED = 1;
    private static final int CHECKBOX_NO_AI = 0;
    private static final int CHECKBOX_INVISIBLE = 1;
    private static final int CHECKBOX_CAN_PICK_UP_LOOT = 2;
    private static final int CHECKBOX_PERSISTENCE = 3;
    private GuiTextField deathLootTable;
    private GuiTextField deathLootTableSeed;
    private GuiCheckbox noAICheckbox;
    private GuiCheckbox invisibleCheckbox;
    private GuiCheckbox pickUpLootCheckbox;
    private GuiCheckbox persistenceCheckbox;
    private final EntityLiving entityLiving;
    private String deathLootTableValue = "";
    private long deathLootTableSeedValue = 0L;
    private boolean noAI = false;
    private boolean persistenceRequired = false;
    private boolean hasLoaded = false;

    public TabEntityEditorMobStats(GuiEntityEditor entityEditor) {
        super(entityEditor);
        if (entityEditor.container.entity instanceof EntityLiving) {
            this.entityLiving = (EntityLiving)entityEditor.container.entity;
            if (GuiEntityEditor.nextMobStats != null) {
                this.loadEntityData(GuiEntityEditor.nextMobStats);
                GuiEntityEditor.nextMobStats = null;
            }
        } else {
            this.entityLiving = null;
        }
    }

    @Override
    public void initGui() {
        if (this.entityLiving != null) {
            int guiX = (this.entityEditor.field_146294_l - this.entityEditor.getXSize()) / 2;
            int guiY = (this.entityEditor.field_146295_m - this.entityEditor.getYSize()) / 2;
            String oldText = this.deathLootTable == null ? this.deathLootTableValue : this.deathLootTable.func_146179_b();
            this.deathLootTable = new GuiTextField(0, this.entityEditor.getFontRenderer(), guiX + 15, guiY + 46, 140, 10);
            this.deathLootTable.func_175207_a((GuiPageButtonList.GuiResponder)this);
            this.deathLootTable.func_146193_g(-1);
            this.deathLootTable.func_146204_h(-1);
            this.deathLootTable.func_146185_a(false);
            this.deathLootTable.func_146203_f(900);
            this.deathLootTable.func_146180_a(oldText);
            oldText = this.deathLootTableSeed == null ? String.valueOf(this.deathLootTableSeedValue) : this.deathLootTableSeed.func_146179_b();
            this.deathLootTableSeed = new GuiTextField(1, this.entityEditor.getFontRenderer(), guiX + 15, guiY + 74, 140, 10);
            this.deathLootTableSeed.func_175207_a((GuiPageButtonList.GuiResponder)this);
            this.deathLootTableSeed.func_175205_a(text -> text.matches("-?\\d*"));
            this.deathLootTableSeed.func_146193_g(-1);
            this.deathLootTableSeed.func_146204_h(-1);
            this.deathLootTableSeed.func_146185_a(false);
            this.deathLootTableSeed.func_146203_f(21);
            this.deathLootTableSeed.func_146180_a(oldText);
            boolean wasChecked = this.noAICheckbox != null ? this.noAICheckbox.checked : this.noAI;
            this.noAICheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(0, guiX + 12, guiY + 93, 176, 37, ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE));
            this.noAICheckbox.checked = wasChecked;
            wasChecked = this.invisibleCheckbox != null ? this.invisibleCheckbox.checked : this.entityLiving.func_82150_aj();
            this.invisibleCheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(1, guiX + 12, guiY + 111, 176, 37, ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE));
            this.invisibleCheckbox.checked = wasChecked;
            wasChecked = this.pickUpLootCheckbox != null ? this.pickUpLootCheckbox.checked : this.entityLiving.func_98052_bS();
            this.pickUpLootCheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(2, guiX + 86, guiY + 93, 176, 37, ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE));
            this.pickUpLootCheckbox.checked = wasChecked;
            wasChecked = this.persistenceCheckbox != null ? this.persistenceCheckbox.checked : this.persistenceRequired;
            this.persistenceCheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(3, guiX + 86, guiY + 111, 176, 37, ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE));
            this.persistenceCheckbox.checked = wasChecked;
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.deathLootTable", (Object[])new Object[0]), 13, 33, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.deathLootTableSeed", (Object[])new Object[0]), 13, 61, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.noAI", (Object[])new Object[0]), 27, 94, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.invisible", (Object[])new Object[0]), 27, 112, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.canPickUpLoot", (Object[])new Object[0]), 101, 94, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.persistenceRequired", (Object[])new Object[0]), 101, 112, 3416887);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE);
        int guiX = (this.entityEditor.field_146294_l - this.entityEditor.getXSize()) / 2;
        int guiY = (this.entityEditor.field_146295_m - this.entityEditor.getYSize()) / 2;
        this.entityEditor.func_73729_b(guiX, guiY, 0, 0, this.entityEditor.getXSize(), this.entityEditor.getYSize());
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        if (!this.hasLoaded || this.entityLiving == null) {
            String line2;
            String line1;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE);
            this.entityEditor.func_73729_b(this.entityEditor.getGuiLeft() + 46, this.entityEditor.getGuiTop() + 63, 176, 0, 80, 37);
            if (this.entityLiving == null) {
                line1 = I18n.func_135052_a((String)"gui.entity_editor.onlyMobs.line1", (Object[])new Object[0]);
                line2 = I18n.func_135052_a((String)"gui.entity_editor.onlyMobs.line2", (Object[])new Object[0]);
            } else {
                line1 = I18n.func_135052_a((String)"gui.entity_editor.loading.line1", (Object[])new Object[0]);
                line2 = I18n.func_135052_a((String)"gui.entity_editor.loading.line2", (Object[])new Object[0]);
            }
            this.entityEditor.getFontRenderer().func_78276_b(line1, this.entityEditor.getGuiLeft() + 86 - this.entityEditor.getFontRenderer().func_78256_a(line1) / 2, this.entityEditor.getGuiTop() + 71, 3416887);
            this.entityEditor.getFontRenderer().func_78276_b(line2, this.entityEditor.getGuiLeft() + 86 - this.entityEditor.getFontRenderer().func_78256_a(line2) / 2, this.entityEditor.getGuiTop() + 83, 3416887);
        } else {
            this.deathLootTable.func_146194_f();
            this.deathLootTableSeed.func_146194_f();
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return this.hasLoaded && this.entityLiving != null && (this.deathLootTable.func_146201_a(typedChar, keyCode) || this.deathLootTableSeed.func_146201_a(typedChar, keyCode));
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.hasLoaded && this.entityLiving != null) {
            this.deathLootTable.func_146192_a(mouseX, mouseY, mouseButton);
            this.deathLootTableSeed.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        if (this.hasLoaded && this.entityLiving != null) {
            if (button.field_146127_k == 0) {
                this.noAICheckbox.toggleCheckbox();
                this.noAI = this.noAICheckbox.checked;
            } else if (button.field_146127_k == 1) {
                this.invisibleCheckbox.toggleCheckbox();
                this.entityLiving.func_82142_c(this.invisibleCheckbox.checked);
            } else if (button.field_146127_k == 2) {
                this.pickUpLootCheckbox.toggleCheckbox();
                this.entityLiving.func_98053_h(this.pickUpLootCheckbox.checked);
            } else if (button.field_146127_k == 3) {
                this.persistenceCheckbox.toggleCheckbox();
                this.persistenceRequired = this.persistenceCheckbox.checked;
            }
            this.sendEntityData();
        }
    }

    @Override
    public void loadEntityData(PacketBuffer buff) {
        if (this.entityLiving != null) {
            this.deathLootTableValue = buff.func_150789_c(1000);
            this.deathLootTableSeedValue = buff.readLong();
            this.entityLiving.func_98053_h(buff.readBoolean());
            this.persistenceRequired = buff.readBoolean();
            this.noAI = buff.readBoolean();
            if (this.deathLootTable != null) {
                this.deathLootTable.func_146180_a(this.deathLootTableValue);
                this.deathLootTableSeed.func_146180_a(String.valueOf(this.deathLootTableSeedValue));
                this.noAICheckbox.checked = this.noAI;
                this.invisibleCheckbox.checked = this.entityLiving.func_82150_aj();
                this.pickUpLootCheckbox.checked = this.entityLiving.func_98052_bS();
                this.persistenceCheckbox.checked = this.persistenceRequired;
            }
            this.hasLoaded = true;
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        if (this.hasLoaded && this.entityLiving != null) {
            if (id == 0) {
                this.deathLootTableValue = value;
            } else if (id == 1) {
                this.deathLootTableSeedValue = 0L;
                if (!value.isEmpty()) {
                    try {
                        this.deathLootTableSeedValue = Long.parseLong(value);
                    }
                    catch (NumberFormatException e) {
                        this.deathLootTableSeedValue = value.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
                    }
                }
            }
            this.sendEntityData();
        }
    }

    private void sendEntityData() {
        if (this.hasLoaded && this.entityLiving != null) {
            UUID playerUUID = this.entityEditor.field_146297_k.field_71439_g.func_110124_au();
            PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
            buff.writeInt(7);
            buff.writeInt(this.entityEditor.field_146297_k.field_71441_e.field_73011_w.getDimension());
            buff.writeLong(playerUUID.getMostSignificantBits());
            buff.writeLong(playerUUID.getLeastSignificantBits());
            buff.func_180714_a(this.deathLootTableValue);
            buff.writeLong(this.deathLootTableSeedValue);
            buff.writeBoolean(this.noAI);
            buff.writeBoolean(this.entityLiving.func_82150_aj());
            buff.writeBoolean(this.entityLiving.func_98052_bS());
            buff.writeBoolean(this.persistenceRequired);
            CToSMessage packet = new CToSMessage((ByteBuf)buff);
            MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
        }
    }
}

