/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.entity;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.gui.entity.GuiEntityEditor;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditor;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.UUID;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TabEntityEditorEquipment
extends TabEntityEditor
implements GuiPageButtonList.GuiResponder {
    private static final ResourceLocation ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/entity_editor/equipment_editor.png");
    private static final int TEXT_DROP_CHANCE_MAINHAND = 0;
    private static final int TEXT_DROP_CHANCE_OFFHAND = 1;
    private static final int TEXT_DROP_CHANCE_HEAD = 2;
    private static final int TEXT_DROP_CHANCE_CHEST = 3;
    private static final int TEXT_DROP_CHANCE_LEGS = 4;
    private static final int TEXT_DROP_CHANCE_FEET = 5;
    private final EntityLiving entityLiving;
    private GuiTextField dropChanceMainhand;
    private GuiTextField dropChanceOffhand;
    private GuiTextField dropChanceHead;
    private GuiTextField dropChanceChest;
    private GuiTextField dropChanceLegs;
    private GuiTextField dropChanceFeet;
    private float originalDropChanceMainhand;
    private float originalDropChanceOffhand;
    private float originalDropChanceHead;
    private float originalDropChanceChest;
    private float originalDropChanceLegs;
    private float originalDropChanceFeet;
    private float oldMouseX;
    private float oldMouseY;
    private boolean hasLoaded = false;

    public TabEntityEditorEquipment(GuiEntityEditor entityEditor) {
        super(entityEditor);
        if (entityEditor.container.entity instanceof EntityLiving) {
            this.entityLiving = (EntityLiving)entityEditor.container.entity;
            if (GuiEntityEditor.nextMobStats != null) {
                this.loadEntityData(GuiEntityEditor.nextMobStats);
                GuiEntityEditor.nextMobStats = null;
            }
            NBTTagCompound entityTag = new NBTTagCompound();
            this.entityLiving.func_70014_b(entityTag);
        } else {
            this.entityLiving = null;
        }
    }

    @Override
    public void initGui() {
        if (this.entityLiving != null) {
            int guiX = (this.entityEditor.field_146294_l - this.entityEditor.getXSize()) / 2;
            int guiY = (this.entityEditor.field_146295_m - this.entityEditor.getYSize()) / 2;
            DecimalFormat format = new DecimalFormat("#.###");
            if (this.hasLoaded) {
                this.entityEditor.container.enableEquipmentSlots = true;
            }
            String oldText = this.dropChanceMainhand == null ? format.format(this.originalDropChanceMainhand) : this.dropChanceMainhand.func_146179_b();
            this.dropChanceMainhand = new GuiTextField(0, this.entityEditor.getFontRenderer(), guiX + 78, guiY + 67, 33, 10);
            this.dropChanceMainhand.func_175207_a((GuiPageButtonList.GuiResponder)this);
            this.dropChanceMainhand.func_175205_a(text -> text.matches("\\d?\\.?\\d?\\d?\\d?"));
            this.dropChanceMainhand.func_146193_g(-1);
            this.dropChanceMainhand.func_146204_h(-1);
            this.dropChanceMainhand.func_146185_a(false);
            this.dropChanceMainhand.func_146203_f(5);
            this.dropChanceMainhand.func_146180_a(oldText);
            oldText = this.dropChanceOffhand == null ? format.format(this.originalDropChanceOffhand) : this.dropChanceOffhand.func_146179_b();
            this.dropChanceOffhand = new GuiTextField(1, this.entityEditor.getFontRenderer(), guiX + 78, guiY + 85, 33, 10);
            this.dropChanceOffhand.func_175207_a((GuiPageButtonList.GuiResponder)this);
            this.dropChanceOffhand.func_175205_a(text -> text.matches("\\d?\\.?\\d?\\d?\\d?"));
            this.dropChanceOffhand.func_146193_g(-1);
            this.dropChanceOffhand.func_146204_h(-1);
            this.dropChanceOffhand.func_146185_a(false);
            this.dropChanceOffhand.func_146203_f(5);
            this.dropChanceOffhand.func_146180_a(oldText);
            oldText = this.dropChanceHead == null ? format.format(this.originalDropChanceHead) : this.dropChanceHead.func_146179_b();
            this.dropChanceHead = new GuiTextField(2, this.entityEditor.getFontRenderer(), guiX + 136, guiY + 49, 33, 10);
            this.dropChanceHead.func_175207_a((GuiPageButtonList.GuiResponder)this);
            this.dropChanceHead.func_175205_a(text -> text.matches("\\d?\\.?\\d?\\d?\\d?"));
            this.dropChanceHead.func_146193_g(-1);
            this.dropChanceHead.func_146204_h(-1);
            this.dropChanceHead.func_146185_a(false);
            this.dropChanceHead.func_146203_f(5);
            this.dropChanceHead.func_146180_a(oldText);
            oldText = this.dropChanceChest == null ? format.format(this.originalDropChanceChest) : this.dropChanceChest.func_146179_b();
            this.dropChanceChest = new GuiTextField(3, this.entityEditor.getFontRenderer(), guiX + 136, guiY + 67, 33, 10);
            this.dropChanceChest.func_175207_a((GuiPageButtonList.GuiResponder)this);
            this.dropChanceChest.func_175205_a(text -> text.matches("\\d?\\.?\\d?\\d?\\d?"));
            this.dropChanceChest.func_146193_g(-1);
            this.dropChanceChest.func_146204_h(-1);
            this.dropChanceChest.func_146185_a(false);
            this.dropChanceChest.func_146203_f(5);
            this.dropChanceChest.func_146180_a(oldText);
            oldText = this.dropChanceLegs == null ? format.format(this.originalDropChanceLegs) : this.dropChanceLegs.func_146179_b();
            this.dropChanceLegs = new GuiTextField(4, this.entityEditor.getFontRenderer(), guiX + 136, guiY + 85, 33, 10);
            this.dropChanceLegs.func_175207_a((GuiPageButtonList.GuiResponder)this);
            this.dropChanceLegs.func_175205_a(text -> text.matches("\\d?\\.?\\d?\\d?\\d?"));
            this.dropChanceLegs.func_146193_g(-1);
            this.dropChanceLegs.func_146204_h(-1);
            this.dropChanceLegs.func_146185_a(false);
            this.dropChanceLegs.func_146203_f(5);
            this.dropChanceLegs.func_146180_a(oldText);
            oldText = this.dropChanceFeet == null ? format.format(this.originalDropChanceFeet) : this.dropChanceFeet.func_146179_b();
            this.dropChanceFeet = new GuiTextField(5, this.entityEditor.getFontRenderer(), guiX + 136, guiY + 103, 33, 10);
            this.dropChanceFeet.func_175207_a((GuiPageButtonList.GuiResponder)this);
            this.dropChanceFeet.func_175205_a(text -> text.matches("\\d?\\.?\\d?\\d?\\d?"));
            this.dropChanceFeet.func_146193_g(-1);
            this.dropChanceFeet.func_146204_h(-1);
            this.dropChanceFeet.func_146185_a(false);
            this.dropChanceFeet.func_146203_f(5);
            this.dropChanceFeet.func_146180_a(oldText);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE);
        int guiX = (this.entityEditor.field_146294_l - this.entityEditor.getXSize()) / 2;
        int guiY = (this.entityEditor.field_146295_m - this.entityEditor.getYSize()) / 2;
        this.entityEditor.func_73729_b(guiX, guiY, 0, 0, this.entityEditor.getXSize(), this.entityEditor.getYSize());
        if (this.entityLiving != null) {
            GuiInventory.func_147046_a((int)(guiX + 32), (int)(guiY + 112), (int)30, (float)((float)(guiX + 32) - this.oldMouseX), (float)((float)(guiY + 112 - 50) - this.oldMouseY), (EntityLivingBase)this.entityLiving);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179140_f();
        if (!this.hasLoaded || this.entityLiving == null) {
            String line2;
            String line1;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_MOB_STATS_GUI_TEXTURE);
            this.entityEditor.func_73729_b(this.entityEditor.getGuiLeft() + 46, this.entityEditor.getGuiTop() + 63, 176, 0, 80, 37);
            if (this.entityLiving == null) {
                line1 = I18n.func_135052_a((String)"gui.entity_editor.onlyMobs.line1", (Object[])new Object[0]);
                line2 = I18n.func_135052_a((String)"gui.entity_editor.onlyMobs.line2", (Object[])new Object[0]);
            } else {
                line1 = I18n.func_135052_a((String)"gui.entity_editor.loading.line1", (Object[])new Object[0]);
                line2 = I18n.func_135052_a((String)"gui.entity_editor.loading.line2", (Object[])new Object[0]);
            }
            this.entityEditor.getFontRenderer().func_78276_b(line1, this.entityEditor.getGuiLeft() + 86 - this.entityEditor.getFontRenderer().func_78256_a(line1) / 2, this.entityEditor.getGuiTop() + 71, 3416887);
            this.entityEditor.getFontRenderer().func_78276_b(line2, this.entityEditor.getGuiLeft() + 86 - this.entityEditor.getFontRenderer().func_78256_a(line2) / 2, this.entityEditor.getGuiTop() + 83, 3416887);
        } else {
            this.dropChanceMainhand.func_146194_f();
            this.dropChanceOffhand.func_146194_f();
            this.dropChanceHead.func_146194_f();
            this.dropChanceChest.func_146194_f();
            this.dropChanceLegs.func_146194_f();
            this.dropChanceFeet.func_146194_f();
            this.oldMouseX = mouseX;
            this.oldMouseY = mouseY;
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return this.hasLoaded && this.entityLiving != null && (this.dropChanceMainhand.func_146201_a(typedChar, keyCode) || this.dropChanceOffhand.func_146201_a(typedChar, keyCode) || this.dropChanceHead.func_146201_a(typedChar, keyCode) || this.dropChanceChest.func_146201_a(typedChar, keyCode) || this.dropChanceLegs.func_146201_a(typedChar, keyCode) || this.dropChanceFeet.func_146201_a(typedChar, keyCode));
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.hasLoaded && this.entityLiving != null) {
            this.dropChanceMainhand.func_146192_a(mouseX, mouseY, mouseButton);
            this.dropChanceOffhand.func_146192_a(mouseX, mouseY, mouseButton);
            this.dropChanceHead.func_146192_a(mouseX, mouseY, mouseButton);
            this.dropChanceChest.func_146192_a(mouseX, mouseY, mouseButton);
            this.dropChanceLegs.func_146192_a(mouseX, mouseY, mouseButton);
            this.dropChanceFeet.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void loadEntityData(PacketBuffer buff) {
        if (this.entityLiving != null) {
            this.originalDropChanceMainhand = buff.readFloat();
            this.originalDropChanceOffhand = buff.readFloat();
            this.originalDropChanceFeet = buff.readFloat();
            this.originalDropChanceLegs = buff.readFloat();
            this.originalDropChanceChest = buff.readFloat();
            this.originalDropChanceHead = buff.readFloat();
            if (this.dropChanceMainhand != null) {
                DecimalFormat format = new DecimalFormat("#.###");
                this.dropChanceMainhand.func_146180_a(format.format(this.originalDropChanceMainhand));
                this.dropChanceOffhand.func_146180_a(format.format(this.originalDropChanceOffhand));
                this.dropChanceHead.func_146180_a(format.format(this.originalDropChanceHead));
                this.dropChanceChest.func_146180_a(format.format(this.originalDropChanceChest));
                this.dropChanceLegs.func_146180_a(format.format(this.originalDropChanceLegs));
                this.dropChanceFeet.func_146180_a(format.format(this.originalDropChanceFeet));
            }
            this.hasLoaded = true;
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        if (this.hasLoaded && this.entityLiving != null) {
            EntityEquipmentSlot slot = null;
            float chance = 0.0f;
            if (id == 0) {
                slot = EntityEquipmentSlot.MAINHAND;
                chance = this.parseFloatFromText(value);
            } else if (id == 1) {
                slot = EntityEquipmentSlot.OFFHAND;
                chance = this.parseFloatFromText(value);
            } else if (id == 2) {
                slot = EntityEquipmentSlot.HEAD;
                chance = this.parseFloatFromText(value);
            } else if (id == 3) {
                slot = EntityEquipmentSlot.CHEST;
                chance = this.parseFloatFromText(value);
            } else if (id == 4) {
                slot = EntityEquipmentSlot.LEGS;
                chance = this.parseFloatFromText(value);
            } else if (id == 5) {
                slot = EntityEquipmentSlot.FEET;
                chance = this.parseFloatFromText(value);
            }
            if (slot != null) {
                this.sendEntityData(slot, chance);
            }
        }
    }

    private float parseFloatFromText(String text) {
        float value = 0.0f;
        if (!text.isEmpty()) {
            try {
                value = Float.parseFloat(text);
            }
            catch (NumberFormatException e) {
                MapGadgetsMod.logger.warn("Tried to parse invalid drop chance:", (Throwable)e);
            }
        }
        return value;
    }

    private void sendEntityData(EntityEquipmentSlot slot, float chance) {
        if (this.hasLoaded && this.entityLiving != null) {
            UUID playerUUID = this.entityEditor.field_146297_k.field_71439_g.func_110124_au();
            PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
            buff.writeInt(8);
            buff.writeInt(this.entityEditor.field_146297_k.field_71441_e.field_73011_w.getDimension());
            buff.writeLong(playerUUID.getMostSignificantBits());
            buff.writeLong(playerUUID.getLeastSignificantBits());
            buff.func_179249_a((Enum)slot);
            buff.writeFloat(chance);
            CToSMessage packet = new CToSMessage((ByteBuf)buff);
            MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
        }
    }
}

