/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.entity;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.gui.CommonGuiStuff;
import com.tmtravlr.mapgadgets.gui.GuiCheckbox;
import com.tmtravlr.mapgadgets.gui.entity.GuiEntityEditor;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditor;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TabEntityEditorEntityStats
extends TabEntityEditor
implements GuiPageButtonList.GuiResponder {
    private static final ResourceLocation ENTITY_EDITOR_ENTITY_STATS_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/entity_editor/entity_editor.png");
    private static final int CHECKBOX_CUSTOM_NAME_VISIBLE = 0;
    private static final int CHECKBOX_INVULNERABLE = 1;
    private static final int CHECKBOX_SILENT = 2;
    private static final int CHECKBOX_GLOWING = 3;
    private static final int CHECKBOX_NO_GRAVITY = 4;
    private GuiTextField name;
    private GuiCheckbox nameVisibleCheckbox;
    private GuiCheckbox invulnerableCheckbox;
    private GuiCheckbox silentCheckbox;
    private GuiCheckbox glowingCheckbox;
    private GuiCheckbox noGravityCheckbox;
    private String originalName = "";
    private String originalCustomName = "";
    private boolean isGlowing = false;
    private boolean hasLoaded = false;

    public TabEntityEditorEntityStats(GuiEntityEditor entityEditor) {
        super(entityEditor);
        if (GuiEntityEditor.nextEntityStats != null) {
            this.loadEntityData(GuiEntityEditor.nextEntityStats);
            GuiEntityEditor.nextEntityStats = null;
        }
        this.originalName = CommonGuiStuff.getOriginalEntityName(entityEditor.container.entity);
        this.originalCustomName = entityEditor.container.entity.func_95999_t();
    }

    @Override
    public void initGui() {
        String oldText;
        int guiX = (this.entityEditor.field_146294_l - this.entityEditor.getXSize()) / 2;
        int guiY = (this.entityEditor.field_146295_m - this.entityEditor.getYSize()) / 2;
        String string = oldText = this.originalCustomName.isEmpty() ? this.originalName : this.originalCustomName;
        if (this.name != null) {
            oldText = this.name.func_146179_b();
        }
        this.name = new GuiTextField(-1, this.entityEditor.getFontRenderer(), guiX + 15, guiY + 38, 140, 10);
        this.name.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.name.func_146193_g(-1);
        this.name.func_146204_h(-1);
        this.name.func_146185_a(false);
        this.name.func_146203_f(45);
        this.name.func_146180_a(oldText);
        boolean wasChecked = this.nameVisibleCheckbox != null ? this.nameVisibleCheckbox.checked : this.entityEditor.container.entity.func_174833_aM();
        this.nameVisibleCheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(0, guiX + 12, guiY + 55, 176, 37, ENTITY_EDITOR_ENTITY_STATS_GUI_TEXTURE));
        this.nameVisibleCheckbox.checked = wasChecked;
        wasChecked = this.invulnerableCheckbox != null ? this.invulnerableCheckbox.checked : this.entityEditor.container.entity.func_190530_aW();
        this.invulnerableCheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(1, guiX + 12, guiY + 70, 176, 37, ENTITY_EDITOR_ENTITY_STATS_GUI_TEXTURE));
        this.invulnerableCheckbox.checked = wasChecked;
        wasChecked = this.silentCheckbox != null ? this.silentCheckbox.checked : this.entityEditor.container.entity.func_174814_R();
        this.silentCheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(2, guiX + 12, guiY + 86, 176, 37, ENTITY_EDITOR_ENTITY_STATS_GUI_TEXTURE));
        this.silentCheckbox.checked = wasChecked;
        wasChecked = this.glowingCheckbox != null ? this.glowingCheckbox.checked : this.isGlowing;
        this.glowingCheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(3, guiX + 12, guiY + 102, 176, 37, ENTITY_EDITOR_ENTITY_STATS_GUI_TEXTURE));
        this.glowingCheckbox.checked = wasChecked;
        wasChecked = this.noGravityCheckbox != null ? this.noGravityCheckbox.checked : this.entityEditor.container.entity.func_189652_ae();
        this.noGravityCheckbox = this.entityEditor.func_189646_b(new GuiCheckbox(4, guiX + 12, guiY + 117, 176, 37, ENTITY_EDITOR_ENTITY_STATS_GUI_TEXTURE));
        this.noGravityCheckbox.checked = wasChecked;
    }

    @Override
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.customNameVisible", (Object[])new Object[0]), 27, 56, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.invulnerable", (Object[])new Object[0]), 27, 71, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.silent", (Object[])new Object[0]), 27, 87, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.glowing", (Object[])new Object[0]), 27, 103, 3416887);
        this.entityEditor.getFontRenderer().func_78276_b(I18n.func_135052_a((String)"gui.entity_editor.noGravity", (Object[])new Object[0]), 27, 118, 3416887);
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_ENTITY_STATS_GUI_TEXTURE);
        int guiX = (this.entityEditor.field_146294_l - this.entityEditor.getXSize()) / 2;
        int guiY = (this.entityEditor.field_146295_m - this.entityEditor.getYSize()) / 2;
        this.entityEditor.func_73729_b(guiX, guiY, 0, 0, this.entityEditor.getXSize(), this.entityEditor.getYSize());
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        if (!this.hasLoaded) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_ENTITY_STATS_GUI_TEXTURE);
            this.entityEditor.func_73729_b(this.entityEditor.getGuiLeft() + 46, this.entityEditor.getGuiTop() + 63, 176, 0, 80, 37);
            String line1 = I18n.func_135052_a((String)"gui.entity_editor.loading.line1", (Object[])new Object[0]);
            String line2 = I18n.func_135052_a((String)"gui.entity_editor.loading.line2", (Object[])new Object[0]);
            this.entityEditor.getFontRenderer().func_78276_b(line1, this.entityEditor.getGuiLeft() + 86 - this.entityEditor.getFontRenderer().func_78256_a(line1) / 2, this.entityEditor.getGuiTop() + 71, 3416887);
            this.entityEditor.getFontRenderer().func_78276_b(line2, this.entityEditor.getGuiLeft() + 86 - this.entityEditor.getFontRenderer().func_78256_a(line2) / 2, this.entityEditor.getGuiTop() + 83, 3416887);
        } else {
            this.name.func_146194_f();
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return this.hasLoaded && this.name.func_146201_a(typedChar, keyCode);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.hasLoaded) {
            this.name.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void actionPerformed(GuiButton button) throws IOException {
        if (this.hasLoaded) {
            if (button.field_146127_k == 0) {
                this.nameVisibleCheckbox.toggleCheckbox();
                this.entityEditor.container.entity.func_174805_g(this.nameVisibleCheckbox.checked);
            } else if (button.field_146127_k == 1) {
                this.invulnerableCheckbox.toggleCheckbox();
                this.entityEditor.container.entity.func_184224_h(this.invulnerableCheckbox.checked);
            } else if (button.field_146127_k == 2) {
                this.silentCheckbox.toggleCheckbox();
                this.entityEditor.container.entity.func_174810_b(this.silentCheckbox.checked);
            } else if (button.field_146127_k == 3) {
                this.glowingCheckbox.toggleCheckbox();
                this.isGlowing = this.glowingCheckbox.checked;
            } else if (button.field_146127_k == 4) {
                this.noGravityCheckbox.toggleCheckbox();
                this.entityEditor.container.entity.func_189654_d(this.noGravityCheckbox.checked);
            }
            this.sendEntityData();
        }
    }

    @Override
    public void loadEntityData(PacketBuffer buff) {
        this.entityEditor.container.entity.func_184224_h(buff.readBoolean());
        this.isGlowing = buff.readBoolean();
        if (this.name != null) {
            this.name.func_146180_a(this.originalCustomName.isEmpty() ? this.originalName : this.originalCustomName);
            this.nameVisibleCheckbox.checked = this.entityEditor.container.entity.func_174833_aM();
            this.invulnerableCheckbox.checked = this.entityEditor.container.entity.func_190530_aW();
            this.silentCheckbox.checked = this.entityEditor.container.entity.func_174814_R();
            this.glowingCheckbox.checked = this.isGlowing;
            this.noGravityCheckbox.checked = this.entityEditor.container.entity.func_189652_ae();
        }
        this.hasLoaded = true;
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        if (this.originalName.equals(value)) {
            value = "";
        }
        this.entityEditor.container.entity.func_96094_a(value);
        this.sendEntityData();
    }

    private void sendEntityData() {
        if (this.hasLoaded) {
            UUID playerUUID = this.entityEditor.field_146297_k.field_71439_g.func_110124_au();
            PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
            buff.writeInt(6);
            buff.writeInt(this.entityEditor.field_146297_k.field_71441_e.field_73011_w.getDimension());
            buff.writeLong(playerUUID.getMostSignificantBits());
            buff.writeLong(playerUUID.getLeastSignificantBits());
            buff.func_180714_a(this.entityEditor.container.entity.func_95999_t());
            buff.writeBoolean(this.entityEditor.container.entity.func_174833_aM());
            buff.writeBoolean(this.entityEditor.container.entity.func_190530_aW());
            buff.writeBoolean(this.entityEditor.container.entity.func_174814_R());
            buff.writeBoolean(this.isGlowing);
            buff.writeBoolean(this.entityEditor.container.entity.func_189652_ae());
            CToSMessage packet = new CToSMessage((ByteBuf)buff);
            MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
        }
    }
}

