/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.entity;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.gui.CommonGuiStuff;
import com.tmtravlr.mapgadgets.gui.entity.GuiEntityEditor;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditor;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLiving;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class TabEntityEditorAttributes
extends TabEntityEditor {
    private static final ResourceLocation ENTITY_EDITOR_ATTRIBUTES_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/entity_editor/attribute_editor.png");
    private final EntityLiving entityLiving;
    private final List<AttributeSelection> selections = new ArrayList<AttributeSelection>();
    private float currentScroll;
    private int scrollIndex;
    private boolean isScrolling;
    private boolean wasClicking;
    private boolean hasLoaded = false;
    private boolean hasInitialized = false;
    private Map<String, Double> originalAttributes = new HashMap<String, Double>();

    public TabEntityEditorAttributes(GuiEntityEditor entityEditor) {
        super(entityEditor);
        if (entityEditor.container.entity instanceof EntityLiving) {
            this.entityLiving = (EntityLiving)entityEditor.container.entity;
            if (GuiEntityEditor.nextAttributes != null) {
                this.loadEntityData(GuiEntityEditor.nextAttributes);
                GuiEntityEditor.nextAttributes = null;
            }
        } else {
            this.entityLiving = null;
        }
    }

    @Override
    public void initGui() {
        if (!this.hasInitialized && this.hasLoaded) {
            this.hasInitialized = true;
            this.originalAttributes.forEach((attributeName, attributeBase) -> this.selections.add(new AttributeSelection((String)attributeName, (double)attributeBase)));
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_ATTRIBUTES_GUI_TEXTURE);
        int guiX = (this.entityEditor.field_146294_l - this.entityEditor.getXSize()) / 2;
        int guiY = (this.entityEditor.field_146295_m - this.entityEditor.getYSize()) / 2;
        this.entityEditor.func_73729_b(guiX, guiY, 0, 0, this.entityEditor.getXSize(), this.entityEditor.getYSize());
        int scrollX = this.entityEditor.getGuiLeft() + 158;
        int scrollY = this.entityEditor.getGuiTop() + 36;
        this.entityEditor.func_175174_a(scrollX, (float)scrollY + 71.0f * this.currentScroll, 176 + (this.needsScrollBar() ? 0 : 12), 37, 12, 15);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179140_f();
        if (!this.hasLoaded || this.entityLiving == null) {
            String line2;
            String line1;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_ATTRIBUTES_GUI_TEXTURE);
            this.entityEditor.func_73729_b(this.entityEditor.getGuiLeft() + 46, this.entityEditor.getGuiTop() + 63, 176, 0, 80, 37);
            if (this.entityLiving == null) {
                line1 = I18n.func_135052_a((String)"gui.entity_editor.onlyMobs.line1", (Object[])new Object[0]);
                line2 = I18n.func_135052_a((String)"gui.entity_editor.onlyMobs.line2", (Object[])new Object[0]);
            } else {
                line1 = I18n.func_135052_a((String)"gui.entity_editor.loading.line1", (Object[])new Object[0]);
                line2 = I18n.func_135052_a((String)"gui.entity_editor.loading.line2", (Object[])new Object[0]);
            }
            this.entityEditor.getFontRenderer().func_78276_b(line1, this.entityEditor.getGuiLeft() + 86 - this.entityEditor.getFontRenderer().func_78256_a(line1) / 2, this.entityEditor.getGuiTop() + 71, 3416887);
            this.entityEditor.getFontRenderer().func_78276_b(line2, this.entityEditor.getGuiLeft() + 86 - this.entityEditor.getFontRenderer().func_78256_a(line2) / 2, this.entityEditor.getGuiTop() + 83, 3416887);
        } else {
            boolean mouseDown = Mouse.isButtonDown((int)0);
            int scrollX = this.entityEditor.getGuiLeft() + 158;
            int scrollY = this.entityEditor.getGuiTop() + 36;
            int scrollWidth = 12;
            int scrollHeight = 86;
            if (!this.wasClicking && mouseDown && mouseX >= scrollX && mouseX < scrollX + scrollWidth && mouseY >= scrollY && mouseY < scrollY + scrollHeight) {
                this.isScrolling = this.needsScrollBar();
            }
            if (!mouseDown) {
                this.isScrolling = false;
            }
            this.wasClicking = mouseDown;
            if (this.isScrolling) {
                this.currentScroll = ((float)(mouseY - scrollY) - 7.5f) / ((float)scrollHeight - 15.0f);
                this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
                this.scrollIndex = Math.round((float)(this.selections.size() - 6) * this.currentScroll);
            }
            for (int i = 0; i < 6; ++i) {
                if (i + this.scrollIndex >= this.selections.size()) continue;
                this.selections.get(i + this.scrollIndex).onDrawScreen(mouseX, mouseY, this.entityEditor.getGuiLeft() + 10, this.entityEditor.getGuiTop() + 37 + i * 14, partialTicks);
            }
        }
    }

    @Override
    public void handleMouseInput() throws IOException {
        int i;
        if (this.hasLoaded && this.entityLiving != null && (i = Mouse.getEventDWheel()) != 0 && this.needsScrollBar()) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.scrollIndex = MathHelper.func_76125_a((int)(this.scrollIndex - i), (int)0, (int)(this.selections.size() - 6));
            this.currentScroll = (float)this.scrollIndex / (float)(this.selections.size() - 6);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        if (this.hasLoaded && this.entityLiving != null) {
            for (int i = 0; i < this.selections.size(); ++i) {
                if (!this.isSelectionVisible(i) || !this.selections.get(i).onKeyTyped(typedChar, keyCode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.hasLoaded && this.entityLiving != null) {
            for (int i = 0; i < this.selections.size(); ++i) {
                if (this.isSelectionVisible(i)) {
                    this.selections.get(i).onMouseClicked(mouseX, mouseY, mouseButton);
                    continue;
                }
                this.selections.get(i).onMouseClickedNotVisible();
            }
        }
    }

    @Override
    public void loadEntityData(PacketBuffer buff) {
        if (this.entityLiving != null) {
            int size = buff.readInt();
            for (int i = 0; i < size; ++i) {
                String attributeName = buff.func_150789_c(1000);
                double attributeBase = buff.readDouble();
                this.originalAttributes.put(attributeName, attributeBase);
            }
            this.hasLoaded = true;
        }
    }

    private boolean isSelectionVisible(int id) {
        return id >= this.scrollIndex && id < this.scrollIndex + 6;
    }

    private boolean needsScrollBar() {
        return this.hasLoaded && this.entityLiving != null && this.selections.size() > 6;
    }

    private void sendEntityData(AttributeSelection selection) {
        if (this.hasLoaded && this.entityLiving != null) {
            UUID playerUUID = this.entityEditor.field_146297_k.field_71439_g.func_110124_au();
            PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
            buff.writeInt(9);
            buff.writeInt(this.entityEditor.field_146297_k.field_71441_e.field_73011_w.getDimension());
            buff.writeLong(playerUUID.getMostSignificantBits());
            buff.writeLong(playerUUID.getLeastSignificantBits());
            buff.func_180714_a(selection.name);
            buff.writeDouble(selection.base);
            CToSMessage packet = new CToSMessage((ByteBuf)buff);
            MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
        }
    }

    private class AttributeSelection {
        private String name;
        private double base;
        private GuiTextField baseText;
        private int y = 0;

        private AttributeSelection(String attributeName, double attributeBase) {
            this.name = attributeName;
            this.base = attributeBase;
            this.baseText = new GuiTextField(0, TabEntityEditorAttributes.this.entityEditor.getFontRenderer(), 0, 0, 42, 10){

                public void func_190516_a(int id, String text) {
                    AttributeSelection.this.onBaseChanged(text);
                }

                public void func_146195_b(boolean isFocused) {
                    super.func_146195_b(isFocused);
                    if (!isFocused) {
                        this.func_146199_i(this.func_146198_h());
                    }
                }
            };
            this.baseText.func_146203_f(13);
            this.baseText.func_175205_a(text -> text.matches("-?\\d*\\.?\\d?\\d?"));
            this.baseText.func_146193_g(-1);
            this.baseText.func_146204_h(-1);
            this.baseText.func_146185_a(false);
            this.setBaseText(this.base);
        }

        private void setBaseText(double base) {
            base = MathHelper.func_151237_a((double)base, (double)-9.99999999E8, (double)9.99999999E8);
            DecimalFormat format = new DecimalFormat("#.##");
            this.baseText.func_146180_a(format.format(base));
        }

        private void onMouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.baseText.func_146192_a(mouseX, mouseY, mouseButton);
            if (mouseX > TabEntityEditorAttributes.this.entityEditor.getGuiLeft() + 10 && mouseX < TabEntityEditorAttributes.this.entityEditor.getGuiLeft() + 109 && mouseY > this.y && mouseY < this.y + 14) {
                this.baseText.func_146195_b(true);
                this.baseText.func_146202_e();
                this.baseText.func_146199_i(0);
            }
        }

        private void onMouseClickedNotVisible() {
            if (this.baseText.func_146206_l()) {
                this.baseText.func_146195_b(false);
            }
        }

        private boolean onKeyTyped(char typedChar, int keyCode) {
            return this.baseText.func_146201_a(typedChar, keyCode);
        }

        private void onDrawScreen(int mouseX, int mouseY, int x, int y, float partialTicks) {
            this.baseText.field_146210_g = y + 3;
            this.baseText.field_146209_f = TabEntityEditorAttributes.this.entityEditor.getGuiLeft() + 111;
            this.y = y;
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TabEntityEditorAttributes.this.entityEditor.field_146297_k.func_110434_K().func_110577_a(ENTITY_EDITOR_ATTRIBUTES_GUI_TEXTURE);
            TabEntityEditorAttributes.this.entityEditor.func_73729_b(x, y, 0, 215, 144, 14);
            this.baseText.func_146194_f();
            String displayAttributeName = CommonGuiStuff.trimWithDots(TabEntityEditorAttributes.this.entityEditor.getFontRenderer(), I18n.func_135052_a((String)("attribute.name." + this.name), (Object[])new Object[0]), 100);
            TabEntityEditorAttributes.this.entityEditor.getFontRenderer().func_175063_a(displayAttributeName, (float)(x + 2), (float)(y + 3), 0xFFFFFF);
        }

        private void onBaseChanged(String newText) {
            this.base = 0.0;
            if (!newText.isEmpty() && !newText.equals("-")) {
                try {
                    this.base = Double.valueOf(newText);
                }
                catch (NumberFormatException e) {
                    MapGadgetsMod.logger.warn("Tried to parse invalid attribute base:", (Throwable)e);
                }
            }
            TabEntityEditorAttributes.this.sendEntityData(this);
        }
    }
}

