/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui.entity;

import com.tmtravlr.mapgadgets.container.ContainerEntityEditor;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditor;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditorAttributes;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditorEntityStats;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditorEquipment;
import com.tmtravlr.mapgadgets.gui.entity.TabEntityEditorMobStats;
import java.io.IOException;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiEntityEditor
extends GuiContainer {
    public static PacketBuffer nextEntityStats;
    public static PacketBuffer nextMobStats;
    public static PacketBuffer nextEquipment;
    public static PacketBuffer nextAttributes;
    private final TabEntityEditorEntityStats tabEntityStats;
    private final TabEntityEditorMobStats tabMobStats;
    private final TabEntityEditorEquipment tabEquipment;
    private final TabEntityEditorAttributes tabAttributes;
    public final ContainerEntityEditor container;
    public TabEntityEditor currentTab;

    public GuiEntityEditor(InventoryPlayer inventory, int entityId) {
        super((Container)new ContainerEntityEditor(inventory, entityId));
        this.field_147000_g = 215;
        this.container = (ContainerEntityEditor)this.field_147002_h;
        this.tabEntityStats = new TabEntityEditorEntityStats(this);
        this.tabMobStats = new TabEntityEditorMobStats(this);
        this.tabEquipment = new TabEntityEditorEquipment(this);
        this.tabAttributes = new TabEntityEditorAttributes(this);
        this.currentTab = this.tabEntityStats;
        if (nextEntityStats != null) {
            this.loadEntityStats(nextEntityStats);
            nextEntityStats = null;
        }
        if (nextMobStats != null) {
            this.loadMobStats(nextMobStats);
            nextMobStats = null;
        }
        if (nextEquipment != null) {
            this.loadEquipment(nextEquipment);
            nextEquipment = null;
        }
        if (nextAttributes != null) {
            this.loadAttributes(nextAttributes);
            nextAttributes = null;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.container.enableEquipmentSlots = false;
        this.currentTab.initGui();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.currentTab.drawGuiContainerForegroundLayer(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.currentTab.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.currentTab.drawScreen(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        this.currentTab.renderHoveredToolTip(mouseX, mouseY);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.currentTab.handleMouseInput();
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.currentTab.keyTyped(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        TabEntityEditor clickedTab = null;
        if (this.currentTab != this.tabEntityStats && mouseX > this.field_147003_i + 6 && mouseX < this.field_147003_i + 33 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 27) {
            clickedTab = this.tabEntityStats;
        } else if (this.currentTab != this.tabMobStats && mouseX > this.field_147003_i + 33 && mouseX < this.field_147003_i + 60 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 27) {
            clickedTab = this.tabMobStats;
        } else if (this.currentTab != this.tabEquipment && mouseX > this.field_147003_i + 60 && mouseX < this.field_147003_i + 87 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 27) {
            clickedTab = this.tabEquipment;
        } else if (this.currentTab != this.tabAttributes && mouseX > this.field_147003_i + 87 && mouseX < this.field_147003_i + 114 && mouseY > this.field_147009_r && mouseY < this.field_147009_r + 27) {
            clickedTab = this.tabAttributes;
        } else {
            this.currentTab.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (clickedTab != null) {
            this.currentTab = clickedTab;
            this.func_73866_w_();
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.currentTab.actionPerformed(button);
    }

    public <T extends GuiButton> T func_189646_b(T button) {
        return (T)super.func_189646_b(button);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void loadEntityStats(PacketBuffer buff) {
        this.tabEntityStats.loadEntityData(buff);
    }

    public void loadMobStats(PacketBuffer buff) {
        this.tabMobStats.loadEntityData(buff);
    }

    public void loadEquipment(PacketBuffer buff) {
        this.tabEquipment.loadEntityData(buff);
    }

    public void loadAttributes(PacketBuffer buff) {
        this.tabAttributes.loadEntityData(buff);
    }
}

