/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.container.ContainerTradeEditor;
import com.tmtravlr.mapgadgets.gui.CommonGuiStuff;
import com.tmtravlr.mapgadgets.gui.GuiCheckbox;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiTradeEditor
extends GuiContainer
implements GuiPageButtonList.GuiResponder {
    private static final ResourceLocation TRADE_EDITOR_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/trade_editor.png");
    private ContainerTradeEditor container;
    private String originalVillagerName;
    private String originalCustomName;
    private boolean originalInvulnerable;
    private boolean originalInfiniteTrades;
    private GuiTextField name;
    private GuiCheckbox invulnerableCheckbox;
    private GuiCheckbox infiniteTradesCheckbox;
    private MerchantButton nextButton;
    private MerchantButton previousButton;

    public GuiTradeEditor(InventoryPlayer inventory, int villagerId, int infiniteTrades, int invulnerable) {
        super((Container)new ContainerTradeEditor(inventory, villagerId, infiniteTrades));
        this.container = (ContainerTradeEditor)this.field_147002_h;
        this.originalInvulnerable = invulnerable != 0;
        this.originalInfiniteTrades = infiniteTrades != 0;
        this.originalVillagerName = CommonGuiStuff.getOriginalEntityName((Entity)this.container.villager);
        this.originalCustomName = this.container.villager.func_95999_t();
    }

    public void func_73866_w_() {
        String oldName;
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.nextButton = (MerchantButton)this.func_189646_b(new MerchantButton(1, i + 147, j + 51, true));
        this.previousButton = (MerchantButton)this.func_189646_b(new MerchantButton(2, i + 17, j + 51, false));
        this.nextButton.field_146124_l = true;
        this.previousButton.field_146124_l = false;
        boolean wasInvulnerable = this.originalInvulnerable;
        if (this.invulnerableCheckbox != null) {
            wasInvulnerable = this.invulnerableCheckbox.checked;
        }
        this.invulnerableCheckbox = (GuiCheckbox)this.func_189646_b(new GuiCheckbox(3, i + 14, j + 24, 176, 38, TRADE_EDITOR_GUI_TEXTURE));
        this.invulnerableCheckbox.checked = wasInvulnerable;
        boolean wasInfiniteTrades = this.originalInfiniteTrades;
        if (this.infiniteTradesCheckbox != null) {
            wasInfiniteTrades = this.infiniteTradesCheckbox.checked;
        }
        this.infiniteTradesCheckbox = (GuiCheckbox)this.func_189646_b(new GuiCheckbox(4, i + 14, j + 37, 176, 38, TRADE_EDITOR_GUI_TEXTURE));
        this.infiniteTradesCheckbox.checked = wasInfiniteTrades;
        String string = oldName = this.originalCustomName.isEmpty() ? this.originalVillagerName : this.originalCustomName;
        if (this.name != null) {
            oldName = this.name.func_146179_b();
        }
        this.name = new GuiTextField(0, this.field_146289_q, i + 16, j + 10, 140, 10);
        this.name.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.name.func_146193_g(-1);
        this.name.func_146204_h(-1);
        this.name.func_146185_a(false);
        this.name.func_146203_f(45);
        this.name.func_146180_a(oldName);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.invulnerable", (Object[])new Object[0]), 29, 26, 3416887);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.trade_editor.infiniteTrades", (Object[])new Object[0]), 29, 38, 3416887);
        this.field_146289_q.func_78276_b(String.valueOf(this.container.getSelectedRecipe()), 160, 57, 3416887);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TRADE_EDITOR_GUI_TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        this.name.func_146194_f();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.previousButton.field_146124_l = this.container.getSelectedRecipe() > 0;
        this.nextButton.field_146124_l = this.container.getSelectedRecipe() < 1000;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.nextButton) {
            this.container.setSelectedRecipe(this.container.getSelectedRecipe() + 1);
            this.updateTradeIndex();
        } else if (button == this.previousButton) {
            this.container.setSelectedRecipe(this.container.getSelectedRecipe() - 1);
            this.updateTradeIndex();
        } else if (button == this.invulnerableCheckbox) {
            this.invulnerableCheckbox.toggleCheckbox();
            this.updateNameAndInvulnerable();
        } else if (button == this.infiniteTradesCheckbox) {
            this.infiniteTradesCheckbox.toggleCheckbox();
            this.updateInfiniteTrades();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.name.func_146201_a(typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.name.func_146192_a(mouseX, mouseY, mouseButton);
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        this.updateNameAndInvulnerable();
    }

    private void updateNameAndInvulnerable() {
        UUID playerUUID = this.field_146297_k.field_71439_g.func_110124_au();
        PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
        buff.writeInt(3);
        buff.writeLong(playerUUID.getMostSignificantBits());
        buff.writeLong(playerUUID.getLeastSignificantBits());
        buff.writeInt(this.field_146297_k.field_71441_e.field_73011_w.getDimension());
        buff.writeBoolean(this.invulnerableCheckbox.checked);
        String customNameTag = this.name.func_146179_b();
        if (customNameTag.equals(this.originalVillagerName)) {
            customNameTag = "";
        }
        buff.func_180714_a(customNameTag);
        CToSMessage packet = new CToSMessage((ByteBuf)buff);
        MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
    }

    private void updateInfiniteTrades() {
        UUID playerUUID = this.field_146297_k.field_71439_g.func_110124_au();
        PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
        buff.writeInt(2);
        buff.writeLong(playerUUID.getMostSignificantBits());
        buff.writeLong(playerUUID.getLeastSignificantBits());
        buff.writeBoolean(this.infiniteTradesCheckbox.checked);
        CToSMessage packet = new CToSMessage((ByteBuf)buff);
        MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
    }

    private void updateTradeIndex() {
        UUID playerUUID = this.field_146297_k.field_71439_g.func_110124_au();
        PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
        buff.writeInt(1);
        buff.writeLong(playerUUID.getMostSignificantBits());
        buff.writeLong(playerUUID.getLeastSignificantBits());
        buff.writeInt(this.container.getSelectedRecipe());
        CToSMessage packet = new CToSMessage((ByteBuf)buff);
        MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
    }

    @SideOnly(value=Side.CLIENT)
    static class MerchantButton
    extends GuiButton {
        private final boolean forward;

        public MerchantButton(int buttonID, int x, int y, boolean forward) {
            super(buttonID, x, y, 12, 19, "");
            this.forward = forward;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                mc.func_110434_K().func_110577_a(TRADE_EDITOR_GUI_TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                int i = 0;
                int j = 176;
                if (!this.field_146124_l) {
                    j += this.field_146120_f * 2;
                } else if (flag) {
                    j += this.field_146120_f;
                }
                if (!this.forward) {
                    i += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, j, i, this.field_146120_f, this.field_146121_g);
            }
        }
    }
}

