/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.container.ContainerSpawnerEditor;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiSpawnerEditor
extends GuiContainer {
    private static final ResourceLocation SPAWNER_EDITOR_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/spawner_editor.png");
    public static PacketBuffer nextSpawnerStats;
    private ContainerSpawnerEditor container;
    private BlockPos spawnerPos;
    private boolean hasLoaded = false;
    private GuiTextField spawnCount;
    private GuiTextField maxNearby;
    private GuiTextField spawnRange;
    private GuiTextField playerRange;
    private GuiTextField delay;
    private GuiTextField minDelay;
    private GuiTextField maxDelay;

    public GuiSpawnerEditor(InventoryPlayer inventory, int x, int y, int z) {
        super((Container)new ContainerSpawnerEditor(inventory, x, y, z));
        this.field_146999_f = 216;
        this.field_147000_g = 195;
        this.container = (ContainerSpawnerEditor)this.field_147002_h;
        this.spawnerPos = new BlockPos(x, y, z);
        if (nextSpawnerStats != null) {
            this.loadSpawnerStats(nextSpawnerStats);
            nextSpawnerStats = null;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int guiX = (this.field_146294_l - this.field_146999_f) / 2;
        int guiY = (this.field_146295_m - this.field_147000_g) / 2;
        String oldText = this.spawnCount == null ? String.valueOf(this.container.spawnCount) : this.spawnCount.func_146179_b();
        this.spawnCount = new GuiTextField(0, this.field_146289_q, guiX + 73, guiY + 23, 21, 10);
        this.spawnCount.func_146193_g(-1);
        this.spawnCount.func_146204_h(-1);
        this.spawnCount.func_175205_a(text -> text.matches("\\d*"));
        this.spawnCount.func_146185_a(false);
        this.spawnCount.func_146203_f(2);
        this.spawnCount.func_146180_a(oldText);
        oldText = this.maxNearby == null ? String.valueOf(this.container.maxNearbyEntities) : this.maxNearby.func_146179_b();
        this.maxNearby = new GuiTextField(0, this.field_146289_q, guiX + 73, guiY + 57, 21, 10);
        this.maxNearby.func_146193_g(-1);
        this.maxNearby.func_146204_h(-1);
        this.maxNearby.func_175205_a(text -> text.matches("\\d*"));
        this.maxNearby.func_146185_a(false);
        this.maxNearby.func_146203_f(2);
        this.maxNearby.func_146180_a(oldText);
        oldText = this.spawnRange == null ? String.valueOf(this.container.spawnRange) : this.spawnRange.func_146179_b();
        this.spawnRange = new GuiTextField(0, this.field_146289_q, guiX + 145, guiY + 23, 27, 10);
        this.spawnRange.func_146193_g(-1);
        this.spawnRange.func_146204_h(-1);
        this.spawnRange.func_175205_a(text -> text.matches("\\d*"));
        this.spawnRange.func_146185_a(false);
        this.spawnRange.func_146203_f(3);
        this.spawnRange.func_146180_a(oldText);
        oldText = this.playerRange == null ? String.valueOf(this.container.requiredPlayerRange) : this.playerRange.func_146179_b();
        this.playerRange = new GuiTextField(0, this.field_146289_q, guiX + 145, guiY + 57, 27, 10);
        this.playerRange.func_146193_g(-1);
        this.playerRange.func_146204_h(-1);
        this.playerRange.func_175205_a(text -> text.matches("\\d*"));
        this.playerRange.func_146185_a(false);
        this.playerRange.func_146203_f(3);
        this.playerRange.func_146180_a(oldText);
        oldText = this.delay == null ? String.valueOf(this.container.delay) : this.delay.func_146179_b();
        this.delay = new GuiTextField(0, this.field_146289_q, guiX + 30, guiY + 91, 38, 10);
        this.delay.func_146193_g(-1);
        this.delay.func_146204_h(-1);
        this.delay.func_175205_a(text -> text.matches("\\d*"));
        this.delay.func_146185_a(false);
        this.delay.func_146203_f(5);
        this.delay.func_146180_a(oldText);
        oldText = this.minDelay == null ? String.valueOf(this.container.minDelay) : this.minDelay.func_146179_b();
        this.minDelay = new GuiTextField(0, this.field_146289_q, guiX + 89, guiY + 91, 38, 10);
        this.minDelay.func_146193_g(-1);
        this.minDelay.func_146204_h(-1);
        this.minDelay.func_175205_a(text -> text.matches("\\d*"));
        this.minDelay.func_146185_a(false);
        this.minDelay.func_146203_f(5);
        this.minDelay.func_146180_a(oldText);
        oldText = this.maxDelay == null ? String.valueOf(this.container.maxDelay) : this.maxDelay.func_146179_b();
        this.maxDelay = new GuiTextField(0, this.field_146289_q, guiX + 149, guiY + 91, 38, 10);
        this.maxDelay.func_146193_g(-1);
        this.maxDelay.func_146204_h(-1);
        this.maxDelay.func_175205_a(text -> text.matches("\\d*"));
        this.maxDelay.func_146185_a(false);
        this.maxDelay.func_146203_f(5);
        this.maxDelay.func_146180_a(oldText);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.hasLoaded) {
            this.sendSpawnerStatsToServer();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.spawnPotentials", (Object[])new Object[0]), 11, 10, 3416887);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.spawnCount", (Object[])new Object[0]), 71, 10, 3416887);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.spawnRange", (Object[])new Object[0]), 143, 10, 3416887);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.maxNearbyEntities", (Object[])new Object[0]), 71, 44, 3416887);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.requiredPlayerRange", (Object[])new Object[0]), 143, 44, 3416887);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.delay", (Object[])new Object[0]), 28, 78, 3416887);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.minSpawnDelay", (Object[])new Object[0]), 87, 78, 3416887);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.maxSpawnDelay", (Object[])new Object[0]), 147, 78, 3416887);
        if (!this.hasLoaded) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(SPAWNER_EDITOR_GUI_TEXTURE);
            int startX = 66;
            int startY = 25;
            this.func_73729_b(startX, startY, 0, 194, 119, 37);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.spawner_editor.loading", (Object[])new Object[0]), startX + 5, startY + 13, 3416887);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(SPAWNER_EDITOR_GUI_TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.hasLoaded) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179084_k();
            this.spawnCount.func_146194_f();
            this.maxNearby.func_146194_f();
            this.spawnRange.func_146194_f();
            this.playerRange.func_146194_f();
            this.delay.func_146194_f();
            this.minDelay.func_146194_f();
            this.maxDelay.func_146194_f();
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!(this.hasLoaded && (this.spawnCount.func_146201_a(typedChar, keyCode) || this.maxNearby.func_146201_a(typedChar, keyCode) || this.spawnRange.func_146201_a(typedChar, keyCode) || this.playerRange.func_146201_a(typedChar, keyCode) || this.delay.func_146201_a(typedChar, keyCode) || this.minDelay.func_146201_a(typedChar, keyCode) || this.maxDelay.func_146201_a(typedChar, keyCode)))) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.hasLoaded) {
            this.spawnCount.func_146192_a(mouseX, mouseY, mouseButton);
            this.maxNearby.func_146192_a(mouseX, mouseY, mouseButton);
            this.spawnRange.func_146192_a(mouseX, mouseY, mouseButton);
            this.playerRange.func_146192_a(mouseX, mouseY, mouseButton);
            this.delay.func_146192_a(mouseX, mouseY, mouseButton);
            this.minDelay.func_146192_a(mouseX, mouseY, mouseButton);
            this.maxDelay.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    public void loadSpawnerStats(PacketBuffer buff) {
        this.container.loadSpawnerStats(buff);
        if (this.spawnCount != null) {
            this.spawnCount.func_146180_a(String.valueOf(this.container.spawnCount));
            this.maxNearby.func_146180_a(String.valueOf(this.container.maxNearbyEntities));
            this.spawnRange.func_146180_a(String.valueOf(this.container.spawnRange));
            this.playerRange.func_146180_a(String.valueOf(this.container.requiredPlayerRange));
            this.delay.func_146180_a(String.valueOf(this.container.delay));
            this.minDelay.func_146180_a(String.valueOf(this.container.minDelay));
            this.maxDelay.func_146180_a(String.valueOf(this.container.maxDelay));
        }
        this.hasLoaded = true;
    }

    private void sendSpawnerStatsToServer() {
        UUID playerUUID = this.field_146297_k.field_71439_g.func_110124_au();
        PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
        buff.writeInt(4);
        buff.writeLong(playerUUID.getMostSignificantBits());
        buff.writeLong(playerUUID.getLeastSignificantBits());
        buff.writeInt(this.field_146297_k.field_71441_e.field_73011_w.getDimension());
        buff.func_179255_a(this.spawnerPos);
        buff.writeShort((int)this.getShort(this.spawnCount));
        buff.writeShort((int)this.getShort(this.maxNearby));
        buff.writeShort((int)this.getShort(this.spawnRange));
        buff.writeShort((int)this.getShort(this.playerRange));
        buff.writeShort((int)this.getShort(this.delay));
        buff.writeShort((int)this.getShort(this.minDelay));
        buff.writeShort((int)this.getShort(this.maxDelay));
        CToSMessage packet = new CToSMessage((ByteBuf)buff);
        MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
    }

    private short getShort(GuiTextField textField) {
        String valueText = textField.func_146179_b();
        short value = 0;
        if (!valueText.isEmpty()) {
            try {
                int intValue = Integer.parseInt(valueText);
                intValue = MathHelper.func_76125_a((int)intValue, (int)0, (int)Short.MAX_VALUE);
                value = (short)intValue;
            }
            catch (NumberFormatException e) {
                MapGadgetsMod.logger.warn("Caught execption while trying to parse a spawner stat: ", (Throwable)e);
            }
        }
        return value;
    }
}

