/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.gui;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.container.ContainerPotionMaker;
import com.tmtravlr.mapgadgets.gui.CommonGuiStuff;
import com.tmtravlr.mapgadgets.network.CToSMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiPotionMaker
extends GuiContainer
implements GuiPageButtonList.GuiResponder {
    private static final ResourceLocation POTION_MAKER_GUI_TEXTURE = new ResourceLocation("mapgadgets", "textures/gui/container/potion_maker.png");
    private final List<PotionEffectSelection> selections = new ArrayList<PotionEffectSelection>();
    private final Map<Potion, PotionEffectSelection> selectionMap = new HashMap<Potion, PotionEffectSelection>();
    private ContainerPotionMaker container;
    private GuiTextField color;
    public int scrollIndex;
    private boolean wasClicking;
    public boolean hasInitialized = false;
    private float sliderRed = 0.0f;
    private float sliderGreen = 0.0f;
    private float sliderBlue = 0.0f;
    private float scrollbarPotions = 0.0f;
    private boolean slidingRed;
    private boolean slidingGreen;
    private boolean slidingBlue;
    private boolean scrollingPotions;
    private NBTTagCompound prevNBTTag;

    public GuiPotionMaker(InventoryPlayer inventory) {
        super((Container)new ContainerPotionMaker(inventory));
        this.field_146999_f = 197;
        this.field_147000_g = 223;
        this.container = (ContainerPotionMaker)this.field_147002_h;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int guiX = (this.field_146294_l - this.field_146999_f) / 2;
        int guiY = (this.field_146295_m - this.field_147000_g) / 2;
        String oldText = this.color == null ? String.valueOf(PotionUtils.func_190932_c((ItemStack)this.container.potionSlots[0].func_75211_c())) : this.color.func_146179_b();
        this.color = new GuiTextField(0, this.field_146289_q, guiX + 112, guiY + 40, 54, 10);
        this.color.func_175207_a((GuiPageButtonList.GuiResponder)this);
        this.color.func_175205_a(text -> text.matches("(0x|#)?[a-fA-F\\d]*"));
        this.color.func_146193_g(-1);
        this.color.func_146204_h(-1);
        this.color.func_146185_a(false);
        this.color.func_146203_f(8);
        this.color.func_146180_a(oldText);
        if (!this.hasInitialized) {
            this.hasInitialized = true;
            this.resetSelections();
            this.prevNBTTag = this.container.potionSlots[0].func_75211_c().func_77978_p();
            this.setColorAndPotionEffectsFromStack(this.container.potionSlots[0].func_75211_c());
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        if (!NBTUtil.func_181123_a((NBTBase)this.container.potionSlots[0].func_75211_c().func_77978_p(), (NBTBase)this.prevNBTTag, (boolean)true)) {
            ItemStack stack = this.container.potionSlots[0].func_75211_c();
            this.prevNBTTag = stack.func_77978_p();
            this.setColorAndPotionEffectsFromStack(stack);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(POTION_MAKER_GUI_TEXTURE);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        int sliderX = this.getGuiLeft() + 26;
        int sliderY = this.getGuiTop() + 35;
        this.func_175174_a((float)sliderX + 69.0f * this.sliderRed, sliderY, 24, 237, 5, 6);
        this.func_175174_a((float)sliderX + 69.0f * this.sliderGreen, sliderY + 6, 24, 237, 5, 6);
        this.func_175174_a((float)sliderX + 69.0f * this.sliderBlue, sliderY + 12, 24, 237, 5, 6);
        int scrollX = this.getGuiLeft() + 179;
        int scrollY = this.getGuiTop() + 58;
        this.func_175174_a(scrollX, (float)scrollY + 57.0f * this.scrollbarPotions, this.needsScrollBar() ? 0 : 12, 237, 12, 15);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (Mouse.isButtonDown((int)0)) {
            int blue;
            int green;
            int red;
            int color;
            String colorString;
            int scrollX = this.getGuiLeft() + 180;
            int scrollY = this.getGuiTop() + 59;
            int sliderX = this.getGuiLeft() + 28;
            int sliderY = this.getGuiTop() + 36;
            int scrollWidth = 12;
            int scrollHeight = 71;
            int sliderWidth = 70;
            int sliderHeight = 6;
            if (!this.wasClicking && mouseX >= sliderX && mouseX < sliderX + sliderWidth && mouseY >= sliderY && mouseY < sliderY + sliderHeight) {
                this.slidingRed = true;
            }
            if (!this.wasClicking && mouseX >= sliderX && mouseX < sliderX + sliderWidth && mouseY >= sliderY + 6 && mouseY < sliderY + 6 + sliderHeight) {
                this.slidingGreen = true;
            }
            if (!this.wasClicking && mouseX >= sliderX && mouseX < sliderX + sliderWidth && mouseY >= sliderY + 12 && mouseY < sliderY + 12 + sliderHeight) {
                this.slidingBlue = true;
            }
            if (!this.wasClicking && mouseX >= scrollX && mouseX < scrollX + scrollWidth && mouseY >= scrollY && mouseY < scrollY + scrollHeight) {
                this.scrollingPotions = this.needsScrollBar();
            }
            this.wasClicking = true;
            if (this.slidingRed) {
                this.sliderRed = (float)(mouseX - sliderX) / (float)sliderWidth;
                this.sliderRed = MathHelper.func_76131_a((float)this.sliderRed, (float)0.0f, (float)1.0f);
            }
            if (this.slidingGreen) {
                this.sliderGreen = (float)(mouseX - sliderX) / (float)sliderWidth;
                this.sliderGreen = MathHelper.func_76131_a((float)this.sliderGreen, (float)0.0f, (float)1.0f);
            }
            if (this.slidingBlue) {
                this.sliderBlue = (float)(mouseX - sliderX) / (float)sliderWidth;
                this.sliderBlue = MathHelper.func_76131_a((float)this.sliderBlue, (float)0.0f, (float)1.0f);
            }
            if ((this.slidingRed || this.slidingGreen || this.slidingBlue) && !(colorString = String.valueOf(color = (red = (int)(255.0f * this.sliderRed)) << 16 | (green = (int)(255.0f * this.sliderGreen)) << 8 | (blue = (int)(255.0f * this.sliderBlue)))).equals(this.color.func_146179_b())) {
                this.color.func_146180_a(colorString);
                this.func_175319_a(0, colorString);
            }
            if (this.scrollingPotions) {
                this.scrollbarPotions = ((float)(mouseY - scrollY) - 7.5f) / ((float)scrollHeight - 15.0f);
                this.scrollbarPotions = MathHelper.func_76131_a((float)this.scrollbarPotions, (float)0.0f, (float)1.0f);
                this.scrollIndex = Math.round((float)(this.selections.size() - 5) * this.scrollbarPotions);
            }
        } else {
            this.scrollingPotions = false;
            this.slidingBlue = false;
            this.slidingGreen = false;
            this.slidingRed = false;
            this.wasClicking = false;
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179084_k();
        this.color.func_146194_f();
        for (i = 0; i < 5; ++i) {
            if (i + this.scrollIndex >= this.selections.size()) continue;
            this.selections.get(i + this.scrollIndex).onDrawScreen(mouseX, mouseY, this.getGuiLeft() + 10, this.getGuiTop() + 59 + i * 14, partialTicks);
        }
        this.func_191948_b(mouseX, mouseY);
        for (i = 0; i < 5; ++i) {
            if (i + this.scrollIndex >= this.selections.size()) continue;
            this.selections.get(i + this.scrollIndex).onRenderHoveredToolTip(mouseX, mouseY);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean typedKey = false;
        if (this.color.func_146201_a(typedChar, keyCode)) {
            typedKey = true;
        }
        for (int i = 0; i < this.selections.size(); ++i) {
            if (!this.isSelectionVisible(i) || !this.selections.get(i).onKeyTyped(typedChar, keyCode)) continue;
            typedKey = true;
        }
        if (!typedKey) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBar()) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.scrollIndex = MathHelper.func_76125_a((int)(this.scrollIndex - i), (int)0, (int)(this.selections.size() - 5));
            this.scrollbarPotions = (float)this.scrollIndex / (float)(this.selections.size() - 5);
            this.scrollbarPotions = MathHelper.func_76131_a((float)this.scrollbarPotions, (float)0.0f, (float)1.0f);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.color.func_146192_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.selections.size(); ++i) {
            if (this.isSelectionVisible(i)) {
                this.selections.get(i).onMouseClicked(mouseX, mouseY, mouseButton);
                continue;
            }
            this.selections.get(i).onMouseClickedNotVisible();
        }
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        int color = 0;
        try {
            if (value.startsWith("0x")) {
                if ((value = value.substring(2)).isEmpty()) {
                    value = "0";
                }
                color = Integer.parseInt(value, 16);
            } else if (value.startsWith("#")) {
                if ((value = value.substring(1)).isEmpty()) {
                    value = "0";
                }
                color = Integer.parseInt(value, 16);
            } else {
                color = Integer.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            MapGadgetsMod.logger.warn("Caught exception while trying to parse color integer: ", (Throwable)e);
        }
        color = Math.min(color, 0xFFFFFF);
        int red = color >> 16;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        this.sliderRed = (float)red / 255.0f;
        this.sliderGreen = (float)green / 255.0f;
        this.sliderBlue = (float)blue / 255.0f;
        this.updatePotionColor(color);
    }

    private boolean needsScrollBar() {
        return this.selections.size() > 5;
    }

    private boolean isSelectionVisible(int id) {
        return id >= this.scrollIndex && id < this.scrollIndex + 5;
    }

    private void onStackChanged() {
        this.setColorAndPotionEffectsFromStack(this.container.potionSlots[0].func_75211_c());
        this.scrollbarPotions = 0.0f;
        this.scrollIndex = 0;
    }

    public void setColorAndPotionEffectsFromStack(ItemStack stack) {
        if (this.hasInitialized) {
            int color = PotionUtils.func_190932_c((ItemStack)stack);
            int red = color >> 16;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            this.sliderRed = (float)red / 255.0f;
            this.sliderGreen = (float)green / 255.0f;
            this.sliderBlue = (float)blue / 255.0f;
            this.color.func_146180_a(String.valueOf(color));
            this.resetSelections();
            List potionEffects = PotionUtils.func_185190_b((ItemStack)stack);
            potionEffects.forEach(effect -> {
                if (this.selectionMap.containsKey(effect.func_188419_a())) {
                    this.selectionMap.get(effect.func_188419_a()).setPotionEffect(effect);
                }
            });
        }
    }

    private void resetSelections() {
        this.selections.clear();
        this.selectionMap.clear();
        Potion.field_188414_b.forEach(potion -> {
            PotionEffectSelection selection = new PotionEffectSelection(new PotionEffect(potion, 0, 0));
            this.selectionMap.put((Potion)potion, selection);
            this.selections.add(selection);
        });
        this.selections.sort((effect1, effect2) -> I18n.func_135052_a((String)((PotionEffectSelection)effect1).potionEffect.func_76453_d(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)((PotionEffectSelection)effect2).potionEffect.func_76453_d(), (Object[])new Object[0])));
        this.selections.sort((effect1, effect2) -> {
            boolean bad1 = ((PotionEffectSelection)effect1).potionEffect.func_188419_a().func_76398_f();
            boolean bad2 = ((PotionEffectSelection)effect2).potionEffect.func_188419_a().func_76398_f();
            if (bad1 && !bad2) {
                return 1;
            }
            if (bad2 && !bad1) {
                return -1;
            }
            return 0;
        });
    }

    private void updatePotionColor(int color) {
        for (Slot slot : this.container.potionSlots) {
            if (!slot.func_75211_c().func_77942_o()) {
                slot.func_75211_c().func_77982_d(new NBTTagCompound());
            }
            slot.func_75211_c().func_77978_p().func_74768_a("CustomPotionColor", color);
        }
        this.sendPotionChanges();
    }

    private void updatePotionEffects() {
        NBTTagList customPotionEffects = new NBTTagList();
        this.selections.forEach(selection -> {
            if (((PotionEffectSelection)selection).potionEffect.func_76459_b() > 0) {
                customPotionEffects.func_74742_a((NBTBase)((PotionEffectSelection)selection).potionEffect.func_82719_a(new NBTTagCompound()));
            }
        });
        for (Slot slot : this.container.potionSlots) {
            if (!slot.func_75211_c().func_77942_o()) {
                slot.func_75211_c().func_77982_d(new NBTTagCompound());
            }
            if (!customPotionEffects.func_82582_d()) {
                slot.func_75211_c().func_77978_p().func_74782_a("CustomPotionEffects", (NBTBase)customPotionEffects);
                continue;
            }
            slot.func_75211_c().func_77978_p().func_82580_o("CustomPotionEffects");
        }
        this.sendPotionChanges();
    }

    private void sendPotionChanges() {
        NBTTagCompound tag;
        UUID playerUUID = this.field_146297_k.field_71439_g.func_110124_au();
        this.prevNBTTag = tag = this.container.potionSlots[0].func_75211_c().func_77978_p();
        PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
        buff.writeInt(5);
        buff.writeInt(this.field_146297_k.field_71441_e.field_73011_w.getDimension());
        buff.writeLong(playerUUID.getMostSignificantBits());
        buff.writeLong(playerUUID.getLeastSignificantBits());
        buff.func_150786_a(tag);
        CToSMessage packet = new CToSMessage((ByteBuf)buff);
        MapGadgetsMod.networkWrapper.sendToServer((IMessage)packet);
    }

    private class PotionEffectSelection {
        private GuiTextField amplifierText;
        private GuiTextField durationText;
        private PotionEffect potionEffect;
        private boolean potionEffectEnabled;
        private int y = 0;

        private PotionEffectSelection(PotionEffect potionEffect) {
            this.potionEffect = potionEffect;
            this.amplifierText = new GuiTextField(0, GuiPotionMaker.this.field_146289_q, 0, 0, 26, 10){

                public void func_190516_a(int id, String text) {
                    PotionEffectSelection.this.onAmplifierChanged(text);
                }

                public void func_146195_b(boolean isFocused) {
                    super.func_146195_b(isFocused);
                    if (!isFocused) {
                        this.func_146199_i(this.func_146198_h());
                    }
                }
            };
            this.amplifierText.func_146203_f(3);
            this.amplifierText.func_175205_a(text -> text.matches("[+-]?\\d*\\.?\\d?\\d?"));
            this.amplifierText.func_146193_g(-1);
            this.amplifierText.func_146204_h(-1);
            this.amplifierText.func_146185_a(false);
            this.setAmplifierText(potionEffect.func_76458_c());
            this.durationText = new GuiTextField(0, GuiPotionMaker.this.field_146289_q, 0, 0, 38, 10){

                public void func_190516_a(int id, String text) {
                    PotionEffectSelection.this.onDurationChanged(text);
                }

                public void func_146195_b(boolean isFocused) {
                    super.func_146195_b(isFocused);
                    if (!isFocused) {
                        this.func_146199_i(this.func_146198_h());
                    }
                }
            };
            this.durationText.func_146203_f(10);
            this.durationText.func_175205_a(text -> text.matches("[+-]?\\d*\\.?\\d?\\d?"));
            this.durationText.func_146193_g(-1);
            this.durationText.func_146204_h(-1);
            this.durationText.func_146185_a(false);
            this.setDurationText(potionEffect.func_76459_b());
        }

        private void setPotionEffect(PotionEffect potionEffect) {
            this.potionEffect = potionEffect;
            this.setAmplifierText(potionEffect.func_76458_c());
            this.setDurationText(potionEffect.func_76459_b());
        }

        private void setAmplifierText(int amplifier) {
            amplifier = MathHelper.func_76125_a((int)amplifier, (int)0, (int)127);
            this.amplifierText.func_146180_a(String.valueOf(amplifier));
        }

        private void setDurationText(int duration) {
            this.potionEffectEnabled = (duration = MathHelper.func_76125_a((int)duration, (int)0, (int)Integer.MAX_VALUE)) > 0;
            this.durationText.func_146180_a(String.valueOf(duration));
        }

        private void onMouseClicked(int mouseX, int mouseY, int mouseButton) {
            this.amplifierText.func_146192_a(mouseX, mouseY, mouseButton);
            this.durationText.func_146192_a(mouseX, mouseY, mouseButton);
            if (mouseX > GuiPotionMaker.this.getGuiLeft() + 10 && mouseX < GuiPotionMaker.this.getGuiLeft() + 95 && mouseY > this.y && mouseY < this.y + 14) {
                this.durationText.func_146195_b(true);
                this.durationText.func_146202_e();
                this.durationText.func_146199_i(0);
            }
            if (mouseX > GuiPotionMaker.this.getGuiLeft() + 160 && mouseX < GuiPotionMaker.this.getGuiLeft() + 176 && mouseY > this.y && mouseY < this.y + 14) {
                boolean showParticles = this.potionEffect.func_188418_e();
                boolean ambient = this.potionEffect.func_82720_e();
                if (showParticles && !ambient) {
                    ambient = true;
                } else if (showParticles && ambient) {
                    showParticles = false;
                    ambient = false;
                } else {
                    showParticles = true;
                    ambient = false;
                }
                this.setPotionEffect(new PotionEffect(this.potionEffect.func_188419_a(), this.potionEffect.func_76459_b(), this.potionEffect.func_76458_c(), ambient, showParticles));
                GuiPotionMaker.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                GuiPotionMaker.this.updatePotionEffects();
            }
        }

        private void onMouseClickedNotVisible() {
            if (this.amplifierText.func_146206_l()) {
                this.amplifierText.func_146195_b(false);
            }
            if (this.durationText.func_146206_l()) {
                this.durationText.func_146195_b(false);
            }
        }

        private boolean onKeyTyped(char typedChar, int keyCode) {
            return this.amplifierText.func_146201_a(typedChar, keyCode) || this.durationText.func_146201_a(typedChar, keyCode);
        }

        private void onDrawScreen(int mouseX, int mouseY, int x, int y, float partialTicks) {
            this.amplifierText.field_146210_g = this.durationText.field_146210_g = y + 3;
            this.amplifierText.field_146209_f = GuiPotionMaker.this.getGuiLeft() + 98;
            this.durationText.field_146209_f = GuiPotionMaker.this.getGuiLeft() + 121;
            this.y = y;
            GlStateManager.func_179140_f();
            if (this.potionEffectEnabled) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiPotionMaker.this.field_146297_k.func_110434_K().func_110577_a(POTION_MAKER_GUI_TEXTURE);
                GuiPotionMaker.this.func_73729_b(x, y, 0, 223, 164, 14);
            }
            this.amplifierText.func_146193_g(this.potionEffectEnabled ? 0xFFFFFF : 0x888888);
            this.amplifierText.func_146194_f();
            this.durationText.func_146193_g(this.potionEffectEnabled ? 0xFFFFFF : 0x888888);
            this.durationText.func_146194_f();
            String displayPotionName = CommonGuiStuff.trimWithDots(GuiPotionMaker.this.field_146289_q, I18n.func_135052_a((String)this.potionEffect.func_76453_d(), (Object[])new Object[0]), 106);
            GuiPotionMaker.this.field_146289_q.func_175063_a(displayPotionName, (float)(x + 2), (float)(y + 3), this.potionEffectEnabled ? 0xFFFFFF : 0x888888);
            boolean showParticles = this.potionEffect.func_188418_e();
            boolean ambient = this.potionEffect.func_82720_e();
            int offset = 0;
            if (!showParticles) {
                offset = 24;
            } else if (ambient) {
                offset = 12;
            }
            float shade = this.potionEffectEnabled ? 1.0f : 0.5f;
            GlStateManager.func_179131_c((float)shade, (float)shade, (float)shade, (float)1.0f);
            GuiPotionMaker.this.field_146297_k.func_110434_K().func_110577_a(POTION_MAKER_GUI_TEXTURE);
            GuiPotionMaker.this.func_73729_b(x + 151, y + 1, 29 + offset, 237, 12, 12);
        }

        private void onRenderHoveredToolTip(int mouseX, int mouseY) {
            if (mouseX > GuiPotionMaker.this.getGuiLeft() + 160 && mouseX < GuiPotionMaker.this.getGuiLeft() + 176 && mouseY > this.y && mouseY < this.y + 14) {
                ArrayList<String> hoverInfo = new ArrayList<String>();
                boolean showParticles = this.potionEffect.func_188418_e();
                boolean ambient = this.potionEffect.func_82720_e();
                String particleType = !showParticles ? "none" : (ambient ? "faded" : "normal");
                hoverInfo.add(I18n.func_135052_a((String)("gui.potion_maker.particleType." + particleType), (Object[])new Object[0]));
                hoverInfo.add("");
                hoverInfo.add(I18n.func_135052_a((String)"gui.clickToCycle", (Object[])new Object[0]));
                GuiPotionMaker.this.func_146283_a(hoverInfo, mouseX, mouseY);
            }
        }

        private void onAmplifierChanged(String newText) {
            byte amplifier = 0;
            if (!newText.isEmpty()) {
                try {
                    int intAmplifier = Integer.valueOf(newText);
                    amplifier = (byte)MathHelper.func_76125_a((int)intAmplifier, (int)0, (int)127);
                }
                catch (NumberFormatException e) {
                    MapGadgetsMod.logger.warn("Tried to parse invalid potion amplifier:", (Throwable)e);
                }
            }
            this.potionEffect = new PotionEffect(this.potionEffect.func_188419_a(), this.potionEffect.func_76459_b(), (int)amplifier, this.potionEffect.func_82720_e(), this.potionEffect.func_188418_e());
            GuiPotionMaker.this.updatePotionEffects();
        }

        private void onDurationChanged(String newText) {
            int duration = 0;
            if (!newText.isEmpty()) {
                try {
                    long longDuration = Long.valueOf(newText);
                    duration = (int)MathHelper.func_76131_a((float)longDuration, (float)0.0f, (float)2.1474836E9f);
                }
                catch (NumberFormatException e) {
                    MapGadgetsMod.logger.warn("Tried to parse invalid potion duration:", (Throwable)e);
                }
            }
            this.potionEffectEnabled = duration != 0;
            this.potionEffect = new PotionEffect(this.potionEffect.func_188419_a(), duration, this.potionEffect.func_76458_c(), this.potionEffect.func_82720_e(), this.potionEffect.func_188418_e());
            GuiPotionMaker.this.updatePotionEffects();
        }
    }
}

