/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.container;

import com.tmtravlr.mapgadgets.items.ItemTradeEditor;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerTradeEditor
extends Container {
    private static final Random RAND = new Random();
    public static final String INFINITE_TRADES_TAG = "Mapmaker's Gadgets - Infinite Trades";
    public IInventory tradeInventory;
    public SlotTrade tradeInput1;
    public SlotTrade tradeInput2;
    public SlotTrade tradeOutput;
    public final World world;
    public final EntityVillager villager;
    private MerchantRecipeList recipesEditing;
    private int selectedRecipe;
    private boolean infiniteTrades;

    public ContainerTradeEditor(InventoryPlayer playerInventory, int villagerId, int infiniteTrades) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
        this.tradeInventory = new InventoryBasic("Item", false, 3);
        this.tradeInput1 = new SlotTrade(this.tradeInventory, 0, 36, 53);
        this.tradeInput2 = new SlotTrade(this.tradeInventory, 1, 62, 53);
        this.tradeOutput = new SlotTrade(this.tradeInventory, 2, 120, 54);
        this.func_75146_a(this.tradeInput1);
        this.func_75146_a(this.tradeInput2);
        this.func_75146_a(this.tradeOutput);
        this.world = playerInventory.field_70458_d.field_70170_p;
        Entity villagerEntity = this.world.func_73045_a(villagerId);
        if (!(villagerEntity instanceof EntityVillager)) {
            throw new IllegalArgumentException("Trying to open the villager trade editor with no villager.");
        }
        this.villager = (EntityVillager)villagerEntity;
        boolean bl = this.infiniteTrades = infiniteTrades != 0;
        if (!this.world.field_72995_K) {
            this.recipesEditing = this.villager.func_70934_b(playerInventory.field_70458_d);
            this.changeRecipe(0);
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.world.field_72995_K) {
            MerchantRecipeList validRecipes = new MerchantRecipeList();
            for (MerchantRecipe recipe : this.recipesEditing) {
                if (recipe.func_77397_d().func_190926_b() || recipe.func_77394_a().func_190926_b()) continue;
                validRecipes.add((Object)recipe);
            }
            NBTTagCompound villagerTag = this.villager.func_189511_e(new NBTTagCompound());
            villagerTag.func_74768_a("CareerLevel", 1000);
            villagerTag.func_74782_a("Offers", (NBTBase)validRecipes.func_77202_a());
            this.villager.func_70020_e(villagerTag);
            ItemStack tradeEditor = ItemStack.field_190927_a;
            if (player.func_184614_ca().func_77973_b() instanceof ItemTradeEditor) {
                tradeEditor = player.func_184614_ca();
            } else if (player.func_184592_cb().func_77973_b() instanceof ItemTradeEditor) {
                tradeEditor = player.func_184592_cb();
            }
            if (!tradeEditor.func_190926_b()) {
                ItemTradeEditor.setVillagerTag(tradeEditor, this.villager);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return player.func_189808_dh();
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index >= 0 && index < 27 ? !this.func_75135_a(itemstack1, 27, 36, false) : index >= 27 && index < 36 && !this.func_75135_a(itemstack1, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(player, itemstack1);
            if (index == 0) {
                player.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    public void setInfiniteTrades(boolean infiniteTrades) {
        this.infiniteTrades = infiniteTrades;
        this.villager.getEntityData().func_74757_a(INFINITE_TRADES_TAG, infiniteTrades);
        if (!this.recipesEditing.isEmpty()) {
            for (int i = 0; i < this.recipesEditing.size(); ++i) {
                int maxUses = this.infiniteTrades ? 1000000000 : RAND.nextInt(11) + 2;
                MerchantRecipe recipe = (MerchantRecipe)this.recipesEditing.get(i);
                this.recipesEditing.set(i, (Object)new MerchantRecipe(recipe.func_77394_a(), recipe.func_77396_b(), recipe.func_77397_d(), 0, maxUses));
            }
        }
    }

    public void setNameInvulnerable(String customName, boolean invulnerable) {
        this.villager.func_96094_a(customName);
        this.villager.func_184224_h(invulnerable);
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSelectedRecipe(int selectedRecipe) {
        this.selectedRecipe = selectedRecipe;
    }

    public void changeRecipe(int selectedRecipe) {
        this.selectedRecipe = MathHelper.func_76125_a((int)selectedRecipe, (int)0, (int)this.recipesEditing.size());
        if (this.selectedRecipe == this.recipesEditing.size()) {
            this.recipesEditing.add((Object)new MerchantRecipe(ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, 0, this.infiniteTrades ? 1000000000 : 7));
        }
        MerchantRecipe recipe = (MerchantRecipe)this.recipesEditing.get(this.selectedRecipe);
        this.tradeInput1.func_75215_d(recipe.func_77394_a().func_77946_l());
        this.tradeInput2.func_75215_d(recipe.func_77396_b().func_77946_l());
        this.tradeOutput.func_75215_d(recipe.func_77397_d().func_77946_l());
    }

    private void onRecipeChanged(Slot slot) {
        if (!this.world.field_72995_K) {
            MerchantRecipe recipe = (MerchantRecipe)this.recipesEditing.get(this.selectedRecipe);
            this.recipesEditing.set(this.selectedRecipe, (Object)new MerchantRecipe(this.tradeInput1.func_75211_c().func_77946_l(), this.tradeInput2.func_75211_c().func_77946_l(), this.tradeOutput.func_75211_c().func_77946_l(), recipe.func_180321_e(), recipe.func_180320_f()));
        }
    }

    private class SlotTrade
    extends Slot {
        public SlotTrade(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            this.func_75215_d(stack.func_77946_l());
            ContainerTradeEditor.this.onRecipeChanged(this);
            return false;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            this.func_75215_d(ItemStack.field_190927_a);
            ContainerTradeEditor.this.onRecipeChanged(this);
            return false;
        }
    }
}

