/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.container;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.items.ItemSpawnerEditor;
import com.tmtravlr.mapgadgets.network.SToCMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerSpawnerEditor
extends Container {
    private static final Random RAND = new Random();
    public IInventory spawnEggInventory;
    public SlotSpawnEgg[] spawnEggSlots = new SlotSpawnEgg[9];
    public final EntityPlayer player;
    public final TileEntityMobSpawner spawner;
    public short spawnCount = (short)-1;
    public short maxNearbyEntities = (short)-1;
    public short spawnRange = (short)-1;
    public short requiredPlayerRange = (short)-1;
    public short delay = (short)-1;
    public short minDelay = (short)-1;
    public short maxDelay = (short)-1;

    public ContainerSpawnerEditor(InventoryPlayer playerInventory, int x, int y, int z) {
        int i;
        this.player = playerInventory.field_70458_d;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 28 + j * 18, 112 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 28 + k * 18, 170));
        }
        this.spawnEggInventory = new InventoryBasic("Spawn Egg", false, 9);
        for (i = 0; i < 9; ++i) {
            int slotX = 11 + i % 3 * 18;
            int slotY = 20 + MathHelper.func_76141_d((float)(i / 3)) * 18;
            this.spawnEggSlots[i] = new SlotSpawnEgg(this.spawnEggInventory, i, slotX, slotY);
            this.func_75146_a(this.spawnEggSlots[i]);
        }
        TileEntity te = this.player.field_70170_p.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntityMobSpawner)) {
            throw new IllegalArgumentException("Trying to open the spawner editor with no spawner.");
        }
        this.spawner = (TileEntityMobSpawner)te;
        if (!this.player.field_70170_p.field_72995_K) {
            this.loadEntitySpawns();
            if (this.player instanceof EntityPlayerMP) {
                this.loadSpawnerStats((EntityPlayerMP)this.player);
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            this.saveEntitySpawns();
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return player.func_189808_dh();
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index >= 0 && index < 27 ? !this.func_75135_a(itemstack1, 27, 36, false) : index >= 27 && index < 36 && !this.func_75135_a(itemstack1, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(player, itemstack1);
            if (index == 0) {
                player.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    private void loadSpawnerStats(EntityPlayerMP player) {
        NBTTagCompound spawnerTag = this.spawner.func_189515_b(new NBTTagCompound());
        this.spawnCount = spawnerTag.func_74765_d("SpawnCount");
        this.maxNearbyEntities = spawnerTag.func_74765_d("MaxNearbyEntities");
        this.spawnRange = spawnerTag.func_74765_d("SpawnRange");
        this.requiredPlayerRange = spawnerTag.func_74765_d("RequiredPlayerRange");
        this.delay = spawnerTag.func_74765_d("Delay");
        this.minDelay = spawnerTag.func_74765_d("MinSpawnDelay");
        this.maxDelay = spawnerTag.func_74765_d("MaxSpawnDelay");
        PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
        buff.writeInt(0);
        buff.writeShort((int)this.spawnCount);
        buff.writeShort((int)this.maxNearbyEntities);
        buff.writeShort((int)this.spawnRange);
        buff.writeShort((int)this.requiredPlayerRange);
        buff.writeShort((int)this.delay);
        buff.writeShort((int)this.minDelay);
        buff.writeShort((int)this.maxDelay);
        SToCMessage packet = new SToCMessage((ByteBuf)buff);
        MapGadgetsMod.networkWrapper.sendTo((IMessage)packet, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void loadSpawnerStats(PacketBuffer buff) {
        this.spawnCount = buff.readShort();
        this.maxNearbyEntities = buff.readShort();
        this.spawnRange = buff.readShort();
        this.requiredPlayerRange = buff.readShort();
        this.delay = buff.readShort();
        this.minDelay = buff.readShort();
        this.maxDelay = buff.readShort();
    }

    private void loadEntitySpawns() {
        NBTTagCompound spawnerTag = this.spawner.func_189515_b(new NBTTagCompound());
        NBTTagList spawnPotentials = spawnerTag.func_150295_c("SpawnPotentials", 10);
        if (spawnPotentials.func_82582_d()) {
            if (spawnerTag.func_150297_b("SpawnData", 10)) {
                this.spawnEggSlots[0].func_75215_d(this.createSpawnEgg(spawnerTag.func_74775_l("SpawnData")));
            } else {
                NBTTagCompound defaultPig = new NBTTagCompound();
                defaultPig.func_74778_a("id", "minecraft:pig");
                this.spawnEggSlots[0].func_75215_d(this.createSpawnEgg(defaultPig));
            }
        } else {
            for (int i = 0; i < spawnPotentials.func_74745_c() && i < this.spawnEggSlots.length; ++i) {
                this.spawnEggSlots[i].func_75215_d(this.createSpawnEgg(spawnPotentials.func_150305_b(i).func_74775_l("Entity")));
            }
        }
    }

    private ItemStack createSpawnEgg(NBTTagCompound entityTag) {
        ItemStack stack = new ItemStack(Items.field_151063_bx);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74782_a("EntityTag", (NBTBase)entityTag);
        if (entityTag.func_74764_b("CustomName")) {
            stack.func_151001_c(entityTag.func_74779_i("CustomName"));
        }
        return stack;
    }

    private void saveEntitySpawns() {
        List<NBTTagCompound> spawnDataList = Arrays.stream(this.spawnEggSlots).filter(slot -> slot.func_75211_c().func_77942_o() && slot.func_75211_c().func_77978_p().func_150297_b("EntityTag", 10)).map(slot -> slot.func_75211_c().func_77978_p().func_74775_l("EntityTag")).collect(Collectors.toList());
        if (spawnDataList.isEmpty()) {
            NBTTagCompound defaultPig = new NBTTagCompound();
            defaultPig.func_74778_a("id", "minecraft:pig");
            spawnDataList.add(defaultPig);
        }
        NBTTagCompound spawnerTag = this.spawner.func_189515_b(new NBTTagCompound());
        spawnerTag.func_74782_a("SpawnData", (NBTBase)spawnDataList.get(0));
        NBTTagList spawnPotentials = new NBTTagList();
        spawnDataList.forEach(entityTag -> {
            NBTTagCompound potentialTag = new NBTTagCompound();
            potentialTag.func_74782_a("Entity", (NBTBase)entityTag);
            potentialTag.func_74768_a("Weight", 1);
            spawnPotentials.func_74742_a((NBTBase)potentialTag);
        });
        spawnerTag.func_74782_a("SpawnPotentials", (NBTBase)spawnPotentials);
        this.spawner.func_145839_a(spawnerTag);
        ItemStack stack = ItemSpawnerEditor.getHeldSpawnerEditor(this.player);
        if (!stack.func_190926_b()) {
            ItemSpawnerEditor.saveSpawnerToItem(stack, this.spawner);
        }
    }

    private class SlotSpawnEgg
    extends Slot {
        public SlotSpawnEgg(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack.func_77973_b() == Items.field_151063_bx) {
                ItemStack toPut = stack.func_77946_l();
                toPut.func_190920_e(1);
                this.func_75215_d(toPut);
            }
            return false;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            this.func_75215_d(ItemStack.field_190927_a);
            return false;
        }
    }
}

