/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.mapgadgets.container;

import com.tmtravlr.mapgadgets.MapGadgetsMod;
import com.tmtravlr.mapgadgets.network.SToCMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerEntityEditor
extends Container {
    private final IInventory equipmentInventory;
    public final Entity entity;
    public final Slot slotMainhand;
    public final Slot slotOffhand;
    public final Slot slotHead;
    public final Slot slotChest;
    public final Slot slotLegs;
    public final Slot slotFeet;
    public boolean enableEquipmentSlots = false;

    public ContainerEntityEditor(InventoryPlayer playerInventory, int entityId) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 133 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 191));
        }
        this.equipmentInventory = new InventoryBasic("Equipment", false, 6);
        this.slotMainhand = new SlotEquipment(this.equipmentInventory, 0, 58, 63);
        this.slotOffhand = new SlotEquipment(this.equipmentInventory, 1, 58, 81);
        this.slotHead = new SlotEquipment(this.equipmentInventory, 2, 116, 45);
        this.slotChest = new SlotEquipment(this.equipmentInventory, 3, 116, 63);
        this.slotLegs = new SlotEquipment(this.equipmentInventory, 4, 116, 81);
        this.slotFeet = new SlotEquipment(this.equipmentInventory, 5, 116, 99);
        this.func_75146_a(this.slotMainhand);
        this.func_75146_a(this.slotOffhand);
        this.func_75146_a(this.slotHead);
        this.func_75146_a(this.slotChest);
        this.func_75146_a(this.slotLegs);
        this.func_75146_a(this.slotFeet);
        World world = playerInventory.field_70458_d.field_70170_p;
        this.entity = world.func_73045_a(entityId);
        if (this.entity == null || this.entity instanceof EntityPlayer) {
            throw new IllegalArgumentException("Entity editor needs a non-player entity");
        }
        if (!this.entity.field_70170_p.field_72995_K && playerInventory.field_70458_d instanceof EntityPlayerMP) {
            this.loadFromEntity((EntityPlayerMP)playerInventory.field_70458_d);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return player.func_189808_dh();
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index >= 0 && index < 27 ? !this.func_75135_a(itemstack1, 27, 36, false) : index >= 27 && index < 36 && !this.func_75135_a(itemstack1, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(player, itemstack1);
            if (index == 0) {
                player.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    private void loadFromEntity(EntityPlayerMP player) {
        PacketBuffer buff = new PacketBuffer(Unpooled.buffer());
        buff.writeInt(1);
        buff.writeBoolean(this.entity.func_190530_aW());
        buff.writeBoolean(this.entity.func_184202_aL());
        SToCMessage packet = new SToCMessage((ByteBuf)buff);
        MapGadgetsMod.networkWrapper.sendTo((IMessage)packet, player);
        if (this.entity instanceof EntityLiving) {
            EntityLiving mob = (EntityLiving)this.entity;
            NBTTagCompound mobTag = new NBTTagCompound();
            mob.func_70014_b(mobTag);
            buff = new PacketBuffer(Unpooled.buffer());
            buff.writeInt(2);
            String deathLootTable = mobTag.func_74779_i("DeathLootTable");
            buff.func_180714_a(deathLootTable.isEmpty() || deathLootTable.equals("minecraft:") ? "" : deathLootTable);
            buff.writeLong(mobTag.func_74763_f("DeathLootTableSeed"));
            buff.writeBoolean(mob.func_98052_bS());
            buff.writeBoolean(mob.func_104002_bU());
            buff.writeBoolean(mob.func_175446_cd());
            packet = new SToCMessage((ByteBuf)buff);
            MapGadgetsMod.networkWrapper.sendTo((IMessage)packet, player);
            NBTTagList handDropChances = mobTag.func_150295_c("HandDropChances", 5);
            NBTTagList armorDropChances = mobTag.func_150295_c("ArmorDropChances", 5);
            buff = new PacketBuffer(Unpooled.buffer());
            buff.writeInt(3);
            buff.writeFloat(handDropChances.func_150308_e(0));
            buff.writeFloat(handDropChances.func_150308_e(1));
            buff.writeFloat(armorDropChances.func_150308_e(0));
            buff.writeFloat(armorDropChances.func_150308_e(1));
            buff.writeFloat(armorDropChances.func_150308_e(2));
            buff.writeFloat(armorDropChances.func_150308_e(3));
            this.slotMainhand.func_75215_d(mob.func_184586_b(EnumHand.MAIN_HAND));
            this.slotOffhand.func_75215_d(mob.func_184586_b(EnumHand.OFF_HAND));
            this.slotHead.func_75215_d(mob.func_184582_a(EntityEquipmentSlot.HEAD));
            this.slotChest.func_75215_d(mob.func_184582_a(EntityEquipmentSlot.CHEST));
            this.slotLegs.func_75215_d(mob.func_184582_a(EntityEquipmentSlot.LEGS));
            this.slotFeet.func_75215_d(mob.func_184582_a(EntityEquipmentSlot.FEET));
            packet = new SToCMessage((ByteBuf)buff);
            MapGadgetsMod.networkWrapper.sendTo((IMessage)packet, player);
            buff = new PacketBuffer(Unpooled.buffer());
            buff.writeInt(4);
            buff.writeInt(mob.func_110140_aT().func_111146_a().size());
            for (IAttributeInstance attributeInstance : mob.func_110140_aT().func_111146_a()) {
                buff.func_180714_a(attributeInstance.func_111123_a().func_111108_a());
                buff.writeDouble(attributeInstance.func_111125_b());
            }
            packet = new SToCMessage((ByteBuf)buff);
            MapGadgetsMod.networkWrapper.sendTo((IMessage)packet, player);
        }
    }

    public void updateEntityStats(PacketBuffer buff) {
        this.entity.func_96094_a(buff.func_150789_c(1000));
        this.entity.func_174805_g(buff.readBoolean());
        this.entity.func_184224_h(buff.readBoolean());
        this.entity.func_174810_b(buff.readBoolean());
        this.entity.func_184195_f(buff.readBoolean());
        this.entity.func_189654_d(buff.readBoolean());
    }

    public void updateMobStats(PacketBuffer buff) {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            NBTTagCompound entityTag = entityLiving.func_189511_e(new NBTTagCompound());
            entityTag.func_74778_a("DeathLootTable", buff.func_150789_c(1000));
            entityTag.func_74772_a("DeathLootTableSeed", buff.readLong());
            entityTag.func_74757_a("NoAI", buff.readBoolean());
            boolean invisible = buff.readBoolean();
            entityTag.func_74757_a("CanPickUpLoot", buff.readBoolean());
            entityTag.func_74757_a("PersistenceRequired", buff.readBoolean());
            entityLiving.func_70020_e(entityTag);
            entityLiving.func_82142_c(invisible);
            if (invisible && !entityLiving.func_70644_a(MobEffects.field_76441_p)) {
                entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76441_p, Integer.MAX_VALUE, 0, false, false));
            } else if (!invisible && entityLiving.func_70644_a(MobEffects.field_76441_p)) {
                entityLiving.func_184589_d(MobEffects.field_76441_p);
            }
        }
    }

    public void updateEquipment(PacketBuffer buff) {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            entityLiving.func_184642_a((EntityEquipmentSlot)buff.func_179257_a(EntityEquipmentSlot.class), buff.readFloat());
        }
    }

    public void updateAttributes(PacketBuffer buff) {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            String attributeName = buff.func_150789_c(1000);
            double attributeBase = buff.readDouble();
            IAttributeInstance attributeInstance = entityLiving.func_110140_aT().func_111152_a(attributeName);
            if (attributeInstance != null) {
                attributeInstance.func_111128_a(attributeBase);
            }
            if (SharedMonsterAttributes.field_111267_a.func_111108_a().equals(attributeName)) {
                entityLiving.func_70606_j(entityLiving.func_110138_aP());
            }
        }
    }

    private void updateEntityEquipment(Slot slot) {
        if (this.entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)this.entity;
            if (slot == this.slotMainhand) {
                entityLiving.func_184611_a(EnumHand.MAIN_HAND, slot.func_75211_c());
            } else if (slot == this.slotOffhand) {
                entityLiving.func_184611_a(EnumHand.OFF_HAND, slot.func_75211_c());
            } else if (slot == this.slotHead) {
                entityLiving.func_184201_a(EntityEquipmentSlot.HEAD, slot.func_75211_c());
            } else if (slot == this.slotChest) {
                entityLiving.func_184201_a(EntityEquipmentSlot.CHEST, slot.func_75211_c());
            } else if (slot == this.slotLegs) {
                entityLiving.func_184201_a(EntityEquipmentSlot.LEGS, slot.func_75211_c());
            } else if (slot == this.slotFeet) {
                entityLiving.func_184201_a(EntityEquipmentSlot.FEET, slot.func_75211_c());
            }
        }
    }

    private class SlotEquipment
    extends Slot {
        public SlotEquipment(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(ItemStack stack) {
            this.func_75215_d(stack.func_77946_l());
            ContainerEntityEditor.this.updateEntityEquipment(this);
            return false;
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            this.func_75215_d(ItemStack.field_190927_a);
            ContainerEntityEditor.this.updateEntityEquipment(this);
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return ContainerEntityEditor.this.enableEquipmentSlots;
        }
    }
}

