/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.world.storage;

import com.google.common.collect.Sets;
import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.event.EndPortalEvent;
import com.therandomlabs.randomportals.api.event.NetherPortalEvent;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.netherportal.FunctionType;
import com.therandomlabs.randomportals.api.netherportal.NetherPortal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RPOSavedData
extends WorldSavedData {
    public static final String ID = "randomportals";
    public static final String NETHER_PORTALS_KEY = "NetherPortals";
    public static final String FRAME_KEY = "Frame";
    public static final String RECEIVING_FRAME_KEY = "ReceivingFrame";
    public static final String PORTAL_TYPE_KEY = "PortalType";
    public static final String FUNCTION_TYPE_KEY = "FunctionType";
    public static final String FRAME_TYPE_KEY = "FrameType";
    public static final String TOP_LEFT_KEY = "TopLeft";
    public static final String WIDTH_KEY = "Width";
    public static final String HEIGHT_KEY = "Height";
    public static final String DESTINATION_KEY = "Destination";
    public static final String GENERATED_NETHER_PORTAL_FRAMES_KEY = "GeneratedNetherPortalFrames";
    public static final String END_PORTALS_KEY = "EndPortals";
    private static final FrameType[] TYPES = FrameType.values();
    private static final FunctionType[] FUNCTION_TYPES = FunctionType.values();
    private static World currentWorld;
    private final Map<BlockPos, NetherPortal> netherPortals = new HashMap<BlockPos, NetherPortal>();
    private final Map<String, Set<BlockPos>> generatedNetherPortalFrames = new HashMap<String, Set<BlockPos>>();
    private final Map<BlockPos, Frame> endPortals = new HashMap<BlockPos, Frame>();
    private final World world = currentWorld;

    public RPOSavedData() {
        this(ID);
    }

    public RPOSavedData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        Frame frame;
        this.netherPortals.clear();
        this.generatedNetherPortalFrames.clear();
        this.endPortals.clear();
        for (NBTBase tag : nbt.func_150295_c(NETHER_PORTALS_KEY, 10)) {
            NBTTagCompound compound = (NBTTagCompound)tag;
            frame = RPOSavedData.readFrame(this.world, compound.func_74775_l(FRAME_KEY));
            if (frame == null) continue;
            Frame receivingFrame = RPOSavedData.readFrame(this.world, compound.func_74775_l(RECEIVING_FRAME_KEY));
            PortalType type = PortalTypes.getSpecific(compound.func_74779_i(PORTAL_TYPE_KEY));
            FunctionType functionType = FUNCTION_TYPES[compound.func_74762_e(FUNCTION_TYPE_KEY)];
            int destination = compound.func_74764_b(DESTINATION_KEY) ? compound.func_74762_e(DESTINATION_KEY) : Integer.MIN_VALUE;
            this.netherPortals.put(frame.getTopLeft(), new NetherPortal(frame, receivingFrame, type, functionType, destination));
        }
        NBTTagCompound compound = nbt.func_74775_l(GENERATED_NETHER_PORTAL_FRAMES_KEY);
        for (String typeID : compound.func_150296_c()) {
            NBTTagList list = compound.func_150295_c(typeID, 10);
            HashSet<BlockPos> positions = new HashSet<BlockPos>(list.func_74745_c());
            for (NBTBase tag : list) {
                positions.add(NBTUtil.func_186861_c((NBTTagCompound)((NBTTagCompound)tag)));
            }
            this.generatedNetherPortalFrames.merge(PortalTypes.getSpecific(typeID).toString(), positions, (a, b) -> {
                a.addAll(b);
                return a;
            });
        }
        for (NBTBase tag : nbt.func_150295_c(END_PORTALS_KEY, 10)) {
            frame = RPOSavedData.readFrame(this.world, (NBTTagCompound)tag);
            this.endPortals.put(frame.getTopLeft(), frame);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList netherPortalList = new NBTTagList();
        for (NetherPortal netherPortal : this.netherPortals.values()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = RPOSavedData.writeFrame(new NBTTagCompound(), netherPortal.getFrame());
            NBTTagCompound receivingFrame = RPOSavedData.writeFrame(new NBTTagCompound(), netherPortal.getReceivingFrame());
            nBTTagCompound.func_74782_a(FRAME_KEY, (NBTBase)nBTTagCompound2);
            nBTTagCompound.func_74782_a(RECEIVING_FRAME_KEY, (NBTBase)receivingFrame);
            nBTTagCompound.func_74778_a(PORTAL_TYPE_KEY, netherPortal.getType().toString());
            nBTTagCompound.func_74768_a(FUNCTION_TYPE_KEY, netherPortal.getFunctionType().ordinal());
            if (netherPortal.getDestination() != Integer.MIN_VALUE) {
                nBTTagCompound.func_74768_a(DESTINATION_KEY, netherPortal.getDestination());
            }
            netherPortalList.func_74742_a((NBTBase)nBTTagCompound);
        }
        nbt.func_74782_a(NETHER_PORTALS_KEY, (NBTBase)netherPortalList);
        NBTTagCompound generatedPortalFramesTag = new NBTTagCompound();
        for (Map.Entry<String, Set<BlockPos>> entry : this.generatedNetherPortalFrames.entrySet()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (BlockPos pos : entry.getValue()) {
                nBTTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            }
            generatedPortalFramesTag.func_74782_a(PortalTypes.getSpecific(entry.getKey()).toString(), (NBTBase)nBTTagList);
        }
        nbt.func_74782_a(GENERATED_NETHER_PORTAL_FRAMES_KEY, (NBTBase)generatedPortalFramesTag);
        NBTTagList nBTTagList = new NBTTagList();
        for (Frame frame : this.endPortals.values()) {
            nBTTagList.func_74742_a((NBTBase)RPOSavedData.writeFrame(new NBTTagCompound(), frame));
        }
        nbt.func_74782_a(END_PORTALS_KEY, (NBTBase)nBTTagList);
        return nbt;
    }

    public Map<BlockPos, NetherPortal> getNetherPortals() {
        return this.netherPortals;
    }

    public NetherPortal getNetherPortalByInner(BlockPos portalPos) {
        return this.getNetherPortal(frame -> frame.isInnerBlock(portalPos), portalPos);
    }

    public NetherPortal getNetherPortalByFrame(BlockPos framePos) {
        return this.getNetherPortal(frame -> frame.isFrameBlock(framePos), framePos);
    }

    public NetherPortal getNetherPortalByTopLeft(BlockPos topLeft) {
        return this.netherPortals.get(topLeft);
    }

    public NetherPortal addNetherPortal(Frame frame, PortalType type, boolean userCreated) {
        NetherPortal portal = new NetherPortal(frame, null, type);
        this.addNetherPortal(portal, userCreated);
        return portal;
    }

    public void addNetherPortal(NetherPortal portal, boolean userCreated) {
        Frame frame = portal.getFrame();
        this.netherPortals.put(frame.getTopLeft(), portal);
        if (!userCreated) {
            this.generatedNetherPortalFrames.merge(portal.getType().toString(), new HashSet<BlockPos>((Collection<BlockPos>)frame.getFrameBlockPositions()), (a, b) -> {
                a.addAll(b);
                return a;
            });
        }
        this.func_76185_a();
        MinecraftForge.EVENT_BUS.post((Event)new NetherPortalEvent.Add(this.world, portal, userCreated));
    }

    public NetherPortal removeNetherPortalByInner(BlockPos portalPos) {
        return this.removeNetherPortal(frame -> frame.isInnerBlock(portalPos));
    }

    public NetherPortal removeNetherPortalByFrame(BlockPos framePos) {
        return this.removeNetherPortal(frame -> frame.isFrameBlock(framePos));
    }

    public NetherPortal removeNetherPortalByTopLeft(BlockPos topLeft) {
        return this.removeNetherPortal(frame -> topLeft.equals((Object)frame.getTopLeft()));
    }

    public void addGeneratedNetherPortalFrame(BlockPos framePos, PortalType portalType) {
        this.generatedNetherPortalFrames.merge(portalType.toString(), Sets.newHashSet((Object[])new BlockPos[]{framePos}), (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    public PortalType getGeneratedNetherPortalType(BlockPos framePos) {
        for (Map.Entry<String, Set<BlockPos>> entry : this.generatedNetherPortalFrames.entrySet()) {
            if (!entry.getValue().contains(framePos)) continue;
            return PortalTypes.getSpecific(entry.getKey());
        }
        return null;
    }

    public void removeGeneratedNetherPortalFramePos(String typeID, BlockPos framePos) {
        Set<BlockPos> positions = this.generatedNetherPortalFrames.get(typeID);
        if (positions != null) {
            this.func_76185_a();
        }
    }

    public Map<BlockPos, Frame> getEndPortals() {
        return this.endPortals;
    }

    public Frame getEndPortalByInner(BlockPos portalPos) {
        return this.getEndPortal(frame -> frame.isInnerBlock(portalPos), portalPos);
    }

    public Frame getEndPortalByFrame(BlockPos framePos) {
        return this.getEndPortal(frame -> frame.isFrameBlock(framePos), framePos);
    }

    public Frame getEndPortalByTopLeft(BlockPos topLeft) {
        return this.endPortals.get(topLeft);
    }

    public void addEndPortal(Frame frame) {
        this.endPortals.put(frame.getTopLeft(), frame);
        this.func_76185_a();
        MinecraftForge.EVENT_BUS.post((Event)new EndPortalEvent.Add(this.world, frame));
    }

    public Frame removeEndPortalByInner(BlockPos portalPos) {
        return this.removeEndPortal(frame -> frame.isInnerBlock(portalPos));
    }

    public Frame removeEndPortalByFrame(BlockPos framePos) {
        return this.removeEndPortal(frame -> frame.isFrameBlock(framePos));
    }

    public Frame removeEndPortalByTopLeft(BlockPos topLeft) {
        return this.removeEndPortal(frame -> topLeft.equals((Object)frame.getTopLeft()));
    }

    private NetherPortal getNetherPortal(Predicate<Frame> predicate, BlockPos pos) {
        for (NetherPortal portal : this.netherPortals.values()) {
            Frame frame = portal.getFrame();
            if (!predicate.test(frame)) continue;
            return portal;
        }
        return null;
    }

    private NetherPortal removeNetherPortal(Predicate<Frame> predicate) {
        for (Map.Entry<BlockPos, NetherPortal> entry : this.netherPortals.entrySet()) {
            NetherPortal portal = entry.getValue();
            if (!predicate.test(portal.getFrame())) continue;
            this.netherPortals.remove(entry.getKey());
            this.func_76185_a();
            MinecraftForge.EVENT_BUS.post((Event)new NetherPortalEvent.Remove(portal));
            return portal;
        }
        return null;
    }

    private Frame getEndPortal(Predicate<Frame> predicate, BlockPos pos) {
        for (Frame frame : this.endPortals.values()) {
            if (!predicate.test(frame)) continue;
            return frame;
        }
        return null;
    }

    private Frame removeEndPortal(Predicate<Frame> predicate) {
        for (Map.Entry<BlockPos, Frame> entry : this.endPortals.entrySet()) {
            Frame frame = entry.getValue();
            if (!predicate.test(frame)) continue;
            this.endPortals.remove(entry.getKey());
            this.func_76185_a();
            MinecraftForge.EVENT_BUS.post((Event)new EndPortalEvent.Remove(frame));
            return frame;
        }
        return null;
    }

    public static Frame readFrame(World world, NBTTagCompound compound) {
        int width = compound.func_74762_e(WIDTH_KEY);
        return width == 0 ? null : new Frame(world, TYPES[compound.func_74762_e(FRAME_TYPE_KEY)], NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(TOP_LEFT_KEY)), width, compound.func_74762_e(HEIGHT_KEY));
    }

    public static NBTTagCompound writeFrame(NBTTagCompound compound, Frame frame) {
        if (frame == null) {
            return compound;
        }
        compound.func_74768_a(FRAME_TYPE_KEY, frame.getType().ordinal());
        compound.func_74782_a(TOP_LEFT_KEY, (NBTBase)NBTUtil.func_186859_a((BlockPos)frame.getTopLeft()));
        compound.func_74768_a(WIDTH_KEY, frame.getWidth());
        compound.func_74768_a(HEIGHT_KEY, frame.getHeight());
        return compound;
    }

    public static RPOSavedData get(World world) {
        currentWorld = world;
        MapStorage storage = world.getPerWorldStorage();
        RPOSavedData instance = (RPOSavedData)storage.func_75742_a(RPOSavedData.class, ID);
        if (instance == null) {
            instance = new RPOSavedData();
            storage.func_75745_a(ID, (WorldSavedData)instance);
        }
        currentWorld = null;
        return instance;
    }
}

