/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.world;

import com.therandomlabs.randomportals.RandomPortals;
import com.therandomlabs.randomportals.api.config.DestinationData;
import com.therandomlabs.randomportals.api.config.FrameBlock;
import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.config.PortalType;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.event.NetherPortalEvent;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.netherportal.FunctionType;
import com.therandomlabs.randomportals.api.netherportal.NetherPortal;
import com.therandomlabs.randomportals.api.netherportal.NetherPortalActivator;
import com.therandomlabs.randomportals.api.netherportal.PortalBlockRegistry;
import com.therandomlabs.randomportals.api.netherportal.TeleportData;
import com.therandomlabs.randomportals.block.BlockNetherPortal;
import com.therandomlabs.randomportals.config.RPOConfig;
import com.therandomlabs.randomportals.frame.NetherPortalFrames;
import com.therandomlabs.randomportals.handler.NetherPortalTeleportHandler;
import com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.TRLUtils;
import com.therandomlabs.randomportals.world.storage.RPOSavedData;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomportals")
public class RPOTeleporter
extends Teleporter {
    private static Field worldTeleporter;
    private final int dimensionID;

    public RPOTeleporter(WorldServer world) {
        super(world);
        this.dimensionID = world.field_73011_w.getDimension();
    }

    public void func_180266_a(Entity entity, float yaw) {
        TeleportData data = NetherPortalTeleportHandler.getTeleportData(entity);
        if (data != null) {
            PortalType type = data.getPortalType();
            if (this.dimensionID == type.destination.dimensionID) {
                entity.field_70165_t *= type.destination.coordinateMultiplier;
                entity.field_70161_v *= type.destination.coordinateMultiplier;
            } else {
                entity.field_70165_t /= type.destination.coordinateMultiplier;
                entity.field_70161_v /= type.destination.coordinateMultiplier;
            }
            if (type.destination.teleportToPortal) {
                if (this.func_180620_b(entity, yaw)) {
                    return;
                }
                if ((RPOConfig.NetherPortals.allEntitiesCanCausePortalGeneration || entity instanceof EntityPlayerMP) && type.destination.generatePortalIfNotFound) {
                    this.func_85188_a(entity);
                    this.func_180620_b(entity, yaw);
                    return;
                }
            }
        }
        if (this.field_85192_a.field_73011_w.func_186058_p() != DimensionType.THE_END) {
            entity.func_174828_a(this.field_85192_a.func_175672_r(this.field_85192_a.func_175694_M()), yaw, entity.field_70127_C);
            return;
        }
        IBlockState obsidian = Blocks.field_150343_Z.func_176223_P();
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        BlockPos spawnPos = this.field_85192_a.func_180504_m();
        int x = spawnPos.func_177958_n();
        int y = spawnPos.func_177956_o() - 1;
        int z = spawnPos.func_177952_p();
        for (int zOffset = -2; zOffset < 3; ++zOffset) {
            for (int xOffset = -2; xOffset < 3; ++xOffset) {
                for (int yOffset = -1; yOffset < 3; ++yOffset) {
                    this.field_85192_a.func_175656_a(new BlockPos(x + xOffset, y + yOffset, z - zOffset), yOffset < 0 ? obsidian : air);
                }
            }
        }
        entity.func_70012_b((double)x, (double)y, (double)z, entity.field_70177_z, 0.0f);
        entity.field_70159_w = 0.0;
        entity.field_70181_x = 0.0;
        entity.field_70179_y = 0.0;
    }

    public boolean func_180620_b(Entity entity, float yaw) {
        EnumFacing forwards;
        double zOffset;
        double xOffset;
        Frame frame;
        boolean forceInitial;
        TeleportData data = NetherPortalTeleportHandler.getTeleportData(entity);
        NetherPortalEvent.Teleport.SearchingForDestination searching = new NetherPortalEvent.Teleport.SearchingForDestination(entity, data);
        if (MinecraftForge.EVENT_BUS.post((Event)searching)) {
            return true;
        }
        long entityChunkPos = ChunkPos.func_77272_a((int)MathHelper.func_76128_c((double)entity.field_70165_t), (int)MathHelper.func_76128_c((double)entity.field_70161_v));
        RPOSavedData savedData = RPOSavedData.get((World)this.field_85192_a);
        PortalType portalType = data.getPortalType();
        String groupID = portalType.group.toString();
        NetherPortal sendingPortal = data.getPortal();
        Frame receivingFrame = null;
        boolean bl = forceInitial = portalType.destination.locationDetectionBehavior == DestinationData.LocationDetectionBehavior.FORCE_INITIAL && this.dimensionID == portalType.destination.dimensionID;
        if ((forceInitial || RPOConfig.NetherPortals.persistentReceivingPortals) && sendingPortal != null) {
            receivingFrame = sendingPortal.getReceivingFrame();
        }
        NetherPortal receivingPortal = null;
        Teleporter.PortalPosition portalPos = null;
        if (receivingFrame != null) {
            for (BlockPos innerPos : receivingFrame.getInnerRowFromBottom(1)) {
                if (!PortalBlockRegistry.isPortal((World)this.field_85192_a, innerPos)) continue;
                portalPos = innerPos;
                break;
            }
            if (portalPos == null) {
                sendingPortal.setReceivingFrame(null);
                receivingFrame = null;
            } else {
                receivingPortal = RPOSavedData.get((World)this.field_85192_a).getNetherPortalByInner((BlockPos)portalPos);
                if (receivingPortal != null && !groupID.equals(receivingPortal.getType().group.toString())) {
                    sendingPortal.setReceivingFrame(null);
                    receivingFrame = null;
                }
            }
        }
        if (receivingFrame == null) {
            if (forceInitial) {
                return false;
            }
            Teleporter.PortalPosition cachedPos = (Teleporter.PortalPosition)this.field_85191_c.get(entityChunkPos);
            if (cachedPos == null) {
                portalPos = this.findExistingPortal(savedData, entity, groupID, portalType.destination.oneWay);
                if (portalPos == null) {
                    return false;
                }
                this.field_85191_c.put(entityChunkPos, (Object)new Teleporter.PortalPosition((Teleporter)this, (BlockPos)portalPos, this.field_85192_a.func_82737_E()));
            } else {
                portalPos = cachedPos;
                cachedPos.field_85087_d = this.field_85192_a.func_82737_E();
            }
        }
        BlockPos framePos = portalPos.func_177977_b();
        IBlockState frameState = this.field_85192_a.func_180495_p(framePos);
        if (PortalTypes.getValidBlocks().test((World)this.field_85192_a, framePos, frameState)) {
            Teleporter.PortalPosition required = portalPos;
            frame = NetherPortalFrames.ACTIVATED_FRAMES.detectWithCondition((World)this.field_85192_a, framePos, arg_0 -> RPOTeleporter.lambda$placeInExistingPortal$0((BlockPos)required, arg_0));
        } else {
            Tuple<Boolean, NetherPortal> entry = BlockNetherPortal.findFrame(NetherPortalFrames.ACTIVATED_FRAMES, (World)this.field_85192_a, (BlockPos)portalPos);
            frame = entry == null ? null : ((NetherPortal)entry.func_76340_b()).getFrame();
        }
        Teleporter.PortalPosition teleportPos = portalPos;
        if (frame == null) {
            xOffset = 0.0;
            zOffset = 0.0;
            forwards = EnumFacing.NORTH;
        } else {
            if (sendingPortal != null) {
                int sendingDimensionID;
                int receivingDestination;
                sendingPortal.setReceivingFrame(frame);
                if (receivingPortal == null) {
                    receivingPortal = savedData.getNetherPortalByInner((BlockPos)portalPos);
                }
                if (receivingPortal != null && (receivingDestination = receivingPortal.getType().getDestinationDimensionID(this.dimensionID)) == (sendingDimensionID = data.getSendingPortalWorld().field_73011_w.getDimension())) {
                    receivingPortal.setReceivingFrame(sendingPortal.getFrame());
                }
            }
            FrameType type = frame.getType();
            int width = frame.getWidth();
            BlockPos bottomLeft = frame.getBottomLeft();
            if (type.isVertical()) {
                if (type == FrameType.VERTICAL_X) {
                    xOffset = (double)width / 2.0;
                    zOffset = 0.75;
                    forwards = EnumFacing.SOUTH;
                } else {
                    xOffset = 0.75;
                    zOffset = (double)(-width) / 2.0 + 1.0;
                    forwards = EnumFacing.EAST;
                }
                teleportPos = bottomLeft.func_177984_a();
            } else {
                boolean invalid;
                int xOffsetInt;
                xOffset = (double)width / 2.0;
                zOffset = 0.5;
                forwards = EnumFacing.SOUTH;
                teleportPos = bottomLeft.func_177984_a();
                BlockPos actualPos = teleportPos.func_177965_g(xOffsetInt = (int)xOffset);
                boolean bl2 = invalid = RPOTeleporter.isSolidOrLiquid((World)this.field_85192_a, actualPos) || RPOTeleporter.isSolidOrLiquid((World)this.field_85192_a, actualPos.func_177984_a());
                if (!invalid && xOffset != (double)xOffsetInt) {
                    BlockPos east = actualPos.func_177974_f();
                    boolean bl3 = invalid = RPOTeleporter.isSolidOrLiquid((World)this.field_85192_a, east) || RPOTeleporter.isSolidOrLiquid((World)this.field_85192_a, east.func_177984_a());
                }
                if (invalid) {
                    xOffset = 0.5;
                    boolean found = false;
                    for (BlockPos pos : frame.getFrameBlockPositions()) {
                        BlockPos up = pos.func_177984_a();
                        if (RPOTeleporter.isSolidOrLiquid((World)this.field_85192_a, up) || RPOTeleporter.isSolidOrLiquid((World)this.field_85192_a, up.func_177984_a())) continue;
                        teleportPos = up;
                        found = true;
                        break;
                    }
                    if (!found) {
                        int x = actualPos.func_177958_n();
                        int y = actualPos.func_177956_o();
                        int z = actualPos.func_177952_p();
                        int maxY = RandomPortals.CUBIC_CHUNKS_INSTALLED ? y + RPOConfig.NetherPortals.portalSearchRadius : this.field_85192_a.func_72940_L();
                        ++y;
                        teleportPos = actualPos;
                        while (y <= maxY && (RPOTeleporter.isSolidOrLiquid((World)this.field_85192_a, (BlockPos)(teleportPos = new BlockPos(x, y, z))) || RPOTeleporter.isSolidOrLiquid((World)this.field_85192_a, teleportPos.func_177984_a()))) {
                            ++y;
                        }
                    }
                }
            }
        }
        double x = (double)teleportPos.func_177958_n() + xOffset;
        double y = teleportPos.func_177956_o();
        double z = (double)teleportPos.func_177952_p() + zOffset;
        float newYaw = yaw - (float)entity.func_174811_aO().func_176736_b() * 90.0f + (float)forwards.func_176736_b() * 90.0f;
        if (MinecraftForge.EVENT_BUS.post((Event)new NetherPortalEvent.Teleport.DestinationFound(entity, data, frame, x, y, z, newYaw, entity.field_70125_A))) {
            return true;
        }
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a(x, y, z, newYaw, entity.field_70125_A);
        } else {
            entity.func_70012_b(x, y, z, newYaw, entity.field_70125_A);
        }
        MinecraftForge.EVENT_BUS.post((Event)new NetherPortalEvent.Teleport.Post(entity, data, frame));
        return true;
    }

    public boolean func_85188_a(Entity entity) {
        int sendingDimensionID;
        BlockPos topLeft;
        boolean initial;
        int height;
        int width;
        FrameType type;
        boolean clone;
        TeleportData data = NetherPortalTeleportHandler.getTeleportData(entity);
        PortalType portalType = data.getPortalType();
        Frame frame = data.getFrame();
        boolean bl = clone = frame != null && portalType.destination.portalGenerationBehavior == DestinationData.PortalGenerationBehavior.CLONE;
        if (clone) {
            type = frame.getType();
            width = frame.getWidth();
            height = frame.getHeight();
        } else {
            List<FrameType> types = portalType.destination.generatedFrameType == FrameType.SAME ? (frame == null ? FrameType.LATERAL_OR_VERTICAL.getTypes() : (frame.getType() == FrameType.LATERAL ? FrameType.LATERAL.getTypes() : FrameType.VERTICAL.getTypes())) : portalType.destination.generatedFrameType.getTypes();
            type = types.get(this.field_77187_a.nextInt(types.size()));
            FrameSize size = portalType.destination.getGeneratedFrameSize(frame).get(type);
            width = size.minWidth == size.maxWidth ? size.maxWidth : this.field_77187_a.nextInt(size.maxWidth + 1 - size.minWidth) + size.minWidth;
            height = size.minHeight == size.maxHeight ? size.maxHeight : this.field_77187_a.nextInt(size.maxHeight + 1 - size.minHeight) + size.minHeight;
        }
        boolean oneWay = portalType.destination.oneWay;
        if (portalType.destination.portalGenerationBehavior == DestinationData.PortalGenerationBehavior.USE_RECEIVING_DIMENSION_PORTAL_TYPE) {
            portalType = portalType.group.getType(portalType.destination.dimensionID);
        }
        RPOSavedData savedData = RPOSavedData.get((World)this.field_85192_a);
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        DestinationData.LocationDetectionBehavior behavior = this.dimensionID == portalType.destination.dimensionID ? portalType.destination.locationDetectionBehavior : DestinationData.LocationDetectionBehavior.IGNORE_INITIAL;
        boolean bl2 = initial = behavior == DestinationData.LocationDetectionBehavior.FORCE_INITIAL || behavior == DestinationData.LocationDetectionBehavior.USE_INITIAL && savedData.getNetherPortals().isEmpty();
        if (initial) {
            topLeft = portalType.destination.initialLocation.toBlockPos((World)this.field_85192_a);
            if (type != FrameType.LATERAL) {
                topLeft = topLeft.func_177981_b(height - 1);
            }
        } else {
            topLeft = this.findTopLeft(savedData, entity, portalType, type, width, height, air);
        }
        World sendingWorld = data.getSendingPortalWorld();
        int receivingDestination = portalType.getDestinationDimensionID(this.dimensionID);
        Frame receivingFrame = receivingDestination == (sendingDimensionID = sendingWorld.field_73011_w.getDimension()) ? frame : null;
        Frame newFrame = new Frame((World)this.field_85192_a, type, topLeft, width, height);
        if (clone) {
            this.clone(portalType, newFrame, (List<BlockPos>)newFrame.getFrameBlockPositions(), frame.getFrameBlocks());
            this.clone(null, null, (List<BlockPos>)newFrame.getInnerBlockPositions(), frame.getInnerBlocks());
            if (initial && type == FrameType.LATERAL) {
                this.clearAbove(newFrame, air);
            }
            NetherPortal portal = new NetherPortal(newFrame, receivingFrame, portalType, oneWay ? FunctionType.ONE_WAY : null, portalType.destination.ensureReturnToSameDimension ? sendingDimensionID : Integer.MIN_VALUE);
            data.getPortal().setReceivingFrame(newFrame);
            RPOSavedData.get((World)this.field_85192_a).addNetherPortal(portal, false);
            return true;
        }
        for (BlockPos framePos : newFrame.getFrameBlockPositions()) {
            int index = this.field_77187_a.nextInt(portalType.frame.blocks.size());
            this.field_85192_a.func_180501_a(framePos, portalType.frame.blocks.get(index).getActualState(), 2);
        }
        for (BlockPos innerPos : newFrame.getInnerBlockPositions()) {
            this.field_85192_a.func_180501_a(innerPos, air, 2);
        }
        if (initial && type == FrameType.LATERAL) {
            this.clearAbove(newFrame, air);
        }
        BlockPos activationPos = topLeft.func_177972_a(type.getWidthDirection()).func_177972_a(type.getHeightDirection());
        NetherPortal portal = new NetherPortalActivator().forcePortalType(portalType).setUserCreated(false).setFunctionType(oneWay ? FunctionType.ONE_WAY : null).setDestination(portalType.destination.ensureReturnToSameDimension ? sendingDimensionID : Integer.MIN_VALUE).activate((World)this.field_85192_a, activationPos, null);
        portal.setReceivingFrame(receivingFrame);
        if (data.getPortal() != null) {
            data.getPortal().setReceivingFrame(newFrame);
        }
        return true;
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        this.func_180266_a(entity, yaw);
        NetherPortalTeleportHandler.clearTeleportData(entity);
    }

    public boolean isVanilla() {
        return false;
    }

    public boolean isValidPortalPosition(BlockPos.MutableBlockPos pos, int x, int y, int z, int platformWidth, int platformLength, int spaceHeight, FrameType type) {
        for (int widthOffset = 0; widthOffset < platformWidth; ++widthOffset) {
            for (int lengthOffset = 0; lengthOffset < platformLength; ++lengthOffset) {
                int offsetZ;
                Tuple<Integer, Integer> offsets = RPOTeleporter.getOffsets(type, widthOffset, lengthOffset);
                int offsetX = x + (Integer)offsets.func_76341_a();
                if (this.field_85192_a.func_175623_d((BlockPos)pos.func_181079_c(offsetX, y - 1, offsetZ = z + (Integer)offsets.func_76340_b())) || !this.field_85192_a.func_180495_p((BlockPos)pos).func_185904_a().func_76220_a()) {
                    return false;
                }
                for (int yOffset = 0; yOffset < spaceHeight; ++yOffset) {
                    if (this.field_85192_a.func_175623_d((BlockPos)pos.func_181079_c(offsetX, y + yOffset, offsetZ))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public BlockPos findExistingPortal(RPOSavedData savedData, Entity entity, String groupID, boolean oneWay) {
        String defaultGroupID = PortalTypes.getDefaultGroup().toString();
        BlockPos entityPos = new BlockPos(entity);
        int entityY = entityPos.func_177956_o();
        Tuple<Integer, Integer> yBounds = this.getYBounds(entityY);
        int minY = (Integer)yBounds.func_76341_a();
        int maxY = (Integer)yBounds.func_76340_b();
        BlockPos pos = null;
        double distanceSq = -1.0;
        BlockPos preferedPos = null;
        double preferedDistanceSq = -1.0;
        int radius = RPOConfig.NetherPortals.portalSearchRadius;
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                BlockPos portalPos = entityPos.func_177982_a(xOffset, maxY - 1 - entityY, zOffset);
                while (portalPos.func_177956_o() >= minY) {
                    BlockPos checkPos = portalPos.func_177977_b();
                    if (PortalBlockRegistry.isPortal((World)this.field_85192_a, portalPos)) {
                        FunctionType functionType;
                        NetherPortal portal = savedData.getNetherPortalByInner(portalPos);
                        FunctionType functionType2 = functionType = portal == null ? null : portal.getFunctionType();
                        if (!(functionType == FunctionType.DECORATIVE || oneWay && functionType != FunctionType.ONE_WAY || portal != null && !groupID.equals(portal.getType().group.toString()) || portal == null && !groupID.equals(defaultGroupID))) {
                            checkPos = portalPos.func_177977_b();
                            while (PortalBlockRegistry.isPortal((World)this.field_85192_a, checkPos)) {
                                portalPos = checkPos;
                                checkPos = checkPos.func_177977_b();
                            }
                            double newDistance = portalPos.func_177951_i((Vec3i)entityPos);
                            if (distanceSq == -1.0 || newDistance < distanceSq) {
                                distanceSq = newDistance;
                                pos = portalPos;
                            }
                            if (!(portal != null && portal.getReceivingFrame() != null || preferedDistanceSq != -1.0 && !(newDistance < preferedDistanceSq))) {
                                preferedPos = pos;
                            }
                        }
                    }
                    portalPos = checkPos;
                }
            }
        }
        return preferedPos == null ? pos : preferedPos;
    }

    private Tuple<Integer, Integer> getYBounds(int referenceY) {
        if (RandomPortals.CUBIC_CHUNKS_INSTALLED) {
            return new Tuple((Object)(referenceY - RPOConfig.NetherPortals.portalSearchRadius), (Object)(referenceY + RPOConfig.NetherPortals.portalSearchRadius));
        }
        return new Tuple((Object)0, (Object)this.field_85192_a.func_72940_L());
    }

    private void clone(PortalType portalType, Frame newFrame, List<BlockPos> newPositions, List<IBlockState> oldStates) {
        int size = Math.min(newPositions.size(), oldStates.size());
        for (int i = 0; i < size; ++i) {
            BlockPos newPos = newPositions.get(i);
            IBlockState oldState = oldStates.get(i);
            if (portalType != null && newFrame.isCorner(newPos) && oldState.func_177230_c() != Blocks.field_150350_a) {
                boolean valid = false;
                for (FrameBlock frameBlock : portalType.frame.blocks) {
                    if (!frameBlock.test(oldState)) continue;
                    valid = true;
                    break;
                }
                if (!valid) {
                    int index = this.field_77187_a.nextInt(portalType.frame.blocks.size());
                    this.field_85192_a.func_180501_a(newPos, portalType.frame.blocks.get(index).getActualState(), 2);
                    continue;
                }
            }
            this.field_85192_a.func_180501_a(newPos, oldState, 2);
        }
    }

    private BlockPos findTopLeft(RPOSavedData savedData, Entity entity, PortalType portalType, FrameType type, int width, int height, IBlockState air) {
        int portalX = 0;
        int portalY = 0;
        int portalZ = 0;
        int platformWidth = width;
        int platformLength = type == FrameType.LATERAL ? height : 3;
        int spaceHeight = type == FrameType.LATERAL ? 2 : height;
        int fallbackWidth = width == 3 ? 3 : 4;
        boolean fallbackLength = true;
        int fallbackSpaceHeight = type == FrameType.LATERAL ? 2 : 4;
        int entityX = (int)entity.field_70165_t;
        int entityY = (int)entity.field_70163_u;
        int entityZ = (int)entity.field_70161_v;
        double distanceSq = -1.0;
        int fallbackX = 0;
        int fallbackY = 0;
        int fallbackZ = 0;
        double fallbackDistanceSq = -1.0;
        Tuple<Integer, Integer> yBounds = this.getYBounds(entityY);
        int minY = (Integer)yBounds.func_76341_a();
        int maxY = (Integer)yBounds.func_76340_b();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int worldHeight = type == FrameType.LATERAL ? maxY - 1 : maxY - height;
        int radius = RPOConfig.NetherPortals.portalGenerationLocationSearchRadius;
        for (int checkX = entityX - radius; checkX <= entityX + radius; ++checkX) {
            double xDistance = (double)checkX + 0.5 - entity.field_70165_t;
            for (int checkZ = entityZ - radius; checkZ <= entityZ + radius; ++checkZ) {
                double zDistance = (double)checkZ + 0.5 - entity.field_70161_v;
                for (int checkY = worldHeight; checkY >= minY; --checkY) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)pos.func_181079_c(checkX, checkY, checkZ))) continue;
                    while (checkY > minY && this.field_85192_a.func_175623_d((BlockPos)pos.func_181079_c(checkX, checkY - 1, checkZ))) {
                        --checkY;
                    }
                    double yDistance = (double)checkY + 0.5 - entity.field_70163_u;
                    double newDistance = xDistance * xDistance + yDistance * yDistance + zDistance * zDistance;
                    if (distanceSq != -1.0 && newDistance > distanceSq) continue;
                    boolean valid = this.isValidPortalPosition(pos, checkX, checkY, checkZ, platformWidth, platformLength, spaceHeight, type);
                    if (valid) {
                        distanceSq = newDistance;
                        portalX = checkX;
                        portalY = checkY;
                        portalZ = checkZ;
                        continue;
                    }
                    if (distanceSq != -1.0 || fallbackDistanceSq != -1.0 && newDistance >= fallbackDistanceSq || !(valid = this.isValidPortalPosition(pos, checkX, checkY, checkZ, fallbackWidth, 1, fallbackSpaceHeight, type))) continue;
                    fallbackDistanceSq = newDistance;
                    fallbackX = checkX;
                    fallbackY = checkY;
                    fallbackZ = checkZ;
                }
            }
        }
        if (distanceSq == -1.0) {
            if (fallbackDistanceSq == -1.0) {
                portalX = entityX;
                portalY = MathHelper.func_76125_a((int)((int)entity.field_70163_u), (int)70, (int)(maxY - 10));
                portalZ = entityZ;
                for (int widthOffset = 0; widthOffset < platformWidth; ++widthOffset) {
                    for (int lengthOffset = 0; lengthOffset < platformLength; ++lengthOffset) {
                        Tuple<Integer, Integer> offsets = RPOTeleporter.getOffsets(type, widthOffset, lengthOffset);
                        int offsetX = portalX + (Integer)offsets.func_76341_a();
                        int offsetZ = portalZ + (Integer)offsets.func_76340_b();
                        BlockPos platformPos = new BlockPos(offsetX, portalY - 1, offsetZ);
                        savedData.addGeneratedNetherPortalFrame(platformPos, portalType);
                        int index = this.field_77187_a.nextInt(portalType.frame.blocks.size());
                        this.field_85192_a.func_180501_a(platformPos, portalType.frame.blocks.get(index).getActualState(), 2);
                        for (int yOffset = 0; yOffset < spaceHeight; ++yOffset) {
                            this.field_85192_a.func_180501_a((BlockPos)pos.func_181079_c(offsetX, portalY + yOffset, offsetZ), air, 2);
                        }
                    }
                }
            } else {
                portalX = fallbackX;
                portalY = fallbackY;
                portalZ = fallbackZ;
                width = 4;
                height = 5;
            }
        }
        BlockPos topLeft = new BlockPos(portalX, portalY, portalZ);
        if (type == FrameType.LATERAL) {
            topLeft = topLeft.func_177977_b();
        } else {
            topLeft = topLeft.func_177981_b(height - 2).func_177972_a(type == FrameType.VERTICAL_Z ? EnumFacing.EAST : EnumFacing.SOUTH);
            if (type == FrameType.VERTICAL_Z) {
                topLeft = topLeft.func_177970_e(width - 1);
            }
        }
        return topLeft;
    }

    private void clearAbove(Frame frame, IBlockState air) {
        BlockPos up;
        for (BlockPos pos : frame.getFrameBlockPositions()) {
            up = pos.func_177984_a();
            this.field_85192_a.func_175656_a(up, air);
            this.field_85192_a.func_175656_a(up.func_177984_a(), air);
        }
        for (BlockPos pos : frame.getInnerBlockPositions()) {
            up = pos.func_177984_a();
            this.field_85192_a.func_175656_a(up, air);
            this.field_85192_a.func_175656_a(up.func_177984_a(), air);
        }
    }

    public static boolean isSolidOrLiquid(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        return (material.func_76230_c() || material.func_76224_d()) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) && !state.func_177230_c().isFoliage((IBlockAccess)world, pos);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer serverWorld = (WorldServer)world;
        Teleporter teleporter = serverWorld.func_85176_s();
        if (!(teleporter instanceof RPOTeleporter)) {
            if (worldTeleporter == null) {
                worldTeleporter = TRLUtils.removeFinalModifier(ObfuscationReflectionHelper.findField(WorldServer.class, (String)"field_85177_Q"));
            }
            try {
                worldTeleporter.set(world, (Object)new RPOTeleporter(serverWorld));
            }
            catch (IllegalAccessException ex) {
                TRLUtils.crashReport("Failed to set Teleporter", ex);
            }
        }
    }

    private static Tuple<Integer, Integer> getOffsets(FrameType type, int widthOffset, int lengthOffset) {
        return type == FrameType.VERTICAL_Z ? new Tuple((Object)lengthOffset, (Object)widthOffset) : new Tuple((Object)widthOffset, (Object)lengthOffset);
    }

    private static /* synthetic */ boolean lambda$placeInExistingPortal$0(BlockPos required, Frame potentialFrame) {
        return potentialFrame.isInnerBlock(required);
    }
}

