/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.handler;

import com.therandomlabs.randomportals.block.RPOBlocks;
import com.therandomlabs.randomportals.config.RPOConfig;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class FrameHeadVillagerHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        double chance = RPOConfig.EndPortals.frameHeadVillagerSpawnChance;
        if (chance == 0.0) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.getClass() != EntityVillager.class) {
            return;
        }
        EntityVillager villager = (EntityVillager)entity;
        NBTTagCompound data = villager.getEntityData();
        if (data.func_74767_n("FrameHeadChecked")) {
            return;
        }
        data.func_74757_a("FrameHeadChecked", true);
        if (chance == 1.0 || villager.func_70681_au().nextDouble() <= chance) {
            villager.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Block)RPOBlocks.vertical_end_portal_frame));
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!RPOConfig.EndPortals.rightClickVillagersToConvertToFrameHeads) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() != ItemBlock.func_150898_a((Block)RPOBlocks.vertical_end_portal_frame)) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity.getClass() != EntityVillager.class) {
            return;
        }
        EntityVillager villager = (EntityVillager)entity;
        if (!villager.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
            return;
        }
        villager.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Block)RPOBlocks.vertical_end_portal_frame));
        if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        event.setCanceled(true);
        event.setCancellationResult(EnumActionResult.SUCCESS);
    }
}

